/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.io.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.wso2.carbon.uiserver.api.exception.UiServerRuntimeException;
import org.yaml.snakeyaml.Yaml;

public class MimeMapper {
    private static final String FILE_NAME_MIME_TYPES = "mime-types.yaml";
    private static Map<String, String> mimeTypes;

    private MimeMapper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> loadMimeTypes() throws UiServerRuntimeException {
        try (InputStream inputStream = MimeMapper.class.getClassLoader().getResourceAsStream(FILE_NAME_MIME_TYPES);){
            if (inputStream == null) {
                throw new UiServerRuntimeException("Cannot find MIME types file 'mime-types.yaml' in class path.");
            }
            Map map = (Map)new Yaml().loadAs(inputStream, Map.class);
            return map;
        }
        catch (IOException e) {
            throw new UiServerRuntimeException("Cannot read MIME types file 'mime-types.yaml'.", e);
        }
        catch (Exception e) {
            throw new UiServerRuntimeException("MIME types file is 'mime-types.yaml' is invalid.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<String> getMimeType(String extension) throws UiServerRuntimeException {
        if (mimeTypes != null) return Optional.ofNullable(mimeTypes.get(extension));
        Class<MimeMapper> clazz = MimeMapper.class;
        synchronized (MimeMapper.class) {
            if (mimeTypes != null) return Optional.ofNullable(mimeTypes.get(extension));
            mimeTypes = MimeMapper.loadMimeTypes();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Optional.ofNullable(mimeTypes.get(extension));
        }
    }
}

