/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states.http2;

import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.Http2OutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.http2.Http2SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.EntityBodyReceived;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ListenerState;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ReceivingEntityBody;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class ReceivingHeaders
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingHeaders.class);
    private final Http2SourceHandler http2SourceHandler;
    private final Http2MessageStateContext http2MessageStateContext;

    public ReceivingHeaders(Http2SourceHandler http2SourceHandler, Http2MessageStateContext http2MessageStateContext) {
        this.http2SourceHandler = http2SourceHandler;
        this.http2MessageStateContext = http2MessageStateContext;
    }

    @Override
    public void readInboundRequestHeaders(Http2HeadersFrame headersFrame) throws Http2Exception {
        int streamId = headersFrame.getStreamId();
        if (headersFrame.isEndOfStream()) {
            HttpCarbonMessage sourceReqCMsg = this.http2SourceHandler.getStreamIdRequestMap().get(streamId);
            if (sourceReqCMsg != null) {
                this.readTrailerHeaders(streamId, headersFrame.getHeaders(), sourceReqCMsg);
                this.http2SourceHandler.getStreamIdRequestMap().remove(streamId);
            } else if (headersFrame.getHeaders().contains((Object)":method")) {
                sourceReqCMsg = this.setupHttp2CarbonMsg(headersFrame.getHeaders(), streamId);
                sourceReqCMsg.addHttpContent((HttpContent)new DefaultLastHttpContent());
                Http2StateUtil.notifyRequestListener(this.http2SourceHandler, sourceReqCMsg, streamId);
            }
            this.http2MessageStateContext.setListenerState(new EntityBodyReceived(this.http2MessageStateContext));
        } else {
            HttpCarbonMessage sourceReqCMsg = this.setupHttp2CarbonMsg(headersFrame.getHeaders(), streamId);
            sourceReqCMsg.setHttp2MessageStateContext(this.http2MessageStateContext);
            this.http2SourceHandler.getStreamIdRequestMap().put(streamId, sourceReqCMsg);
            Http2StateUtil.notifyRequestListener(this.http2SourceHandler, sourceReqCMsg, streamId);
            this.http2MessageStateContext.setListenerState(new ReceivingEntityBody(this.http2MessageStateContext));
        }
    }

    @Override
    public void readInboundRequestBody(Http2SourceHandler http2SourceHandler, Http2DataFrame dataFrame) {
        LOG.warn("readInboundRequestBody is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseHeaders(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) {
        LOG.warn("writeOutboundResponseHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) {
        LOG.warn("writeOutboundResponseBody is not a dependant action of this state");
    }

    @Override
    public void writeOutboundPromise(Http2OutboundRespListener http2OutboundRespListener, Http2PushPromise pushPromise) {
        LOG.warn("writeOutboundPromise is not a dependant action of this state");
    }

    private void readTrailerHeaders(int streamId, Http2Headers headers, HttpCarbonMessage responseMessage) throws Http2Exception {
        HttpVersion version = new HttpVersion("HTTP/2.0", true);
        DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent();
        HttpHeaders trailers = lastHttpContent.trailingHeaders();
        HttpConversionUtil.addHttp2ToHttpHeaders((int)streamId, (Http2Headers)headers, (HttpHeaders)trailers, (HttpVersion)version, (boolean)true, (boolean)false);
        responseMessage.addHttpContent((HttpContent)lastHttpContent);
    }

    private HttpCarbonMessage setupHttp2CarbonMsg(Http2Headers http2Headers, int streamId) throws Http2Exception {
        return Http2StateUtil.setupCarbonRequest(Util.createHttpRequestFromHttp2Headers(http2Headers, streamId), this.http2SourceHandler);
    }
}

