/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.states.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.ReceivingHeaders;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.RequestCompleted;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.SenderState;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.SendingEntityBody;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SendingHeaders
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingHeaders.class);
    private final Http2TargetHandler http2TargetHandler;
    private final Http2TargetHandler.Http2RequestWriter http2RequestWriter;
    private final Http2MessageStateContext http2MessageStateContext;
    private final HttpCarbonMessage httpOutboundRequest;
    private final OutboundMsgHolder outboundMsgHolder;
    private final Http2Connection connection;
    private final Http2ConnectionEncoder encoder;
    private final Http2ClientChannel http2ClientChannel;
    private int streamId;

    public SendingHeaders(Http2TargetHandler http2TargetHandler, Http2TargetHandler.Http2RequestWriter http2RequestWriter) {
        this.http2TargetHandler = http2TargetHandler;
        this.http2RequestWriter = http2RequestWriter;
        this.http2MessageStateContext = http2RequestWriter.getHttp2MessageStateContext();
        this.httpOutboundRequest = http2RequestWriter.getHttpOutboundRequest();
        this.outboundMsgHolder = http2RequestWriter.getOutboundMsgHolder();
        this.connection = http2TargetHandler.getConnection();
        this.encoder = http2TargetHandler.getEncoder();
        this.http2ClientChannel = http2TargetHandler.getHttp2ClientChannel();
    }

    @Override
    public void writeOutboundRequestHeaders(ChannelHandlerContext ctx, HttpContent httpContent) throws Http2Exception {
        this.writeHeaders(ctx, httpContent);
    }

    @Override
    public void writeOutboundRequestBody(ChannelHandlerContext ctx, HttpContent httpContent, Http2MessageStateContext http2MessageStateContext) throws Http2Exception {
        this.writeOutboundRequestHeaders(ctx, httpContent);
    }

    @Override
    public void readInboundResponseHeaders(ChannelHandlerContext ctx, Http2HeadersFrame http2HeadersFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) {
        outboundMsgHolder.getRequest().setIoException(new IOException("Inbound response message already received"));
        http2MessageStateContext.setSenderState(new ReceivingHeaders(this.http2TargetHandler, this.http2RequestWriter));
        http2MessageStateContext.getSenderState().readInboundResponseHeaders(ctx, http2HeadersFrame, outboundMsgHolder, serverPush, http2MessageStateContext);
    }

    @Override
    public void readInboundResponseBody(ChannelHandlerContext ctx, Http2DataFrame http2DataFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) {
        LOG.warn("readInboundResponseEntityBody is not a dependant action of this state");
    }

    @Override
    public void readInboundPromise(Http2PushPromise http2PushPromise, OutboundMsgHolder outboundMsgHolder) {
        LOG.warn("readInboundPromise is not a dependant action of this state");
    }

    private void writeHeaders(ChannelHandlerContext ctx, HttpContent msg) throws Http2Exception {
        boolean endStream = false;
        this.streamId = Http2StateUtil.initiateStream(ctx, this.connection, this.http2ClientChannel, this.outboundMsgHolder);
        this.http2RequestWriter.setStreamId(this.streamId);
        HttpRequest httpRequest = Util.createHttpRequest(this.httpOutboundRequest);
        if (msg instanceof LastHttpContent && msg.content().capacity() == 0) {
            endStream = true;
        }
        this.writeOutboundRequestHeaders(ctx, (HttpMessage)httpRequest, endStream);
        if (endStream) {
            this.http2MessageStateContext.setSenderState(new RequestCompleted(this.http2TargetHandler, this.http2RequestWriter));
        } else {
            this.http2MessageStateContext.setSenderState(new SendingEntityBody(this.http2TargetHandler, this.http2RequestWriter));
            this.http2MessageStateContext.getSenderState().writeOutboundRequestBody(ctx, msg, this.http2MessageStateContext);
        }
    }

    private void writeOutboundRequestHeaders(ChannelHandlerContext ctx, HttpMessage httpMsg, boolean endStream) throws Http2Exception {
        httpMsg.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers((HttpMessage)httpMsg, (boolean)true);
        Http2StateUtil.writeHttp2Headers(ctx, this.outboundMsgHolder, this.http2ClientChannel, this.encoder, this.streamId, httpMsg.headers(), http2Headers, endStream);
    }
}

