/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorException;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlSignal;
import org.wso2.transport.http.netty.contract.websocket.WebSocketFrameType;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;
import org.wso2.transport.http.netty.contractimpl.listener.MessageQueueHandler;
import org.wso2.transport.http.netty.contractimpl.websocket.DefaultWebSocketConnection;
import org.wso2.transport.http.netty.contractimpl.websocket.DefaultWebSocketMessage;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketUtil;
import org.wso2.transport.http.netty.contractimpl.websocket.message.DefaultWebSocketCloseMessage;
import org.wso2.transport.http.netty.contractimpl.websocket.message.DefaultWebSocketControlMessage;

public class WebSocketInboundFrameHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketInboundFrameHandler.class);
    private final boolean isServer;
    private final boolean secureConnection;
    private final String target;
    private final String negotiatedSubProtocol;
    private final WebSocketConnectorFuture connectorFuture;
    private final MessageQueueHandler messageQueueHandler;
    private boolean caughtException;
    private boolean closeFrameReceived;
    private boolean closeInitialized;
    private DefaultWebSocketConnection webSocketConnection;
    private ChannelPromise closePromise;
    private WebSocketFrameType continuationFrameType;

    public WebSocketInboundFrameHandler(boolean isServer, boolean secureConnection, String target, String negotiatedSubProtocol, WebSocketConnectorFuture connectorFuture, MessageQueueHandler messageQueueHandler) {
        this.isServer = isServer;
        this.secureConnection = secureConnection;
        this.target = target;
        this.negotiatedSubProtocol = negotiatedSubProtocol;
        this.connectorFuture = connectorFuture;
        this.messageQueueHandler = messageQueueHandler;
        this.closeInitialized = false;
    }

    public void setClosePromise(ChannelPromise closePromise) {
        this.closePromise = closePromise;
    }

    public DefaultWebSocketConnection getWebSocketConnection() {
        return this.webSocketConnection;
    }

    public boolean isCloseFrameReceived() {
        return this.closeFrameReceived;
    }

    public void setCloseInitialized(boolean closeInitialized) {
        this.closeInitialized = closeInitialized;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.webSocketConnection = new DefaultWebSocketConnection(ctx, this, this.messageQueueHandler, this.secureConnection, this.negotiatedSubProtocol);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws WebSocketConnectorException {
        if (evt instanceof IdleStateEvent) {
            this.notifyIdleTimeout();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws WebSocketConnectorException {
        if (!(this.caughtException || this.webSocketConnection == null || this.closeFrameReceived || this.closePromise != null || this.closeInitialized)) {
            DefaultWebSocketCloseMessage webSocketCloseMessage = new DefaultWebSocketCloseMessage(1006);
            this.setupCommonProperties(webSocketCloseMessage);
            this.connectorFuture.notifyWebSocketListener(webSocketCloseMessage);
            return;
        }
        if (this.closePromise != null && !this.closeFrameReceived) {
            String errMsg = "Connection is closed by remote endpoint without echoing a close frame";
            ctx.close().addListener(closeFuture -> this.closePromise.setFailure((Throwable)new IllegalStateException(errMsg)));
        }
        this.connectorFuture.notifyWebSocketListener(this.webSocketConnection);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof TextWebSocketFrame) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)msg;
            if (!textFrame.isFinalFragment()) {
                this.continuationFrameType = WebSocketFrameType.TEXT;
            }
            this.notifyTextMessage((WebSocketFrame)textFrame, textFrame.text(), textFrame.isFinalFragment());
        } else if (msg instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)msg;
            if (!binaryFrame.isFinalFragment()) {
                this.continuationFrameType = WebSocketFrameType.BINARY;
            }
            this.notifyBinaryMessage((WebSocketFrame)binaryFrame, binaryFrame.content(), binaryFrame.isFinalFragment());
        } else if (msg instanceof CloseWebSocketFrame) {
            this.closeFrameReceived = true;
            this.notifyCloseMessage((CloseWebSocketFrame)msg);
        } else if (msg instanceof PingWebSocketFrame) {
            this.notifyPingMessage((PingWebSocketFrame)msg);
        } else if (msg instanceof PongWebSocketFrame) {
            this.notifyPongMessage((PongWebSocketFrame)msg);
        } else if (msg instanceof ContinuationWebSocketFrame) {
            ContinuationWebSocketFrame frame = (ContinuationWebSocketFrame)msg;
            if (this.continuationFrameType == WebSocketFrameType.TEXT) {
                this.notifyTextMessage((WebSocketFrame)frame, frame.text(), frame.isFinalFragment());
            } else if (this.continuationFrameType == WebSocketFrameType.BINARY) {
                this.notifyBinaryMessage((WebSocketFrame)frame, frame.content(), frame.isFinalFragment());
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws WebSocketConnectorException {
        this.caughtException = true;
        if (!(cause instanceof CorruptedFrameException)) {
            ChannelFuture closeFrameFuture = ctx.channel().writeAndFlush((Object)new CloseWebSocketFrame(1011, "Encountered an unexpected condition"));
            closeFrameFuture.addListener(future -> ctx.close().addListener(closeFuture -> this.connectorFuture.notifyWebSocketListener(this.webSocketConnection, cause)));
            return;
        }
        String msg = cause.getMessage();
        if (msg != null && msg.contains("UTF-8")) {
            ChannelFuture closeFrameFuture = ctx.channel().writeAndFlush((Object)new CloseWebSocketFrame(1007, "Invalid UTF-8 frame received"));
            closeFrameFuture.addListener(future -> ctx.close().addListener(closeFuture -> this.connectorFuture.notifyWebSocketListener(this.webSocketConnection, cause)));
        }
        this.connectorFuture.notifyWebSocketListener(this.webSocketConnection, cause);
    }

    private void notifyTextMessage(WebSocketFrame frame, String text, boolean finalFragment) throws WebSocketConnectorException {
        DefaultWebSocketMessage webSocketTextMessage = WebSocketUtil.getWebSocketMessage(frame, text, finalFragment);
        this.setupCommonProperties(webSocketTextMessage);
        this.connectorFuture.notifyWebSocketListener((WebSocketTextMessage)((Object)webSocketTextMessage));
    }

    private void notifyBinaryMessage(WebSocketFrame frame, ByteBuf content, boolean finalFragment) throws WebSocketConnectorException {
        DefaultWebSocketMessage webSocketBinaryMessage = WebSocketUtil.getWebSocketMessage(frame, content, finalFragment);
        this.setupCommonProperties(webSocketBinaryMessage);
        this.connectorFuture.notifyWebSocketListener((WebSocketBinaryMessage)((Object)webSocketBinaryMessage));
    }

    private void notifyCloseMessage(CloseWebSocketFrame closeWebSocketFrame) throws WebSocketConnectorException {
        String reasonText = closeWebSocketFrame.reasonText();
        int statusCode = closeWebSocketFrame.statusCode();
        if (statusCode == -1) {
            statusCode = 1005;
        }
        if (this.closePromise == null) {
            DefaultWebSocketCloseMessage webSocketCloseMessage = new DefaultWebSocketCloseMessage(statusCode, reasonText);
            this.setupCommonProperties(webSocketCloseMessage);
            this.connectorFuture.notifyWebSocketListener(webSocketCloseMessage);
        } else {
            if (this.webSocketConnection.getCloseInitiatedStatusCode() != statusCode) {
                String errMsg = String.format("Expected status code %d but found %d in echoed close frame from remote endpoint", this.webSocketConnection.getCloseInitiatedStatusCode(), statusCode);
                this.closePromise.setFailure((Throwable)new IllegalStateException(errMsg));
                return;
            }
            this.closePromise.setSuccess();
        }
        closeWebSocketFrame.release();
    }

    private void notifyPingMessage(PingWebSocketFrame pingWebSocketFrame) throws WebSocketConnectorException {
        WebSocketControlMessage webSocketControlMessage = WebSocketUtil.getWebSocketControlMessage((WebSocketFrame)pingWebSocketFrame, WebSocketControlSignal.PING);
        this.setupCommonProperties((DefaultWebSocketMessage)((Object)webSocketControlMessage));
        this.connectorFuture.notifyWebSocketListener(webSocketControlMessage);
    }

    private void notifyPongMessage(PongWebSocketFrame pongWebSocketFrame) throws WebSocketConnectorException {
        WebSocketControlMessage webSocketControlMessage = WebSocketUtil.getWebSocketControlMessage((WebSocketFrame)pongWebSocketFrame, WebSocketControlSignal.PONG);
        this.setupCommonProperties((DefaultWebSocketMessage)((Object)webSocketControlMessage));
        this.connectorFuture.notifyWebSocketListener(webSocketControlMessage);
    }

    private void notifyIdleTimeout() throws WebSocketConnectorException {
        DefaultWebSocketControlMessage webSocketControlMessage = new DefaultWebSocketControlMessage(WebSocketControlSignal.IDLE_TIMEOUT, null);
        this.setupCommonProperties(webSocketControlMessage);
        this.connectorFuture.notifyWebSocketIdleTimeout(webSocketControlMessage);
    }

    private void setupCommonProperties(DefaultWebSocketMessage webSocketMessage) {
        webSocketMessage.setTarget(this.target);
        webSocketMessage.setWebSocketConnection(this.webSocketConnection);
        webSocketMessage.setIsServerMessage(this.isServer);
    }
}

