/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.datasource.core.exception.DataSourceException;

public class DataSourceUtils {
    private static Logger logger = LoggerFactory.getLogger(DataSourceUtils.class);
    private static final String[] CLASS_RETURN_TYPES = new String[]{"String", "Byte", "Character", "Short", "Integer", "Float", "Double", "Character", "Boolean"};

    public static boolean nullAllowEquals(Object lhs, Object rhs) {
        return lhs == null && rhs == null || (lhs != null || rhs == null) && (lhs == null || rhs != null) && lhs != null && lhs.equals(rhs);
    }

    public static Map<String, String> extractPrimitiveFieldNameValuePairs(Object object) throws DataSourceException {
        Method[] methods;
        HashMap<String, String> nameValueMap = new HashMap<String, String>();
        for (Method method : methods = object.getClass().getMethods()) {
            if (!DataSourceUtils.isMethodMatched(method)) continue;
            String fieldName = DataSourceUtils.getFieldNameFromMethodName(method.getName());
            try {
                if (method.invoke(object, new Object[0]) == null) continue;
                String result = method.invoke(object, new Object[0]).toString();
                nameValueMap.put(fieldName, result);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new DataSourceException("Error in retrieving " + fieldName + " value from the object :" + object.getClass() + e.getMessage(), e);
            }
        }
        return nameValueMap;
    }

    private static String getFieldNameFromMethodName(String name) throws DataSourceException {
        String firstLetter;
        String prefixGet = "get";
        String prefixIs = "is";
        if (name.startsWith(prefixGet)) {
            firstLetter = name.substring(3, 4);
            name = name.substring(4);
        } else if (name.startsWith(prefixIs)) {
            firstLetter = name.substring(2, 3);
            name = name.substring(3);
        } else {
            throw new DataSourceException("Error in retrieving attribute name from method : " + name);
        }
        firstLetter = firstLetter.toLowerCase(Locale.getDefault());
        return firstLetter.concat(name);
    }

    private static boolean isMethodMatched(Method method) {
        String returnType = method.getReturnType().getSimpleName();
        String methodName = method.getName();
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (returnType.equals("void")) {
            return false;
        }
        if (!(methodName.startsWith("get") || methodName.startsWith("is") && (returnType.equals("Boolean") || returnType.equals("boolean")))) {
            return false;
        }
        return method.getReturnType().isPrimitive() || Arrays.asList(CLASS_RETURN_TYPES).contains(returnType);
    }
}

