/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.jdbc.core.config.model;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.config.annotation.Configuration;
import org.wso2.carbon.config.annotation.Element;
import org.wso2.carbon.metrics.jdbc.core.config.model.JdbcScheduledCleanupConfig;

@Configuration(description="Data Source Configuration")
public class DataSourceConfig {
    @Element(description="The \"lookupDataSource\" flag specifies whether the datasource should be looked up via JNDI. If this is set to true, the data source should be configured. If this is set to false, the datasource will be created by the properties defined in dataSourceProperties.")
    private boolean lookupDataSource = true;
    @Element(description="JNDI name of the data source to be used by the JDBC Reporter.")
    private String dataSourceName = "java:comp/env/jdbc/WSO2MetricsDB";
    private JdbcScheduledCleanupConfig scheduledCleanup = new JdbcScheduledCleanupConfig();
    private Map<String, String> dataSourceProperties = new HashMap<String, String>();

    public boolean isLookupDataSource() {
        return this.lookupDataSource;
    }

    public void setLookupDataSource(boolean lookupDataSource) {
        this.lookupDataSource = lookupDataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public JdbcScheduledCleanupConfig getScheduledCleanup() {
        return this.scheduledCleanup;
    }

    public void setScheduledCleanup(JdbcScheduledCleanupConfig scheduledCleanup) {
        this.scheduledCleanup = scheduledCleanup;
    }

    public Map<String, String> getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public void setDataSourceProperties(Map<String, String> dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
    }
}

