/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core;

import java.lang.reflect.Method;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.metrics.core.Meter;
import org.wso2.carbon.metrics.core.MetricService;
import org.wso2.carbon.metrics.core.Timer;
import org.wso2.carbon.metrics.core.annotation.Counted;
import org.wso2.carbon.metrics.core.annotation.Metered;
import org.wso2.carbon.metrics.core.annotation.Timed;

public final class MetricAnnotation {
    private MetricAnnotation() {
    }

    private static String buildName(String explicitName, boolean absolute, Method method) {
        if (explicitName != null && !explicitName.isEmpty()) {
            if (absolute) {
                return explicitName;
            }
            return MetricService.name(method.getDeclaringClass().getName(), method.getName(), explicitName);
        }
        return MetricService.name(method.getDeclaringClass().getName(), method.getName());
    }

    private static Level toLevel(org.wso2.carbon.metrics.core.annotation.Level level) {
        Level returnLevel = Level.INFO;
        switch (level) {
            case OFF: {
                returnLevel = Level.OFF;
                break;
            }
            case INFO: {
                returnLevel = Level.INFO;
                break;
            }
            case DEBUG: {
                returnLevel = Level.DEBUG;
                break;
            }
            case TRACE: {
                returnLevel = Level.TRACE;
                break;
            }
            case ALL: {
                returnLevel = Level.ALL;
            }
        }
        return returnLevel;
    }

    public static Counter counter(MetricService metricService, Counted annotation, Method method) {
        return metricService.counter(MetricAnnotation.buildName(annotation.name(), annotation.absolute(), method), MetricAnnotation.toLevel(annotation.level()), new Level[0]);
    }

    public static Meter meter(MetricService metricService, Metered annotation, Method method) {
        return metricService.meter(MetricAnnotation.buildName(annotation.name(), annotation.absolute(), method), MetricAnnotation.toLevel(annotation.level()), new Level[0]);
    }

    public static Timer timer(MetricService metricService, Timed annotation, Method method) {
        return metricService.timer(MetricAnnotation.buildName(annotation.name(), annotation.absolute(), method), MetricAnnotation.toLevel(annotation.level()));
    }
}

