/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jndi.internal.osgi;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.DirContext;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jndi.JNDIContextManager;
import org.wso2.carbon.jndi.internal.osgi.WrapperContext;
import org.wso2.carbon.jndi.internal.util.JNDIUtils;

public class JNDIContextManagerImpl
implements JNDIContextManager {
    private static final String OBJECT_CLASS = "objectClass";
    private BundleContext bundleContext;

    public JNDIContextManagerImpl(BundleContext bundleContext, ServiceRegistration<JNDIContextManager> serviceRegistration) {
        this.bundleContext = bundleContext;
    }

    @Override
    public Context newInitialContext() throws NamingException {
        Hashtable environment = new Hashtable();
        Optional<Context> initialContextInternal = this.getInitialContextInternal(environment);
        return new WrapperContext(this.bundleContext, initialContextInternal, environment);
    }

    public Context newInitialContext(Map environment) throws NamingException {
        Hashtable envMap = new Hashtable(environment);
        Optional<Context> initialContextInternal = this.getInitialContextInternal(envMap);
        return new WrapperContext(this.bundleContext, initialContextInternal, envMap);
    }

    @Override
    public DirContext newInitialDirContext() throws NamingException {
        return null;
    }

    public DirContext newInitialDirContext(Map map) throws NamingException {
        return null;
    }

    private Optional<Context> getInitialContextInternal(Hashtable<?, ?> environment) throws NamingException {
        String userDefinedICFClassName = (String)environment.get("java.naming.factory.initial");
        if (userDefinedICFClassName != null && !"".equals(userDefinedICFClassName)) {
            Collection<ServiceReference<InitialContextFactory>> factorySRefCollection = JNDIUtils.getServiceReferences(this.bundleContext, InitialContextFactory.class, this.getServiceFilter(userDefinedICFClassName));
            Optional<Context> initialContextOptional = JNDIUtils.getInitialContextFromFactory(this.bundleContext, factorySRefCollection, environment);
            if (initialContextOptional.isPresent()) {
                return initialContextOptional;
            }
            Collection<ServiceReference<InitialContextFactoryBuilder>> serviceRefCollection = JNDIUtils.getServiceReferences(this.bundleContext, InitialContextFactoryBuilder.class, null);
            initialContextOptional = JNDIUtils.getInitialContextFromBuilder(this.bundleContext, serviceRefCollection, environment);
            initialContextOptional.orElseThrow(() -> new NoInitialContextException("Cannot find the InitialContextFactory " + userDefinedICFClassName + "."));
            return initialContextOptional;
        }
        Collection<ServiceReference<InitialContextFactoryBuilder>> builderSRefCollection = JNDIUtils.getServiceReferences(this.bundleContext, InitialContextFactoryBuilder.class, null);
        Optional<Context> initialContextOptional = JNDIUtils.getInitialContextFromBuilder(this.bundleContext, builderSRefCollection, environment);
        if (initialContextOptional.isPresent()) {
            return initialContextOptional;
        }
        Collection<ServiceReference<InitialContextFactory>> factorySRefCollection = JNDIUtils.getServiceReferences(this.bundleContext, InitialContextFactory.class, null);
        initialContextOptional = JNDIUtils.getInitialContextFromFactory(this.bundleContext, factorySRefCollection, environment);
        return initialContextOptional;
    }

    private String getServiceFilter(String userDefinedICFClassName) {
        return "(&(objectClass=" + userDefinedICFClassName + ")" + "(" + OBJECT_CLASS + "=" + InitialContextFactory.class.getName() + ")" + ")";
    }
}

