/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jndi.internal.osgi;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OSGiServiceNamingEnumeration
implements NamingEnumeration<NameClassPair> {
    private BundleContext bundleContext;
    private int currentIndex = 0;
    private List<NameClassPair> nameClassPairList;

    public OSGiServiceNamingEnumeration(BundleContext bundleContext, List<ServiceReference> refs) {
        this.bundleContext = bundleContext;
        this.nameClassPairList = this.buildNameClassPair(refs);
    }

    private List<NameClassPair> buildNameClassPair(List<ServiceReference> serviceReferencesList) {
        Predicate<ServiceReference> filterNotNullReferences = reference -> this.bundleContext.getService(reference) != null;
        return serviceReferencesList.stream().filter(filterNotNullReferences).map(this::buildNameClassPair).collect(Collectors.toList());
    }

    private NameClassPair buildNameClassPair(ServiceReference serviceReference) {
        NameClassPair nameClassPair = new NameClassPair(String.valueOf(serviceReference.getProperty("service.id")), this.bundleContext.getService(serviceReference).getClass().getName());
        this.bundleContext.ungetService(serviceReference);
        return nameClassPair;
    }

    @Override
    public NameClassPair next() throws NamingException {
        return this.nextElement();
    }

    @Override
    public boolean hasMore() throws NamingException {
        return this.hasMoreElements();
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public boolean hasMoreElements() {
        return this.currentIndex < this.nameClassPairList.size();
    }

    @Override
    public NameClassPair nextElement() {
        return this.nameClassPairList.get(this.currentIndex++);
    }
}

