/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tools;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.carbon.tools.CarbonTool;
import org.wso2.carbon.tools.converter.BundleGeneratorTool;
import org.wso2.carbon.tools.exception.CarbonToolException;
import org.wso2.carbon.tools.osgilib.OSGiLibDeployerTool;
import org.wso2.carbon.tools.spi.ICFProviderTool;

public class CarbonToolExecutor {
    private static final Logger logger = Logger.getLogger(CarbonToolExecutor.class.getName());

    public static void main(String[] args) {
        String toolIdentifier = System.getProperty("wso2.carbon.tool");
        Optional.ofNullable(toolIdentifier).ifPresent(identifier -> {
            try {
                CarbonToolExecutor.executeTool(identifier, args);
            }
            catch (CarbonToolException e) {
                logger.log(Level.SEVERE, "An error has occurred when executing the Carbon tool", e);
            }
        });
    }

    private static void executeTool(String toolIdentifier, String ... toolArgs) throws CarbonToolException {
        CarbonTool carbonTool;
        if (toolIdentifier == null) {
            throw new CarbonToolException("The Carbon tool identifier cannot be null");
        }
        switch (toolIdentifier) {
            case "jar-to-bundle-converter": {
                carbonTool = new BundleGeneratorTool();
                break;
            }
            case "osgi-lib-deployer": {
                carbonTool = new OSGiLibDeployerTool();
                break;
            }
            case "icf-provider": {
                carbonTool = new ICFProviderTool();
                break;
            }
            default: {
                carbonTool = null;
            }
        }
        if (carbonTool != null) {
            carbonTool.execute(toolArgs);
        }
    }
}

