/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.engine.internal;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.deployment.engine.Deployer;
import org.wso2.carbon.deployment.engine.DeploymentService;
import org.wso2.carbon.deployment.engine.LifecycleListener;
import org.wso2.carbon.deployment.engine.config.DeploymentConfiguration;
import org.wso2.carbon.deployment.engine.exception.DeployerRegistrationException;
import org.wso2.carbon.deployment.engine.exception.DeploymentEngineException;
import org.wso2.carbon.deployment.engine.internal.CarbonDeploymentService;
import org.wso2.carbon.deployment.engine.internal.DataHolder;
import org.wso2.carbon.deployment.engine.internal.DeploymentEngine;
import org.wso2.carbon.deployment.engine.internal.OSGiServiceHolder;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.kernel.startupresolver.StartupServiceUtils;

@Component(name="org.wso2.carbon.deployment.engine.internal.DeploymentEngineListenerComponent", immediate=true, property={"componentName=carbon-deployment-service"})
public class DeploymentEngineListenerComponent
implements RequiredCapabilityListener {
    public static final String COMPONENT_NAME = "carbon-deployment-service";
    private static final Logger logger = LoggerFactory.getLogger(DeploymentEngineListenerComponent.class);
    private DeploymentEngine deploymentEngine = new DeploymentEngine();
    private ServiceRegistration serviceRegistration;

    @Activate
    public void start(BundleContext bundleContext) throws Exception {
        DataHolder.getInstance().setBundleContext(bundleContext);
    }

    @Deactivate
    public void stop() throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @Reference(name="carbon.deployer.service", service=Deployer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDeployer")
    protected void registerDeployer(Deployer deployer) {
        try {
            this.deploymentEngine.registerDeployer(deployer);
            StartupServiceUtils.updateServiceCache((String)COMPONENT_NAME, Deployer.class);
        }
        catch (DeployerRegistrationException e) {
            logger.error("Error while adding deployer to the deployment engine", (Throwable)e);
        }
    }

    protected void unregisterDeployer(Deployer deployer) {
        try {
            this.deploymentEngine.unregisterDeployer(deployer);
        }
        catch (DeploymentEngineException e) {
            logger.error("Error while removing deployer from deployment engine", (Throwable)e);
        }
    }

    @Reference(name="carbon.deployment.listener.service", service=LifecycleListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDeploymentListener")
    protected void registerDeploymentListener(LifecycleListener listener) {
        logger.debug("Received LifecycleListener {} ", (Object)listener.getClass().getName());
        this.deploymentEngine.registerDeploymentLifecycleListener(listener);
        StartupServiceUtils.updateServiceCache((String)COMPONENT_NAME, LifecycleListener.class);
    }

    protected void unregisterDeploymentListener(LifecycleListener listener) {
        this.deploymentEngine.unregisterDeploymentLifecycleListener(listener);
    }

    @Reference(name="carbon.runtime.service", service=CarbonRuntime.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterCarbonRuntime")
    protected void registerCarbonRuntime(CarbonRuntime carbonRuntime) {
        DataHolder.getInstance().setCarbonRuntime(carbonRuntime);
    }

    protected void unregisterCarbonRuntime(CarbonRuntime carbonRuntime) {
        DataHolder.getInstance().setCarbonRuntime(null);
    }

    @Reference(name="carbon.config.provider", service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterConfigProvider")
    protected void registerConfigProvider(ConfigProvider configProvider) {
        DataHolder.getInstance().setConfigProvider(configProvider);
    }

    protected void unregisterConfigProvider(ConfigProvider configProvider) {
        DataHolder.getInstance().setConfigProvider(null);
    }

    public void onAllRequiredCapabilitiesAvailable() {
        try {
            DeploymentConfiguration deploymentConfiguration = (DeploymentConfiguration)DataHolder.getInstance().getConfigProvider().getConfigurationObject(DeploymentConfiguration.class);
            DataHolder.getInstance().setDeploymentConfiguration(deploymentConfiguration);
            logger.debug("Starting Carbon Deployment Engine");
            this.deploymentEngine.start(deploymentConfiguration.getServerRepositoryLocation(), deploymentConfiguration.getRuntimeRepositoryLocation());
            OSGiServiceHolder.getInstance().setCarbonDeploymentEngine(this.deploymentEngine);
            CarbonDeploymentService deploymentService = new CarbonDeploymentService(this.deploymentEngine);
            BundleContext bundleContext = DataHolder.getInstance().getBundleContext();
            this.serviceRegistration = bundleContext.registerService(DeploymentService.class.getName(), (Object)deploymentService, null);
            logger.debug("Carbon Deployment Engine is successfully started");
        }
        catch (DeploymentEngineException e) {
            String msg = "Could not initialize carbon deployment engine";
            logger.error(msg, (Throwable)e);
        }
        catch (ConfigurationException e) {
            String msg = "Fail to load deployment configuration";
            logger.error(msg, (Throwable)e);
        }
    }
}

