/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.secvault.ciphertool;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.secvault.ciphertool.exceptions.CipherToolException;
import org.wso2.carbon.secvault.ciphertool.exceptions.CipherToolRuntimeException;
import org.wso2.carbon.secvault.ciphertool.utils.CommandLineParser;
import org.wso2.carbon.secvault.ciphertool.utils.Utils;

public class CipherToolInitializer {
    private static final Logger logger = LoggerFactory.getLogger(CipherToolInitializer.class.getName());

    private CipherToolInitializer() {
    }

    public static void main(String[] args) {
        CipherToolInitializer.execute(args);
    }

    public static void execute(String ... toolArgs) {
        CommandLineParser commandLineParser;
        try {
            commandLineParser = Utils.createCommandLineParser(toolArgs);
        }
        catch (CipherToolException e) {
            logger.error("Unable to run CipherTool", e);
            CipherToolInitializer.printHelpMessage();
            throw new CipherToolRuntimeException("Unable to run CipherTool", e);
        }
        URLClassLoader urlClassLoader = Utils.getCustomClassLoader(commandLineParser.getCustomLibPath());
        String customConfigPath = commandLineParser.getRuntime().isPresent() ? null : commandLineParser.getCustomConfigPath().orElseThrow(() -> new CipherToolRuntimeException("Secure Vault configuration file path or runtime is not provided."));
        String commandName = commandLineParser.getCommandName().orElse("");
        String commandParam = commandLineParser.getCommandParam().orElse("");
        try {
            String runtime = commandLineParser.getRuntime().orElseGet(() -> {
                logger.debug("Runtime is not provided.");
                return "";
            });
            if ("ALL".equals(runtime)) {
                String carbonHome = System.getProperty("carbon.home");
                if (carbonHome == null) {
                    throw new CipherToolRuntimeException("Unable to run ciphertool in all runtimes, carbon home is not set");
                }
                org.wso2.carbon.utils.Utils.getCarbonRuntimes().forEach(carbonRuntime -> {
                    try {
                        System.setProperty("wso2.runtime", carbonRuntime);
                        Object objCipherTool = Utils.createCipherTool(urlClassLoader, org.wso2.carbon.utils.Utils.getRuntimeConfigPath().resolve("deployment.yaml"));
                        CipherToolInitializer.processCommand(commandName, commandParam, objCipherTool);
                        if (commandLineParser.getCommandName().isPresent()) {
                            logger.info("Command: " + commandName + " executed successfully in runtime: " + carbonRuntime);
                        } else {
                            logger.info("Secrets encrypted successfully in runtime: " + carbonRuntime);
                        }
                    }
                    catch (CipherToolException e) {
                        throw new CipherToolRuntimeException("Error while running ciphertool in all runtimes.", e);
                    }
                });
            } else {
                System.setProperty("wso2.runtime", runtime);
                Path secureVaultConfigPath = customConfigPath == null ? org.wso2.carbon.utils.Utils.getRuntimeConfigPath().resolve("deployment.yaml") : Paths.get(customConfigPath, new String[0]);
                Object objCipherTool = Utils.createCipherTool(urlClassLoader, secureVaultConfigPath);
                CipherToolInitializer.processCommand(commandName, commandParam, objCipherTool);
                if (logger.isDebugEnabled()) {
                    if (commandLineParser.getCommandName().isPresent()) {
                        logger.debug("Command: " + commandName + " executed successfully with configuration file path: " + secureVaultConfigPath.toString());
                    } else {
                        logger.debug("Secrets encrypted successfully with configuration file path: " + secureVaultConfigPath.toString());
                    }
                }
            }
        }
        catch (IOException | CipherToolException e) {
            throw new CipherToolRuntimeException("Unable to run CipherTool", e);
        }
    }

    private static void processCommand(String command, String parameter, Object objCipherTool) throws CipherToolException {
        try {
            switch (command) {
                case "-encryptText": {
                    Method method = objCipherTool.getClass().getMethod("encryptText", String.class);
                    method.invoke(objCipherTool, parameter);
                    break;
                }
                case "-decryptText": {
                    Method method = objCipherTool.getClass().getMethod("decryptText", String.class);
                    method.invoke(objCipherTool, parameter);
                    break;
                }
                default: {
                    Method method = objCipherTool.getClass().getMethod("encryptSecrets", new Class[0]);
                    method.invoke(objCipherTool, new Object[0]);
                    break;
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CipherToolException("Failed to execute Cipher Tool command", e);
        }
    }

    private static void printHelpMessage() {
        logger.info("\nIncorrect usage of the cipher tool.\n\nInstructions: sh ciphertool.sh [<command> <parameter>]\n\nCommand line options should be provided. If you pass the runtime, CipherTool will encrypt the \nsecrets given in the [CARBON_HOME]/conf/${runtime}/secrets.properties file.\nIf you need to encrypt secrets in all runtimes, You need to pass command as -runtime ALLCipherTool will read the configurations from deployment.yaml file. Hence it is mandatory\nto update the [CARBON_HOME]/conf/${runtime}/deployment.yaml file before running CipherTool\n\nUsages:\n\n1. If you runtime as -runtime XxXx, cipher tool will encrypt the secrets given in the\n   [CARBON_HOME]conf/XxXx/secrets.properties file.\n     Eg: ciphertool.sh -runtime XxXx\n\n2. If you need to encrypt secrets in all runtimes, you need to pass command as -runtime ALL\n     Eg: ciphertool.sh -runtime ALL\n\n3. -encryptText : this option will first encrypt a given text and then prints the base64 encoded\n   string of the encoded cipher text in the console.\n     Eg: ciphertool.sh -encryptText Abc@123 -runtime XxXx\n\n4. -decryptText : this option accepts base64 encoded cipher text and prints the decoded plain text\n   in the console.\n     Eg: ciphertool.sh -decryptText XxXxXx -runtime XxXx\n");
    }
}

