/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.config;

import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.config.provider.ConfigProviderImpl;
import org.wso2.carbon.config.reader.YAMLBasedConfigFileReader;
import org.wso2.carbon.secvault.SecureVault;
import org.wso2.carbon.secvault.SecureVaultFactory;
import org.wso2.carbon.secvault.exception.SecureVaultException;

public class ConfigProviderFactory {
    private static final String YAML_EXTENSION = ".yaml";
    private static Logger logger = LoggerFactory.getLogger(ConfigProviderFactory.class);

    public static ConfigProvider getConfigProvider(Path filePath) throws ConfigurationException {
        return ConfigProviderFactory.getConfigProvider(filePath, ConfigProviderFactory.getSecureVault(filePath));
    }

    public static ConfigProvider getConfigProvider(Path filePath, SecureVault secureVault) throws ConfigurationException {
        if (filePath == null || !filePath.toFile().exists()) {
            throw new ConfigurationException("No configuration filepath is provided. configuration provider will not be initialized!");
        }
        if (secureVault == null) {
            logger.debug("No securevault service found. configuration provider will not be initialized!");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("initialize config provider instance from configuration file: " + filePath.toString());
        }
        if (!filePath.toString().endsWith(YAML_EXTENSION)) {
            throw new ConfigurationException("Error while initializing configuration provider, file extension is not supported");
        }
        YAMLBasedConfigFileReader configFileReader = new YAMLBasedConfigFileReader(filePath);
        return new ConfigProviderImpl(configFileReader, secureVault);
    }

    private static SecureVault getSecureVault(Path filePath) throws ConfigurationException {
        if (filePath == null || !filePath.toFile().exists()) {
            throw new ConfigurationException("Configuration filepath is not provided. configuration provider will not be initialized!");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("initialize securevault instance from configuration file: " + filePath.toString());
        }
        try {
            return (SecureVault)SecureVaultFactory.getSecureVault((Path)filePath).orElseThrow(() -> new ConfigurationException("Error while loading securevault service"));
        }
        catch (SecureVaultException e) {
            throw new ConfigurationException("Error while loading securevault service", e);
        }
    }
}

