/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.config.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.reader.YmlMerger;

public abstract class ConfigFileReader {
    private static final Logger log = LoggerFactory.getLogger(ConfigFileReader.class);
    private Path configurationFilePath;

    public ConfigFileReader(Path configurationFilePath) {
        this.configurationFilePath = configurationFilePath;
    }

    public abstract Map<String, String> getDeploymentConfiguration() throws ConfigurationException;

    public final String getFileContent() throws ConfigurationException {
        if (this.configurationFilePath == null) {
            String message = "Error while reading the configuration file, file path is null";
            log.error(message);
            throw new ConfigurationException(message);
        }
        String customConfig = System.getProperty("config");
        if (customConfig != null && !customConfig.trim().isEmpty()) {
            try {
                String customConfigContent;
                File customDeploymentFile = new File(customConfig);
                if (customDeploymentFile.isFile()) {
                    log.info("Default deployment configuration updated with provided custom configuration file " + customDeploymentFile.getName());
                    customConfigContent = this.getStringContentFromFile(customDeploymentFile);
                } else {
                    customConfigContent = customConfig;
                }
                ArrayList<String> configContentList = new ArrayList<String>();
                File defaultConfigFile = new File(this.configurationFilePath.toString());
                String defaultConfigContent = this.getStringContentFromFile(defaultConfigFile);
                configContentList.add(defaultConfigContent);
                configContentList.add(customConfigContent);
                YmlMerger ymlMerger = new YmlMerger();
                ymlMerger.setVariablesToReplace(System.getenv());
                return ymlMerger.mergeToString(configContentList);
            }
            catch (IOException e) {
                String message = "Error occurred while overriding the default deployment configuration with providedcustom configurations.";
                log.error(message);
                throw new ConfigurationException(message, e);
            }
        }
        try {
            byte[] contentBytes = Files.readAllBytes(this.configurationFilePath);
            return new String(contentBytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            String message = "Error while reading configuration file";
            log.error(message, (Throwable)e);
            throw new ConfigurationException(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringContentFromFile(File inputFile) throws IOException {
        FileInputStream inputStream = null;
        BufferedReader bufferedReader = null;
        StringBuilder inputSB = new StringBuilder();
        try {
            inputStream = new FileInputStream(inputFile);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, "UTF-8"));
            String line = bufferedReader.readLine();
            while (line != null) {
                inputSB.append(line);
                line = bufferedReader.readLine();
                if (line == null) continue;
                inputSB.append("\n");
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
        return inputSB.toString();
    }

    public Path getConfigurationFilePath() {
        return this.configurationFilePath;
    }
}

