/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.conf;

import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class DataEndpointConfiguration {
    private String receiverURL;
    private String authURL;
    private String username;
    private String password;
    private GenericKeyedObjectPool transportPool;
    private GenericKeyedObjectPool securedTransportPool;
    private int batchSize;
    private String publisherKey;
    private String authKey;
    private String sessionId;
    private int corePoolSize;
    private int maxPoolSize;
    private int keepAliveTimeInPool;

    public DataEndpointConfiguration(String receiverURL, String authURL, String username, String password, GenericKeyedObjectPool transportPool, GenericKeyedObjectPool securedTransportPool, int batchSize, int corePoolSize, int maxPoolSize, int keepAliveTimeInPool) {
        this.receiverURL = receiverURL;
        this.authURL = authURL;
        this.username = username;
        this.password = password;
        this.transportPool = transportPool;
        this.securedTransportPool = securedTransportPool;
        this.publisherKey = this.receiverURL + "##" + username;
        this.authKey = this.authURL + "##" + username;
        this.batchSize = batchSize;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.keepAliveTimeInPool = keepAliveTimeInPool;
    }

    public String getReceiverURL() {
        return this.receiverURL;
    }

    public String getUsername() {
        return this.username;
    }

    public String getAuthURL() {
        return this.authURL;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "ReceiverURL: " + this.receiverURL + ",Authentication URL: " + this.authURL + ",Username: " + this.username;
    }

    public String getPublisherKey() {
        return this.publisherKey;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public GenericKeyedObjectPool getTransportPool() {
        return this.transportPool;
    }

    public GenericKeyedObjectPool getSecuredTransportPool() {
        return this.securedTransportPool;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getKeepAliveTimeInPool() {
        return this.keepAliveTimeInPool;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public static enum Protocol {
        TCP,
        SSL;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

