/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.endpoint.thrift;

import javax.net.ssl.SSLSocket;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.databridge.agent.AgentHolder;
import org.wso2.carbon.databridge.agent.client.AbstractSecureClientPoolFactory;
import org.wso2.carbon.databridge.agent.conf.DataEndpointConfiguration;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointSecurityException;
import org.wso2.carbon.databridge.commons.thrift.service.secure.ThriftSecureEventTransmissionService;

public class ThriftSecureClientPoolFactory
extends AbstractSecureClientPoolFactory {
    private TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();

    public ThriftSecureClientPoolFactory(String trustStore, String trustStorePassword) {
        super(trustStore, trustStorePassword);
        this.params.setTrustStore(this.getTrustStore(), this.getTrustStorePassword());
    }

    @Override
    public Object createClient(String protocol, String hostName, int port) throws DataEndpointSecurityException, DataEndpointAgentConfigurationException {
        if (protocol.equalsIgnoreCase(DataEndpointConfiguration.Protocol.SSL.toString())) {
            int timeout = AgentHolder.getInstance().getDataEndpointAgent("THRIFT").getAgentConfiguration().getSocketTimeoutMS();
            String sslProtocols = AgentHolder.getInstance().getDataEndpointAgent("THRIFT").getAgentConfiguration().getSslEnabledProtocols();
            String ciphers = AgentHolder.getInstance().getDataEndpointAgent("THRIFT").getAgentConfiguration().getCiphers();
            try {
                TSocket receiverTransport;
                TSocket tSocket = receiverTransport = TSSLTransportFactory.getClientSocket((String)hostName, (int)port, (int)timeout, (TSSLTransportFactory.TSSLTransportParameters)this.params);
                SSLSocket sslSocket = (SSLSocket)tSocket.getSocket();
                if (sslProtocols != null && sslProtocols.length() != 0) {
                    String[] sslProtocolsArray = sslProtocols.split(",");
                    sslSocket.setEnabledProtocols(sslProtocolsArray);
                }
                if (ciphers != null && ciphers.length() != 0) {
                    String[] ciphersArray = ciphers.split(",");
                    sslSocket.setEnabledCipherSuites(ciphersArray);
                }
                TBinaryProtocol tProtocol = new TBinaryProtocol((TTransport)receiverTransport);
                return new ThriftSecureEventTransmissionService.Client((TProtocol)tProtocol);
            }
            catch (TTransportException e) {
                throw new DataEndpointSecurityException("Error while trying to connect to " + protocol + "://" + hostName + ":" + port, e);
            }
        }
        throw new DataEndpointSecurityException("Unsupported protocol :" + protocol + " used to authenticate the client, only " + DataEndpointConfiguration.Protocol.SSL.toString() + " is supported");
    }

    @Override
    public boolean validateClient(Object client) {
        ThriftSecureEventTransmissionService.Client thriftClient = (ThriftSecureEventTransmissionService.Client)client;
        return thriftClient.getOutputProtocol().getTransport().isOpen();
    }

    @Override
    public void terminateClient(Object client) {
        ThriftSecureEventTransmissionService.Client thriftClient = (ThriftSecureEventTransmissionService.Client)client;
        thriftClient.getOutputProtocol().getTransport().close();
    }
}

