/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.internal.startupresolver.StartOrderResolverException;
import org.wso2.carbon.kernel.internal.startupresolver.StartupComponentManager;
import org.wso2.carbon.kernel.internal.startupresolver.beans.Capability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.CapabilityProviderCapability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.OSGiServiceCapability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.StartupComponent;
import org.wso2.carbon.kernel.startupresolver.CapabilityProvider;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.utils.StringUtils;

class OSGiServiceCapabilityTracker {
    private static final Logger logger = LoggerFactory.getLogger(OSGiServiceCapabilityTracker.class);
    private StartupComponentManager startupComponentManager;
    private ServiceTracker<Object, Object> capabilityServiceTracker;

    OSGiServiceCapabilityTracker(StartupComponentManager startupComponentManager) {
        this.startupComponentManager = startupComponentManager;
    }

    void startTracker() {
        Filter orFilter = this.getORFilter(this.getRequiredServiceList(this.startupComponentManager));
        this.capabilityServiceTracker = new ServiceTracker(DataHolder.getInstance().getBundleContext(), orFilter, (ServiceTrackerCustomizer)new CapabilityServiceTrackerCustomizer());
        this.capabilityServiceTracker.open();
    }

    void closeTracker() {
        this.capabilityServiceTracker.close();
        this.capabilityServiceTracker = null;
        this.startupComponentManager = null;
    }

    private List<String> getRequiredServiceList(StartupComponentManager startupComponentManager) {
        List<StartupComponent> pendingComponents = startupComponentManager.getComponents(StartupComponent::isPending);
        List<String> requiredServiceList = pendingComponents.stream().flatMap(startupComponent -> startupComponent.getRequiredServices().stream()).distinct().collect(Collectors.toList());
        requiredServiceList.add(RequiredCapabilityListener.class.getName());
        requiredServiceList.add(CapabilityProvider.class.getName());
        return requiredServiceList;
    }

    private Filter getORFilter(List<String> capabilityNameList) {
        StringBuilder orFilterBuilder = new StringBuilder();
        orFilterBuilder.append("(|");
        for (String service : capabilityNameList) {
            orFilterBuilder.append("(").append("objectClass").append("=").append(service).append(")");
        }
        orFilterBuilder.append(")");
        BundleContext bundleContext = DataHolder.getInstance().getBundleContext();
        try {
            return bundleContext.createFilter(orFilterBuilder.toString());
        }
        catch (InvalidSyntaxException e) {
            throw new StartOrderResolverException("Error occurred while creating the service filter", (Exception)((Object)e));
        }
    }

    private class CapabilityServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private CapabilityServiceTrackerCustomizer() {
        }

        public Object addingService(ServiceReference<Object> reference) {
            Object serviceObject = DataHolder.getInstance().getBundleContext().getService(reference);
            String serviceInterfaceClassName = ((String[])reference.getProperty("objectClass"))[0];
            String serviceImplClassName = serviceObject.getClass().getName();
            Bundle bundle = reference.getBundle();
            if (RequiredCapabilityListener.class.getName().equals(serviceInterfaceClassName)) {
                String componentKey = (String)StringUtils.getNonEmptyStringAfterTrim((String)((String)reference.getProperty("componentName"))).orElseThrow(() -> new StartOrderResolverException("componentName value is missing in the services registered with the key " + serviceInterfaceClassName + ", " + "implementation class name is " + serviceImplClassName));
                OSGiServiceCapabilityTracker.this.startupComponentManager.addRequiredCapabilityListener((RequiredCapabilityListener)serviceObject, componentKey, reference.getBundle());
            } else if (CapabilityProvider.class.getName().equals(serviceInterfaceClassName)) {
                String capabilityName = (String)StringUtils.getNonEmptyStringAfterTrim((String)((String)reference.getProperty("capabilityName"))).orElseThrow(() -> new StartOrderResolverException("capabilityName value is missing in the services registered with the key " + serviceInterfaceClassName + ", " + "implementation class name is " + serviceImplClassName));
                CapabilityProviderCapability capabilityProvider = new CapabilityProviderCapability(CapabilityProvider.class.getName(), Capability.CapabilityType.OSGi_SERVICE, Capability.CapabilityState.AVAILABLE, capabilityName.trim(), bundle);
                OSGiServiceCapabilityTracker.this.startupComponentManager.addExpectedOrAvailableCapabilityProvider(capabilityProvider);
                CapabilityProvider provider = (CapabilityProvider)serviceObject;
                IntStream.range(0, provider.getCount()).forEach(count -> OSGiServiceCapabilityTracker.this.startupComponentManager.addExpectedCapability(new OSGiServiceCapability(capabilityName.trim(), Capability.CapabilityType.OSGi_SERVICE, Capability.CapabilityState.EXPECTED, bundle, true)));
            } else {
                if (Boolean.TRUE.equals(reference.getProperty("skipCarbonStartupResolver"))) {
                    logger.debug("Skipping tracking of service {} which implements {}.", (Object)serviceImplClassName, (Object)serviceInterfaceClassName);
                    return null;
                }
                logger.debug("Updating indirect dependencies in components for interface={} via the implementation={}", (Object)serviceInterfaceClassName, (Object)serviceImplClassName);
                OSGiServiceCapabilityTracker.this.startupComponentManager.updateCapability(new OSGiServiceCapability(serviceInterfaceClassName, Capability.CapabilityType.OSGi_SERVICE, Capability.CapabilityState.AVAILABLE, bundle, false));
            }
            return serviceObject;
        }

        public void modifiedService(ServiceReference<Object> reference, Object service) {
        }

        public void removedService(ServiceReference<Object> reference, Object service) {
        }
    }
}

