/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.analytics.esb.siddhi.extension;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.wso2.analytics.esb.util.CompressedEventUtils;
import org.wso2.carbon.analytics.spark.core.util.CompressedEventAnalyticsUtils;
import org.wso2.carbon.analytics.spark.core.util.PublishingPayload;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

public class CompressedEventProcessor
extends StreamProcessor {
    private Map<String, String> fields = new LinkedHashMap<String, String>();
    private int[] dataColumnIndex;
    private int[] metaCompressedIndex;
    private int[] metaTenantIdIndex;
    private static ThreadLocal<Kryo> kryoTL = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            Kryo kryo = new Kryo();
            kryo.register(HashMap.class, 111);
            kryo.register(ArrayList.class, 222);
            kryo.register(PublishingPayload.class, 333);
            return kryo;
        }
    };

    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.fields = CompressedEventProcessor.getOutputFields();
        ArrayList<Attribute> outputAttributes = new ArrayList<Attribute>();
        for (String fielname : this.fields.keySet()) {
            String fieldType = this.fields.get(fielname);
            Attribute.Type type = null;
            if (fieldType.equalsIgnoreCase("double")) {
                type = Attribute.Type.DOUBLE;
            } else if (fieldType.equalsIgnoreCase("float")) {
                type = Attribute.Type.FLOAT;
            } else if (fieldType.equalsIgnoreCase("integer")) {
                type = Attribute.Type.INT;
            } else if (fieldType.equalsIgnoreCase("long")) {
                type = Attribute.Type.LONG;
            } else if (fieldType.equalsIgnoreCase("boolean")) {
                type = Attribute.Type.BOOL;
            } else if (fieldType.equalsIgnoreCase("string")) {
                type = Attribute.Type.STRING;
            }
            outputAttributes.add(new Attribute(fielname, type));
        }
        return outputAttributes;
    }

    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        ComplexEventChunk decompressedStreamEventChunk = new ComplexEventChunk(false);
        while (streamEventChunk.hasNext()) {
            StreamEvent compressedEvent = (StreamEvent)streamEventChunk.next();
            String eventString = (String)compressedEvent.getAttribute(this.dataColumnIndex);
            if (!eventString.isEmpty()) {
                ByteArrayInputStream unzippedByteArray = (Boolean)compressedEvent.getAttribute(this.metaCompressedIndex) != false ? CompressedEventAnalyticsUtils.decompress((String)eventString) : new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)eventString));
                Input input = new Input((InputStream)unzippedByteArray);
                Map aggregatedEvent = (Map)kryoTL.get().readObjectOrNull(input, HashMap.class);
                ArrayList eventsList = (ArrayList)aggregatedEvent.get("events");
                ArrayList payloadsList = (ArrayList)aggregatedEvent.get("payloads");
                String host = (String)aggregatedEvent.get("host");
                int metaTenantId = (Integer)compressedEvent.getAttribute(this.metaTenantIdIndex);
                for (int i = 0; i < eventsList.size(); ++i) {
                    StreamEvent decompressedEvent = streamEventCloner.copyStreamEvent(compressedEvent);
                    Object[] decompressedFields = CompressedEventUtils.getFieldValues(new ArrayList<String>(this.fields.keySet()), (List)eventsList.get(i), payloadsList, i, compressedEvent.getTimestamp(), metaTenantId, host);
                    complexEventPopulater.populateComplexEvent((ComplexEvent)decompressedEvent, decompressedFields);
                    decompressedStreamEventChunk.add((ComplexEvent)decompressedEvent);
                }
                continue;
            }
            throw new ExecutionPlanRuntimeException("Error occured while decompressing events. No compressed data found.");
        }
        nextProcessor.process(decompressedStreamEventChunk);
    }

    public void start() {
        block10: for (ExpressionExecutor expressionExecutor : this.attributeExpressionExecutors) {
            String variableName;
            if (!(expressionExecutor instanceof VariableExpressionExecutor)) continue;
            VariableExpressionExecutor variable = (VariableExpressionExecutor)expressionExecutor;
            switch (variableName = variable.getAttribute().getName()) {
                case "flowData": {
                    this.dataColumnIndex = variable.getPosition();
                    continue block10;
                }
                case "meta_compressed": {
                    this.metaCompressedIndex = variable.getPosition();
                    continue block10;
                }
                case "meta_tenantId": {
                    this.metaTenantIdIndex = variable.getPosition();
                }
            }
        }
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] arg0) {
    }

    private static Map<String, String> getOutputFields() {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] lines;
            for (String line : lines = IOUtils.toString((InputStream)classLoader.getResourceAsStream("decompressedEventDefinition")).split("\n")) {
                String[] fieldDef;
                if (StringUtils.startsWithIgnoreCase((CharSequence)line, (CharSequence)"#") || !StringUtils.isNotEmpty((CharSequence)line) || (fieldDef = StringUtils.deleteWhitespace((String)line).split(":")).length != 2) continue;
                fields.put(fieldDef[0], fieldDef[1]);
            }
        }
        catch (IOException e) {
            new ExecutionPlanCreationException("Error occured while reading decompressed event definitions: " + e.getMessage(), (Throwable)e);
        }
        return fields;
    }
}

