/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.bpmn.analytics.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.ei.bpmn.analytics.core.exceptions.BPMNAnalyticsCoreException;
import org.wso2.ei.bpmn.analytics.core.internal.BPMNAnalyticsCoreServerHolder;
import org.wso2.ei.bpmn.analytics.core.services.BPMNAnalyticsCoreServer;
import org.wso2.ei.bpmn.analytics.core.services.BPMNAnalyticsCoreService;

public class BPMNAnalyticsCoreServiceComponent {
    private static Log log = LogFactory.getLog(BPMNAnalyticsCoreServiceComponent.class);

    protected void activate(ComponentContext ctxt) {
        log.info((Object)"Initializing the BPMN Analytics Core component");
        try {
            BPMNAnalyticsCoreServerHolder bpmnAnalyticsCoreHolder = BPMNAnalyticsCoreServerHolder.getInstance();
            this.initAnalyticsServer(bpmnAnalyticsCoreHolder);
            BPMNAnalyticsCoreService bpsAnalyticsService = new BPMNAnalyticsCoreService();
            bpsAnalyticsService.setBPMNAnalyticsCoreServer(bpmnAnalyticsCoreHolder.getBPMNAnalyticsCoreServer());
            ctxt.getBundleContext().registerService(BPMNAnalyticsCoreService.class.getName(), (Object)bpsAnalyticsService, null);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to initialize the BPMN Analytics Core Service component.", e);
        }
    }

    public void setRegistryService(RegistryService registryService) {
        BPMNAnalyticsCoreServerHolder.getInstance().setRegistryService(registryService);
    }

    public void unsetRegistryService(RegistryService registryService) {
        BPMNAnalyticsCoreServerHolder.getInstance().setRegistryService(null);
    }

    public void setRealmService(RealmService realmService) {
        BPMNAnalyticsCoreServerHolder.getInstance().setRealmService(realmService);
    }

    public void unsetRealmService(RealmService realmService) {
        BPMNAnalyticsCoreServerHolder.getInstance().setRealmService(null);
    }

    private void initAnalyticsServer(BPMNAnalyticsCoreServerHolder bpmnAnalyticsHolder) throws BPMNAnalyticsCoreException {
        bpmnAnalyticsHolder.setBPMNAnalyticsCoreServer(new BPMNAnalyticsCoreServer());
        bpmnAnalyticsHolder.getBPMNAnalyticsCoreServer().init();
    }
}

