/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.analytics.esb.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.wso2.analytics.esb.bean.TimeRange;
import org.wso2.analytics.esb.util.RangeUnit;

public class TimeRangeUtils {
    private static final int INTERVAL = 6;
    private static final Log log = LogFactory.getLog(TimeRangeUtils.class);
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");

    private TimeRangeUtils() {
    }

    public static String getSuitableTimeRangeUnit(long from, long to) {
        DateTime fromTime = new DateTime(from);
        DateTime toTime = new DateTime(to);
        RangeUnit range = Months.monthsBetween((ReadableInstant)fromTime, (ReadableInstant)toTime).getMonths() >= 6 ? RangeUnit.MONTH : (Days.daysBetween((ReadableInstant)fromTime, (ReadableInstant)toTime).getDays() >= 6 ? RangeUnit.DAY : (Hours.hoursBetween((ReadableInstant)fromTime, (ReadableInstant)toTime).getHours() >= 6 ? RangeUnit.HOUR : (Minutes.minutesBetween((ReadableInstant)fromTime, (ReadableInstant)toTime).getMinutes() >= 6 ? RangeUnit.MINUTE : RangeUnit.SECOND)));
        return range.name();
    }

    public static int getNoOfSecondForMonthInGivenTimestamp(long timestamp) {
        DateTime time = new DateTime(timestamp);
        return time.dayOfMonth().getMaximumValue() * 86400;
    }

    public static List<TimeRange> getDateTimeRanges(long from, long to) {
        ArrayList<TimeRange> ranges = new ArrayList<TimeRange>(10);
        MutableDateTime fromDate = new MutableDateTime(from);
        fromDate.set(DateTimeFieldType.millisOfSecond(), 0);
        MutableDateTime toDate = new MutableDateTime(to);
        toDate.set(DateTimeFieldType.millisOfSecond(), 0);
        MutableDateTime tempFromTime = fromDate.copy();
        MutableDateTime tempToTime = toDate.copy();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Time range: " + formatter.format(fromDate.toDate()) + " -> " + formatter.format(toDate.toDate())));
        }
        if (toDate.getMillis() - fromDate.getMillis() < 60000L) {
            ranges.add(new TimeRange(RangeUnit.SECOND.name(), new long[]{fromDate.getMillis(), toDate.getMillis()}));
        } else {
            if (tempFromTime.getSecondOfMinute() != 0 && toDate.getMillis() - fromDate.getMillis() > 60000L) {
                tempFromTime = tempFromTime.minuteOfHour().roundCeiling();
                ranges.add(new TimeRange(RangeUnit.SECOND.name(), new long[]{fromDate.getMillis(), tempFromTime.getMillis()}));
            }
            if (tempFromTime.getMinuteOfHour() != 0 && toDate.getMillis() - tempFromTime.getMillis() >= 60000L) {
                fromDate = tempFromTime.copy();
                tempFromTime = (toDate.getMillis() - tempFromTime.getMillis()) / 60000L < 60L ? tempFromTime.minuteOfHour().add((toDate.getMillis() - tempFromTime.getMillis()) / 60000L) : tempFromTime.hourOfDay().roundCeiling();
                ranges.add(new TimeRange(RangeUnit.MINUTE.name(), new long[]{fromDate.getMillis(), tempFromTime.getMillis()}));
            }
            if (tempFromTime.getHourOfDay() != 0 && toDate.getMillis() - tempFromTime.getMillis() >= 3600000L) {
                fromDate = tempFromTime.copy();
                tempFromTime = (toDate.getMillis() - tempFromTime.getMillis()) / 3600000L < 24L ? tempFromTime.hourOfDay().add((toDate.getMillis() - tempFromTime.getMillis()) / 3600000L) : tempFromTime.dayOfMonth().roundCeiling();
                ranges.add(new TimeRange(RangeUnit.HOUR.name(), new long[]{fromDate.getMillis(), tempFromTime.getMillis()}));
            }
            if (tempFromTime.getDayOfMonth() != 1 && toDate.getMillis() - tempFromTime.getMillis() >= 86400000L) {
                fromDate = tempFromTime.copy();
                tempFromTime = (toDate.getMillis() - tempFromTime.getMillis()) / 86400000L < (long)tempFromTime.dayOfMonth().getMaximumValue() ? tempFromTime.dayOfMonth().add((toDate.getMillis() - tempFromTime.getMillis()) / 86400000L) : tempFromTime.monthOfYear().roundCeiling();
                ranges.add(new TimeRange(RangeUnit.DAY.name(), new long[]{fromDate.getMillis(), tempFromTime.getMillis()}));
            }
            if (tempToTime.getSecondOfMinute() != 0 && tempToTime.getMillis() - tempFromTime.getMillis() >= 1000L) {
                toDate = tempToTime.copy();
                long remainingSeconds = (toDate.getMillis() - tempFromTime.getMillis()) % 60000L / 1000L;
                tempToTime = remainingSeconds < 60L ? tempToTime.secondOfMinute().add(-1L * remainingSeconds) : tempToTime.secondOfMinute().roundFloor();
                ranges.add(new TimeRange(RangeUnit.SECOND.name(), new long[]{tempToTime.getMillis(), toDate.getMillis()}));
            }
            if (tempToTime.getMinuteOfHour() != 0 && tempToTime.getMillis() - tempFromTime.getMillis() >= 60000L) {
                toDate = tempToTime.copy();
                long remainingMinutes = (toDate.getMillis() - tempFromTime.getMillis()) % 3600000L / 60000L;
                tempToTime = remainingMinutes < 60L ? tempToTime.minuteOfHour().add(-1L * remainingMinutes) : tempToTime.hourOfDay().roundFloor();
                ranges.add(new TimeRange(RangeUnit.MINUTE.name(), new long[]{tempToTime.getMillis(), toDate.getMillis()}));
            }
            if (tempToTime.getHourOfDay() != 0 && tempToTime.getMillis() - tempFromTime.getMillis() >= 3600000L) {
                toDate = tempToTime.copy();
                long remainingHours = (toDate.getMillis() - tempFromTime.getMillis()) % 86400000L / 3600000L;
                tempToTime = remainingHours < 24L ? tempToTime.hourOfDay().add(-1L * remainingHours) : tempToTime.dayOfMonth().roundFloor();
                ranges.add(new TimeRange(RangeUnit.HOUR.name(), new long[]{tempToTime.getMillis(), toDate.getMillis()}));
            }
            if (tempToTime.getDayOfMonth() != 1 && tempToTime.getMillis() - tempFromTime.getMillis() >= 86400000L) {
                toDate = tempToTime.copy();
                tempToTime = tempToTime.monthOfYear().roundFloor();
                ranges.add(new TimeRange(RangeUnit.DAY.name(), new long[]{tempToTime.getMillis(), toDate.getMillis()}));
            }
            if (tempToTime.isAfter((ReadableInstant)tempFromTime)) {
                ranges.add(new TimeRange(RangeUnit.MONTH.name(), new long[]{tempFromTime.getMillis(), tempToTime.getMillis()}));
            }
        }
        if (log.isDebugEnabled()) {
            for (TimeRange timeRange : ranges) {
                log.debug((Object)("Unit: " + timeRange.getUnit() + " Range: " + formatter.format(new Date(timeRange.getRange()[0])) + "(" + timeRange.getRange()[0] + ")->" + formatter.format(new Date(timeRange.getRange()[1])) + "(" + timeRange.getRange()[1] + ")"));
            }
        }
        return ranges;
    }

    public static long roundFloor(long timestamp, String timeUnit) {
        RangeUnit timeUnitEnum = RangeUnit.valueOf(timeUnit);
        MutableDateTime mutableDateTime = new MutableDateTime(timestamp);
        long newFloorTimestamp = mutableDateTime.getMillis();
        switch (timeUnitEnum) {
            case MONTH: {
                newFloorTimestamp = mutableDateTime.monthOfYear().roundFloor().getMillis();
                break;
            }
            case DAY: {
                newFloorTimestamp = mutableDateTime.dayOfMonth().roundFloor().getMillis();
                break;
            }
            case HOUR: {
                newFloorTimestamp = mutableDateTime.hourOfDay().roundFloor().getMillis();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Original date: " + formatter.format(new Date(timestamp)) + " -> Rounded date:" + formatter.format(new Date(newFloorTimestamp))));
        }
        return newFloorTimestamp;
    }
}

