/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.bpmn.analytics.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.ei.bpmn.analytics.core.clients.BPMNAnalyticsCoreRestClient;
import org.wso2.ei.bpmn.analytics.core.models.AggregateField;
import org.wso2.ei.bpmn.analytics.core.models.AggregateQuery;
import org.wso2.ei.bpmn.analytics.core.utils.BPMNAnalyticsCoreUtils;

public class UserLevelMonitor {
    private static final Log log = LogFactory.getLog(UserLevelMonitor.class);

    public String getTotalInvolvedTimeVsUserId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                long from = filterObj.getLong("startTime");
                long to = filterObj.getLong("endTime");
                String order = filterObj.getString("order");
                int userCount = filterObj.getInt("count");
                AggregateField sumField = new AggregateField();
                sumField.setFieldName("duration");
                sumField.setAggregate("SUM");
                sumField.setAlias("totalInvolvedTime");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(sumField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("USER_INVOLVE_SUMMARY_DATA");
                query.setGroupByField("assignUser");
                if (from != 0L && to != 0L) {
                    query.setQuery(BPMNAnalyticsCoreUtils.getDateRangeQuery("finishedTime", from, to));
                }
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Total Involved Time Vs User Id Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Double> table = new Hashtable<String, Double>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String assignee = values.getJSONArray("assignUser").getString(0);
                        double totalInvolvedTime = values.getDouble("totalInvolvedTime");
                        table.put(assignee, totalInvolvedTime);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getDoubleValueSortedList(table, "assignUser", "totalInvolvedTime", order, userCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Total Involved Time Vs UserId UserLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total Involved Time Vs User Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getTotalCompletedTasksVsUserId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                long from = filterObj.getLong("startTime");
                long to = filterObj.getLong("endTime");
                String order = filterObj.getString("order");
                int userCount = filterObj.getInt("count");
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("completedTotalTasks");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("USER_INVOLVE_SUMMARY_DATA");
                query.setGroupByField("assignUser");
                if (from != 0L && to != 0L) {
                    query.setQuery(BPMNAnalyticsCoreUtils.getDateRangeQuery("finishedTime", from, to));
                }
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Total Completed Tasks Vs User Id Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Integer> table = new Hashtable<String, Integer>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String assignee = values.getJSONArray("assignUser").getString(0);
                        int totalInvolvedTime = values.getInt("completedTotalTasks");
                        table.put(assignee, totalInvolvedTime);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getIntegerValueSortedList(table, "assignUser", "completedTotalTasks", order, userCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Total Completed Tasks Vs UserId UserLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total Completed Tasks Vs User Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getTotalInvolvedTimeVsProcessId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                long from = filterObj.getLong("startTime");
                long to = filterObj.getLong("endTime");
                String userId = filterObj.getString("userId");
                String order = filterObj.getString("order");
                int count = filterObj.getInt("count");
                AggregateField sumField = new AggregateField();
                sumField.setFieldName("duration");
                sumField.setAggregate("SUM");
                sumField.setAlias("totalInvolvedTime");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(sumField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("USER_INVOLVE_SUMMARY_DATA");
                query.setGroupByField("processDefKey");
                String queryStr = "assignee:\"'" + userId + "'\"";
                if (from != 0L && to != 0L) {
                    queryStr = queryStr + " AND " + BPMNAnalyticsCoreUtils.getDateRangeQuery("finishedTime", from, to);
                }
                query.setQuery(queryStr);
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Total Involved Time Vs Process Id Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Double> table = new Hashtable<String, Double>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String processDefKey = values.getJSONArray("processDefKey").getString(0);
                        double totalInvolvedTime = values.getDouble("totalInvolvedTime");
                        table.put(processDefKey, totalInvolvedTime);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getDoubleValueSortedList(table, "processDefKey", "totalInvolvedTime", order, count);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Total Involved Time Vs ProcessId UserLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total Involved Time Vs Process Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getTotalInvolvedInstanceCountVsProcessId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                long from = filterObj.getLong("startTime");
                long to = filterObj.getLong("endTime");
                String userId = filterObj.getString("userId");
                String order = filterObj.getString("order");
                int count = filterObj.getInt("count");
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("totalInstanceCount");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("USER_INVOLVE_SUMMARY_DATA");
                query.setGroupByField("processDefKey");
                String queryStr = "assignee:\"'" + userId + "'\"";
                if (from != 0L && to != 0L) {
                    queryStr = queryStr + " AND " + BPMNAnalyticsCoreUtils.getDateRangeQuery("finishedTime", from, to);
                }
                query.setQuery(queryStr);
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Total Involved Instance Count Vs Process Id Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Integer> table = new Hashtable<String, Integer>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String processDefKey = values.getJSONArray("processDefKey").getString(0);
                        int instanceCount = values.getInt("totalInstanceCount");
                        table.put(processDefKey, instanceCount);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getIntegerValueSortedList(table, "processDefKey", "totalInstanceCount", order, count);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Total Involved Instance Count Vs ProcessId UserLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total Involved Instance Count Vs Process Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getUserLevelTaskInstanceCountVsTaskId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                String processId = filterObj.getString("processId");
                String userId = filterObj.getString("userId");
                String order = filterObj.getString("order");
                int taskCount = filterObj.getInt("count");
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("taskInstanceCount");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("USER_INVOLVE_SUMMARY_DATA");
                query.setGroupByField("taskDefId");
                String queryStr = "assignee:\"'" + userId + "'\"";
                queryStr = queryStr + " AND processDefKey:\"'" + processId + "'\"";
                query.setQuery(queryStr);
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get User Level Task Instance Count Vs Task Id Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Integer> table = new Hashtable<String, Integer>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String processDefKey = values.getJSONArray("taskDefId").getString(0);
                        int processInstanceCount = values.getInt("taskInstanceCount");
                        table.put(processDefKey, processInstanceCount);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getIntegerValueSortedList(table, "taskDefId", "taskInstanceCount", order, taskCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - User Level Task Instance Count Vs Task Id UserLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User Level Task Instance Count Vs Task Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getUserLevelAvgExecuteTimeVsTaskId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                String processId = filterObj.getString("processId");
                String userId = filterObj.getString("userId");
                String order = filterObj.getString("order");
                int taskCount = filterObj.getInt("count");
                AggregateField avgField = new AggregateField();
                avgField.setFieldName("duration");
                avgField.setAggregate("AVG");
                avgField.setAlias("avgExecutionTime");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(avgField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("USER_INVOLVE_SUMMARY_DATA");
                query.setGroupByField("taskDefId");
                String queryStr = "assignee:\"'" + userId + "'\"";
                queryStr = queryStr + " AND processDefKey:\"'" + processId + "'\"";
                query.setQuery(queryStr);
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get User Level Avg Execution Time Vs Task Id Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Double> table = new Hashtable<String, Double>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String taskDefKey = values.getJSONArray("taskDefId").getString(0);
                        double avgExecTime = values.getDouble("avgExecutionTime");
                        table.put(taskDefKey, avgExecTime);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getDoubleValueSortedList(table, "taskDefId", "avgExecutionTime", order, taskCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - User Level Avg Execution Time Vs Task Id UserLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User Level Avg Execution Time Vs Task Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getUserList() {
        String userIdList = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("completedTotalTasks");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("USER_INVOLVE_SUMMARY_DATA");
                query.setGroupByField("assignUser");
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get User List Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray array = new JSONArray(result);
                JSONArray resultArray = new JSONArray();
                if (array.length() != 0) {
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject jsonObj = array.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String userId = values.getJSONArray("assignUser").getString(0);
                        JSONObject o = new JSONObject();
                        o.put("assignUser", (Object)userId);
                        resultArray.put((Object)o);
                    }
                    userIdList = resultArray.toString();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User List Result:" + userIdList));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"BPMN Analytics Core - user id list error.", (Throwable)e);
        }
        return userIdList;
    }
}

