/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.bpmn.analytics.core.clients;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.ei.bpmn.analytics.core.utils.BPMNAnalyticsCoreUtils;

public class BPMNAnalyticsCoreRestClient {
    private static final Log log = LogFactory.getLog(BPMNAnalyticsCoreRestClient.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String message) throws IOException, XMLStreamException {
        String errMsg;
        RegistryUtils.setTrustStoreSystemProperties();
        HttpClient httpClient = new HttpClient();
        PostMethod postRequest = new PostMethod(url);
        postRequest.setRequestHeader("Authorization", BPMNAnalyticsCoreUtils.getAuthorizationHeader());
        BufferedReader br = null;
        try {
            StringRequestEntity input = new StringRequestEntity(message, "application/json", "UTF-8");
            postRequest.setRequestEntity((RequestEntity)input);
            int returnCode = httpClient.executeMethod((HttpMethod)postRequest);
            if (returnCode != 200) {
                String errorCode = "Failed : HTTP error code : " + returnCode;
                throw new RuntimeException(errorCode);
            }
            String charsetname = StandardCharsets.UTF_8.name();
            if (postRequest.getResponseCharSet() != null) {
                charsetname = postRequest.getResponseCharSet();
            }
            InputStreamReader reader = new InputStreamReader(postRequest.getResponseBodyAsStream(), charsetname);
            br = new BufferedReader(reader);
            String output = null;
            StringBuilder totalOutput = new StringBuilder();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Output from Server .... \n");
            }
            while ((output = br.readLine()) != null) {
                totalOutput.append(output);
            }
            String string = totalOutput.toString();
            return string;
        }
        catch (UnsupportedEncodingException e) {
            String errMsg2 = "Async DAS client unsupported encoding exception.";
            throw new UnsupportedEncodingException(errMsg2);
        }
        catch (UnsupportedOperationException e) {
            String errMsg3 = "Async DAS client unsupported operation exception.";
            throw new UnsupportedOperationException(errMsg3);
        }
        catch (IOException e) {
            errMsg = "Async DAS client I/O exception.";
            log.error((Object)errMsg, (Throwable)e);
        }
        finally {
            postRequest.releaseConnection();
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    errMsg = "Async DAS rest client BufferedReader close exception.";
                    log.error((Object)errMsg, (Throwable)e);
                }
            }
        }
        return null;
    }
}

