/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.bpmn.analytics.core.services;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.ei.bpmn.analytics.core.config.BPMNAnalyticsCoreConfiguration;
import org.wso2.ei.bpmn.analytics.core.exceptions.BPMNAnalyticsCoreException;

public class BPMNAnalyticsCoreServer {
    private static final Log log = LogFactory.getLog(BPMNAnalyticsCoreServer.class);
    private BPMNAnalyticsCoreConfiguration bpsAnalyticsConfiguration;

    public void init() throws BPMNAnalyticsCoreException {
        this.loadBPSAnalyticsConfiguration();
    }

    private void loadBPSAnalyticsConfiguration() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loading BPS Analytics Configuration.");
        }
        if (this.isBPSAnalyticsConfigurationFileAvailable()) {
            File BPSAnalyticsConfigFile = new File(this.getBPSAnalyticsConfigurationFilePath());
            this.bpsAnalyticsConfiguration = new BPMNAnalyticsCoreConfiguration(BPSAnalyticsConfigFile);
        } else {
            log.warn((Object)"BPS Analytics configuration file: bps-analytics.xml not found. Loading default configurations.");
        }
    }

    private boolean isBPSAnalyticsConfigurationFileAvailable() {
        File BPSAnalyticsConfigurationFile = new File(this.getBPSAnalyticsConfigurationFilePath());
        return BPSAnalyticsConfigurationFile.exists();
    }

    private String getBPSAnalyticsConfigurationFilePath() {
        return CarbonUtils.getCarbonConfigDirPath() + File.separator + "bps-analytics.xml";
    }

    public BPMNAnalyticsCoreConfiguration getBPSAnalyticsConfiguration() {
        return this.bpsAnalyticsConfiguration;
    }
}

