/*
 * Copyright (c) 2016, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License./
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function getPieMark(a,b){var c;if("donut"==a.mode)var c=a.width/5*(1+a.innerRadius);else if("pie"==a.mode)var c=0;else{a.innerRadius+=.5;var c=a.width/5*(1+a.innerRadius)}var d=a.title,e="";null!=a.type&&(d="layout",e="a.");var f={type:"arc",from:{data:d},properties:{update:{x:{field:{group:"width"},mult:.5},y:{field:{group:"height"},mult:.5},startAngle:{field:"layout_start"},endAngle:{field:"layout_end"},innerRadius:{value:c},outerRadius:{value:.4*a.width},fill:{scale:"color",field:e+b.names[a.color]},fillOpacity:{value:1}},hover:{fillOpacity:{value:.8},cursor:{value:a.hoverCursor}}}};return f}function getPieMidText(a,b){var c={type:"text",from:{data:"layout"},properties:{update:{x:{field:{group:"width"},mult:.5},y:{field:{group:"height"},mult:.5},radius:{value:0},theta:{field:"layout_mid"},fill:[{test:"indata('arc', datum.a."+b.names[a.color]+", 'type')",scale:"color",field:b.names[a.color]},{}],align:{value:"center"},baseline:{value:"middle"},fontSize:{value:a.width/9},text:{template:"{{datum.percentage | number:'.2f'}}%"}}}};return c}function getPieText(a,b){var c={type:"text",from:{data:"layout"},properties:{update:{x:{field:{group:"width"},mult:.5},y:{field:{group:"height"},mult:.5},radius:{value:.5*a.width},theta:{field:"layout_mid"},fill:{value:"#000"},align:{value:"center"},baseline:{value:"middle"},text:{template:"{{datum.percentage | number:'.2f'}}%"}}}};return c}function getAreaMark(a,b){var c;return c=-1!=a.color?{type:"group",from:{data:a.title,transform:[{type:"facet",groupby:[b.names[a.color]]}]},marks:[{type:"area",properties:{update:{x:{scale:"x",field:b.names[a.x]},y:{scale:"y",field:b.names[a.y]},y2:{scale:"y",value:0},fill:{scale:"color",field:b.names[a.color]},strokeWidth:{value:2},strokeOpacity:{value:1}},hover:{strokeOpacity:{value:.5}}}}]}:{type:"area",from:{data:a.title},properties:{update:{x:{scale:"x",field:b.names[a.x]},y:{scale:"y",field:b.names[a.y]},y2:{scale:"y",value:0},fill:{value:a.markColor},strokeWidth:{value:2},fillOpacity:{value:1}},hover:{fillOpacity:{value:.5}}}}}function getBarMark(a,b){var c;c="left"==a.orientation?{y:{scale:"x",field:b.names[a.x]},height:{scale:"x",band:!0,offset:calculateBarGap(a)},x:{scale:"y",field:b.names[a.y]},x2:{scale:"y",value:0},fill:{value:a.markColor},fillOpacity:{value:1}}:{x:{scale:"x",field:b.names[a.x]},width:{scale:"x",band:!0,offset:calculateBarGap(a)},y:{scale:"y",field:b.names[a.y]},y2:{scale:"y",value:0},fill:{value:a.markColor},fillOpacity:{value:1}};var d={type:"rect",from:{data:a.title},properties:{update:c,hover:{fillOpacity:{value:.5},cursor:{value:a.hoverCursor}}}};return d}function getStackBarMark(a,b){return"left"==a.orientation?mark={type:"rect",from:{data:a.title,transform:[{type:"stack",groupby:[b.names[a.x]],sortby:[b.names[a.color]],field:b.names[a.y]}]},properties:{update:{y:{scale:"x",field:b.names[a.x]},height:{scale:"x",band:!0,offset:calculateBarGap(a)},x:{scale:"y",field:"layout_start"},x2:{scale:"y",field:"layout_end"},fill:{scale:"color",field:b.names[a.color]},fillOpacity:{value:1}},hover:{fillOpacity:{value:.5},cursor:{value:a.hoverCursor}}}}:mark={type:"rect",from:{data:a.title,transform:[{type:"stack",groupby:[b.names[a.x]],sortby:[b.names[a.color]],field:b.names[a.y]}]},properties:{update:{x:{scale:"x",field:b.names[a.x]},width:{scale:"x",band:!0,offset:calculateBarGap(a)},y:{scale:"y",field:"layout_start"},y2:{scale:"y",field:"layout_end"},fill:{scale:"color",field:b.names[a.color]},fillOpacity:{value:1}},hover:{fillOpacity:{value:.5},cursor:{value:a.hoverCursor}}}},mark}function getGroupBarMark(a,b){var c;return c="left"==a.orientation?{type:"group",from:{data:a.title,transform:[{type:"facet",groupby:[b.names[a.x]]}]},properties:{update:{y:{scale:"x",field:"key"},height:{scale:"x",band:!0}}},scales:[{name:"pos",type:"ordinal",range:"height",domain:{field:b.names[a.color]}}],marks:[{name:"bars",type:"rect",properties:{update:{y:{scale:"pos",field:b.names[a.color]},height:{scale:"pos",band:!0},x:{scale:"y",field:b.names[a.y]},x2:{scale:"y",value:0},fill:{scale:"color",field:b.names[a.color]},fillOpacity:{value:1}},hover:{fillOpacity:{value:.5},cursor:{value:a.hoverCursor}}}}]}:{type:"group",from:{data:a.title,transform:[{type:"facet",groupby:[b.names[a.x]]}]},properties:{update:{x:{scale:"x",field:"key"},width:{scale:"x",band:!0}}},scales:[{name:"pos",type:"ordinal",range:"width",domain:{field:b.names[a.color]}}],marks:[{name:"bars",type:"rect",properties:{update:{x:{scale:"pos",field:b.names[a.color]},width:{scale:"pos",band:!0},y:{scale:"y",field:b.names[a.y]},y2:{scale:"y",value:0},fill:{scale:"color",field:b.names[a.color]},fillOpacity:{value:1}},hover:{fillOpacity:{value:.5},cursor:{value:a.hoverCursor}}}}]}}function calculateBarGap(a){var b;return b="left"==a.orientation?a.height:a.width,-a.barGap*(b/30)}function getLineMark(a,b){var c;return c=-1!=a.color?{name:"line-group",type:"group",from:{data:a.title,transform:[{type:"facet",groupby:[b.names[a.color]]}]},marks:[{type:"line",properties:{update:{x:{scale:"x",field:b.names[a.x]},y:{scale:"y",field:b.names[a.y]},stroke:{scale:"color",field:b.names[a.color]},strokeWidth:{value:2},strokeOpacity:{value:1}},hover:{strokeOpacity:{value:.5},cursor:{value:a.hoverCursor}}}}]}:{type:"line",from:{data:a.title},properties:{update:{x:{scale:"x",field:b.names[a.x]},y:{scale:"y",field:b.names[a.y]},stroke:{value:a.markColor},strokeWidth:{value:2},strokeOpacity:{value:1}},hover:{strokeOpacity:{value:.5}}}}}function getTopoJson(a,b){var c,d=a.width,e=a.height,f=a.charts[0].mapType,g="mercator";"usa"==f?(d=a.width-160,e=a.height-130,c=a.height+270,g="albersUsa"):"europe"==f?(d=(a.width/2+100)/2,e=a.height+150,c=a.height+50):(c=a.width/640*120,d=a.width/2+10,e=a.height/2+40);var h=a.geoCodesUrl,i={name:"geoData",url:h,format:{type:"topojson",feature:"units"},transform:[{type:"geopath",value:"data",scale:c,translate:[d,e],projection:g},{type:"lookup",keys:["id"],on:a.title,onKey:b.names[a.x],as:["zipped"],"default":{v:null,country:"No data"}}]};return i}function getMapMark(a,b){var c=[{name:"map",type:"path",from:{data:"geoData"},properties:{enter:{path:{field:"layout_path"}},update:{fillOpacity:{value:1},fill:{rule:[{predicate:{name:"isNotNull",id:{field:"zipped.v"}},scale:"color",field:"zipped.v"},{value:a.mapColor}]}},hover:{fillOpacity:{value:.5},cursor:{value:a.hoverCursor}}}},{type:"group",from:{data:a.title,transform:[{type:"filter",test:"datum."+b.names[a.x]+" == tooltipSignal.datum."+b.names[a.x]}]},properties:{update:{x:{signal:"tooltipSignal.x",offset:-5},y:{signal:"tooltipSignal.y",offset:20},width:{value:100},height:{value:20},fill:{value:a.tooltip.color}}},marks:[{type:"text",properties:{update:{x:{value:6},y:{value:14},text:{template:"{{tooltipSignal.datum.unitName}} {{tooltipSignal.datum.v}}"},fill:{value:"black"}}}}]}];return c}function getMapSignals(){var a=[{name:"tooltipSignal",init:{expr:"{x: 0, y: 0, datum: {} }"},streams:[{type:"@map:mouseover",expr:"{x: eventX(), y: eventY(), datum: eventItem().datum.zipped}"},{type:"@map:mouseout",expr:"{x: 0, y: 0, datum: {} }"}]}];return a}function getMapPredicates(){var a={name:"isNotNull",type:"!=",operands:[{value:null},{arg:"id"}]};return a}function getMapLegends(a,b){var c={fill:"color",title:b.names[a.y],properties:{gradient:{stroke:{value:"transparent"}},title:{fontSize:{value:14}},legend:{x:{value:0},y:{value:a.height-40}}}};return c}function loadGeoMapCodes(a){var b,c=new XMLHttpRequest;return c.overrideMimeType("application/json"),c.open("GET",a,!1),c.onreadystatechange=function(){4==c.readyState&&"200"==c.status&&(b=JSON.parse(c.responseText))},c.send(null),b}function getMapCode(a,b,c){if("world"==b||"europe"==b)for(d=0;d<c.length;d++)a.toUpperCase()==c[d].name.toUpperCase()&&(a=c[d]["alpha-3"]);else{var d=0;for(var e in c)c.hasOwnProperty(e)&&a.toUpperCase()==e.toUpperCase()&&(a="US"+c[e]),d++}return a}function getScatterMark(a,b){var c,d;c=-1==a.color?{value:a.markColor}:{scale:"color",field:b.names[a.color]},d=-1==a.size?{value:50*a.markSize}:{scale:"size",field:b.names[a.size]};var e={type:"symbol",from:{data:a.title},properties:{update:{x:{scale:"x",field:b.names[a.x]},y:{scale:"y",field:b.names[a.y]},fill:c,size:d,fillOpacity:{value:1}},hover:{fillOpacity:{value:.5},cursor:{value:a.hoverCursor}}}};return e}function getScatterToolTipMark(a,b){a.toolTip.height=50,a.toolTip.y=-50;var c=getToolTipMark(a,b),d={type:"text",properties:{update:{x:{value:6},y:{value:44},text:{template:"Size 	 ("+b.names[a.size]+") 	 {{hover."+b.names[a.size]+"}}"},fill:{value:"black"}}}};return c.marks.push(d),c}function checkConfig(a,b){null==a.color?a.color=-1:"*"!=a.color&&(a.color=b.names.indexOf(a.color)),null==a.size?a.size=-1:a.size=b.names.indexOf(a.size);var c={title:"table",mapType:-1,mode:"stack",colorScale:"category10",colorDomain:-1,maxLength:-1,markSize:2,fillOpacity:1,innerRadius:0,renderer:"svg",padding:{top:10,left:50,bottom:40,right:50},dateFormat:"%x %X",range:!1,rangeColor:"#222",selectionColor:"#222",barGap:1,mapColor:"#888",hoverCursor:"pointer",rangeCursor:"grab",textColor:"#888",tooltip:{enabled:!0,color:"#e5f2ff",type:"symbol"},legend:!0,legendTitle:"Legend",legendTitleColor:"#222",legendTitleFontSize:13,legendTextColor:"#888",ledgendTextFontSize:12,xTitle:a.x,yTitle:a.y,xAxisAngle:!1,yAxisAngle:!1,xAxisStrokeSize:0,xAxisColor:"#222",xAxisSize:1,xAxisFontSize:10,xAxisTitleFontSize:12,xAxisTitleFontColor:"#222",yAxisStrokeSize:0,yAxisColor:"#222",yAxisSize:1,yAxisFontSize:10,yAxisTitleFontSize:12,yAxisTitleFontColor:"#222",grid:!0,zero:!1,xTicks:0,yTicks:0,xFormat:"",yFormat:"",xScaleDomain:null,yScaleDomain:null};return"undefined"!=typeof vizgSettings&&(c=extend(c,vizgSettings)),a=extend(c,a),a.height=a.height-(a.padding.top+a.padding.bottom),a.width=a.width-(a.padding.left+a.padding.right),"string"==typeof a.colorScale?a.markColor=window.d3.scale[a.colorScale]().range()[0]:a.markColor=a.colorScale[0],a.x=b.names.indexOf(a.x),a.y=b.names.indexOf(a.y),null==a.xScaleDomain&&(a.xScaleDomain={data:a.title,field:b.names[a.x]}),null==a.yScaleDomain&&(a.yScaleDomain={data:a.title,field:b.names[a.y]}),a}function buildTable(a){var b={};return b.metadata=a[0].metadata,b.values=buildData(a[0].data,a[0].metadata),b}function buildData(a,b){for(chartData=[],i=0;i<a.length;i++){var c={};for(x=0;x<b.names.length;x++)c[b.names[x]]=a[i][x];chartData.push(c)}return chartData}function getSymbolMark(a,b){var c;c=-1!=a.color?{scale:"color",field:b.names[a.color]}:{value:a.markColor};var d={name:"points-group",type:"symbol",from:{data:a.title},properties:{update:{x:{scale:"x",field:b.names[a.x]},y:{scale:"y",field:b.names[a.y]},fill:c,size:{value:a.markSize},fillOpacity:{value:a.fillOpacity}},hover:{cursor:{value:a.hoverCursor}}}};return d}function getSignals(a,b){var c=[{name:"hover",init:{},streams:[{type:a.hoverType+":mouseover",expr:"datum"},{type:a.hoverType+":mouseout",expr:"{}"}]}];return c}function bindTooltip(a,b,c,d,e,f){c.on("mouseover",function(c,g){if(null!=g&&"exit"!=g.status&&g.mark.marktype==b){var h=$(".marks")[0];$("#wrapper #tip").length&&$tip.remove(),$(a).wrap("<div id='wrapper' style='position: relative'></div>"),$("#wrapper").append("<div id='tip' class='tooltipClass' style='top:0; left: 0; position: absolute'></div>"),$tip=$("#tip"),$tip.empty();var i=g.datum,j="";for(var k in i)if(i.hasOwnProperty(k))if(void 0!=f){for(var l=0;l<f.length;l++)for(var m in d)if(m==f[l]&&e.names[d[m]]==k){j+="<p>"+f[l]+" ("+k+"):"+i[k]+"</p>";break}}else e.names[d.x]==k&&(j+="<p>X ("+k+"):"+i[k]+"</p>"),e.names[d.y]==k&&(j+="<p>Y ("+k+"):"+i[k]+"</p>");$tip.append(j);var n=h.width,o=h.height,p=$('.marks[style*="width"]');p.length>0&&(n=parseFloat($(".marks")[0].style.width),o=parseFloat($(".marks")[0].style.height));var q,r=$tip.width(),s=$tip.height(),t=g.bounds.x2+d.padding.left+r,u=o-g.bounds.y2-d.padding.top+s,v=g.bounds.y2+d.padding.top-s;q=t>n?g.bounds.x2+d.padding.left-r:g.bounds.x2+d.padding.left,u>o&&(v=g.bounds.y2+d.padding.top),$tip.css({left:q,top:v}).show()}else $("#wrapper #tip").length&&$tip.remove(),$(a).closest("#wrapper").length&&$(a).unwrap()})}function createTooltip(a){document.getElementById(a.replace("#","")).innerHTML=document.getElementById(a.replace("#","")).innerHTML+"<div id= "+a.replace("#","")+"-tooltip></div>"}function bindTooltip(a,b,c,d){b.on("mouseover",function(b,e){if(null!=e&&e.mark.marktype==c.tooltip.type){var f=e.datum;null!=e.datum&&null!=e.datum.a&&(f=e.datum.a);var g=document.getElementById(a.replace("#","")+"-tooltip"),h="";if(null!=f[d.names[c.x]]){var i;if(null==c.tooltip.content){if("time"==d.types[c.x]){var j=d3.time.format(c.dateFormat);i=j(new Date(parseInt(f[d.names[c.x]])))}else i=f[d.names[c.x]];h+="<b>"+d.names[c.x]+"</b> : "+i+"<br/>",null!=f[d.names[c.y]]&&(h+="<b>"+d.names[c.y]+"</b> : "+f[d.names[c.y]]+"<br/>")}else for(var k=0;k<c.tooltip.content.length;k++){if("time"===d.types[d.names.indexOf(c.tooltip.content[k])]){var j=d3.time.format(c.dateFormat);i=j(new Date(parseInt(f[d.names[c.x]])))}else i=f[c.tooltip.content[k]];h+=0!=c.tooltip.label?"<b>"+c.tooltip.content[k]+"</b> : "+i+"<br/>":i+"<br/>"}}""!=h&&(g.innerHTML=h,g.style.padding="5px 5px 5px 5px"),window.onmousemove=function(b){g.style.top=b.clientY+15+"px",g.style.left=b.clientX+10+"px",g.style.zIndex=1e3,g.style.backgroundColor=c.tooltip.color,g.style.position="fixed",g.offsetWidth+b.clientX-(cumulativeOffset(document.getElementById(a.replace("#",""))).left+c.padding.left)>document.getElementById(a.replace("#","")).offsetWidth&&(g.style.left=b.clientX-g.offsetWidth+"px"),b.clientY-(cumulativeOffset(document.getElementById(a.replace("#",""))).top+500)>document.getElementById(a.replace("#","")).offsetHeight&&(g.style.top=b.clientY-400+"px")}}}).on("mouseout",function(b,c){var d=document.getElementById(a.replace("#","")+"-tooltip");d.style.padding="0px 0px 0px 0px",d.innerHTML=""}).update()}function cumulativeOffset(a){var b=0,c=0;do b+=a.offsetTop||0,c+=a.offsetLeft||0,a=a.offsetParent;while(a);return{top:b,left:c}}function getXYAxes(a,b,c,d,e){var f={ticks:{stroke:{value:a.xAxisColor},strokeWidth:{value:a.xAxisStrokeSize}},labels:{fill:{value:a.xAxisColor},fontSize:{value:a.xAxisFontSize}},title:{fontSize:{value:a.xAxisTitleFontSize},fill:{value:a.xAxisTitleFontColor}},axis:{stroke:{value:a.xAxisColor},strokeWidth:{value:a.xAxisSize}}},g={ticks:{stroke:{value:a.yAxisColor},strokeWidth:{value:a.yAxisStrokeSize}},labels:{fill:{value:a.yAxisColor},fontSize:{value:a.yAxisFontSize}},title:{fontSize:{value:a.yAxisTitleFontSize},fill:{value:a.yAxisTitleFontColor}},axis:{stroke:{value:a.yAxisColor},strokeWidth:{value:a.yAxisSize}}};a.xAxisAngle&&(f.labels.angle={value:45},f.labels.align={value:"left"},f.labels.baseline={value:"middle"}),a.yAxisAngle&&(g.labels.angle={value:45},g.labels.align={value:"left"},g.labels.baseline={value:"middle"});var h=[{type:b,scale:c,grid:a.grid,format:a.xFormat,ticks:a.xTicks,title:a.xTitle,properties:f},{type:d,scale:e,grid:a.grid,format:a.yFormat,ticks:a.yTicks,title:a.yTitle,properties:g}];return h}function getXYScales(a,b){var c={name:"x",type:b.types[a.x],range:"width",zero:a.zero,domain:a.xScaleDomain},d={name:"y",type:b.types[a.y],range:"height",zero:a.zero,domain:a.yScaleDomain};return[c,d]}function getRangeSignals(a,b){return b.push({name:"range_start",streams:[{type:"mousedown",expr:"eventX()",scale:{name:"x",invert:!0}}]}),b.push({name:"range_end",streams:[{type:"mousedown, [mousedown, window:mouseup] > window:mousemove",expr:"clamp(eventX(), 0, "+a.width+")",scale:{name:"x",invert:!0}}]}),b}function getRangeMark(a,b){return b.push({type:"rect",properties:{enter:{y:{value:0},height:{value:a.height},fill:{value:a.rangeColor},fillOpacity:{value:.3}},update:{x:{scale:"x",signal:"range_start"},x2:{scale:"x",signal:"range_end"}}}}),b}function getLegend(a){var b=[{name:"legend",fill:"color",title:a.legendTitle,offset:0,properties:{symbols:{stroke:{value:"transparent"}},title:{fill:{value:a.legendTitleColor},fontSize:{value:a.legendTitleFontSize}},labels:{fill:{value:a.legendTextColor},fontSize:{value:a.ledgendTextFontSize}}}}];return b}function drawChart(a,b,c){var d=function(d){if(b.config.tooltip.enabled?(createTooltip(a),b.view=d({el:a}).renderer(b.config.renderer).update(),bindTooltip(a,b.view,b.config,b.metadata)):b.view=d({el:a}).renderer(b.config.renderer).update(),null!=c)for(var e=0;e<c.length;e++)if("range"==c[e].type){var f,g,h=c[e].callback;b.config.range&&(document.getElementById(a.replace("#","")).style.cursor="grab",b.view.onSignal("range_start",function(a,b){f=b}),b.view.onSignal("range_end",function(a,b){g=b,h(f,g)}))}else b.view.on(c[e].type,c[e].callback)}.bind(b);vg.parse.spec(b.spec,d)}var arc=function(a,b){this.metadata=a[0].metadata;var c=[];this.spec={},b=checkConfig(b,this.metadata),this.config=b,a[0].name=b.title;var d={};d[this.metadata.names[b.x]]="sum",console.log(d),a.push({name:"summary",source:b.title,transform:[{type:"aggregate",summarize:d}]}),a.push({name:"layout",source:"table",transform:[{type:"cross","with":"summary"},{type:"pie",field:"a."+this.metadata.names[b.x]},{type:"formula",field:"percentage",expr:"datum.a."+this.metadata.names[b.x]+" / datum.b.sum_"+this.metadata.names[b.x]+" * 100"}]});var e=[];-1==b.colorDomain&&(b.colorDomain={data:b.title,field:this.metadata.names[b.color]});var f={name:"color",type:"ordinal",domain:b.colorDomain,range:b.colorScale};e.push(f),!b.percentage||"pie"!=b.mode&&"donut"!=b.mode?b.percentage&&(a.push({name:"arc",values:[{type:"YES"}]}),c.push(getPieMidText(b,this.metadata))):c.push(getPieText(b,this.metadata)),c.push(getPieMark(b,this.metadata));var g="Legend";"table"!=b.title&&(g=b.title),this.config.legend&&(this.spec.legends=getLegend(this.config)),this.spec.width=b.width,this.spec.height=b.height,this.spec.data=a,this.spec.scales=e,this.spec.padding=b.padding,this.spec.marks=c};arc.prototype.draw=function(a,b){var c=function(c){if(this.config.tooltip.enabled?(this.config.tooltip.type="arc",createTooltip(a),this.view=c({el:a}).renderer(this.config.renderer).update(),bindTooltip(a,this.view,this.config,this.metadata)):this.view=c({el:a}).renderer(this.config.renderer).update(),null!=b)for(var d=0;d<b.length;d++)this.view.on(b[d].type,b[d].callback)}.bind(this);if(-1!=this.config.maxLength){var d=this.spec.data[0].values,e=this.config.maxLength;if(d.length>=this.config.maxLength){for(var f=[],g=d.length-e,h=g;h<d.length;h++)f.push(d[h]);this.spec.data[0].values=f}}vg.parse.spec(this.spec,c)},arc.prototype.insert=function(a){var b=this.metadata.names[this.config.color],c=this.metadata.names[this.config.x],d=this.view,e=!1;for(i=0;i<a.length;i++)this.view.data(this.config.title).update(function(c){return c[b]==a[i][b]},c,function(b){return e=!0,a[i][c]});0==e&&d.data(this.config.title).insert(a),this.view.update({duration:500})},arc.prototype.getSpec=function(){return this.spec};var area=function(a,b){this.metadata=a[0].metadata;var c=[],d=[];this.spec={},b=checkConfig(b,this.metadata),this.config=b,a[0].name=b.title;var e=getXYScales(b,this.metadata);if(delete e[1].zero,-1!=b.color){-1==b.colorDomain&&(b.colorDomain={data:b.title,field:this.metadata.names[b.color]});var f={name:"color",type:"ordinal",domain:b.colorDomain,range:b.colorScale};e.push(f);var g="Legend";"table"!=b.title&&(g=b.title),this.config.legend&&(this.spec.legends=getLegend(this.config))}var h=getXYAxes(b,"x","x","y","y");c.push(getAreaMark(b,this.metadata)),b.fillOpacity=0,b.markSize=1e3,c.push(getSymbolMark(b,this.metadata)),b.range&&(d=getRangeSignals(b,d),c=getRangeMark(b,c)),this.spec.width=b.width,this.spec.height=b.height,this.spec.axes=h,this.spec.data=a,this.spec.scales=e,this.spec.padding=b.padding,this.spec.marks=c,this.spec.signals=d};area.prototype.draw=function(a,b){if(-1!=this.config.maxLength){var c=this.spec.data[0].values,d=this.config.maxLength;if(c.length>=this.config.maxLength){for(var e=[],f=c.length-d,g=f;g<c.length;g++)e.push(c[g]);this.spec.data[0].values=e}}drawChart(a,this,b)},area.prototype.insert=function(a){if(-1!=this.config.maxLength&&this.config.maxLength<this.view.data(this.config.title).values().length+a.length){var b=function(a){return a[this.metadata.names[this.config.x]]==c}.bind(this);for(i=0;i<a.length;i++){var c=this.view.data(this.config.title).values()[i][this.metadata.names[this.config.x]];this.view.data(this.config.title).remove(b)}}this.view.data(this.config.title).insert(a),this.view.update()},area.prototype.getSpec=function(){return this.spec};var bar=function(a,b){this.metadata=a[0].metadata;var c=[],d=[];this.spec={};var e,f,g,h,i,j,k=[];if(b=checkConfig(b,this.metadata),this.config=b,a[0].name=b.title,"left"==b.orientation?(g="height",h="width",i="y",j="x"):(g="width",h="height",i="x",j="y"),-1!=b.color){var l="Legend";"table"!=b.title&&(l=b.title),-1==b.colorDomain&&(b.colorDomain={data:b.title,field:this.metadata.names[b.color]});var m={name:"color",type:"ordinal",domain:b.colorDomain,range:b.colorScale};if(d.push(m),"stack"==b.mode){var n={name:"stack",source:b.title,transform:[{type:"aggregate",groupby:[this.metadata.names[b.x]],summarize:[{field:this.metadata.names[b.y],ops:["sum"]}]}]};a.push(n),e="sum_"+this.metadata.names[b.y],f="stack"}else e=this.metadata.names[b.y],f=b.title;this.config.legend&&(this.spec.legends=getLegend(this.config))}else e=this.metadata.names[b.y],f=b.title;var o={name:"x",type:"ordinal",range:g,domain:b.xScaleDomain};"group"==b.mode&&(o.padding=.2),b.yScaleDomain.constructor!==Array&&(b.yScaleDomain={data:f,field:e});var p={name:"y",type:this.metadata.types[b.y],range:h,domain:b.yScaleDomain};d.push(o),d.push(p);var q=getXYAxes(b,i,"x",j,"y");if(-1!=b.color&&"stack"==b.mode?c.push(getStackBarMark(b,this.metadata)):-1!=b.color&&"group"==b.mode?c.push(getGroupBarMark(b,this.metadata)):c.push(getBarMark(b,this.metadata)),b.range&&(k=getRangeSignals(b,k),c=getRangeMark(b,c)),"left"==b.orientation&&null!=b.text){var r={value:5};if("right"==b.textAlign)var r={scale:"y",field:this.metadata.names[b.y],offset:2};c.push({type:"text",from:{data:"table"},properties:{update:{x:r,dy:{scale:"x",band:!0,mult:.5},y:{scale:"x",field:this.metadata.names[b.x]},align:{value:"left"},text:{field:this.metadata.names[b.x]},fill:{value:b.textColor}}}})}if("single"==b.highlight||"multi"==b.highlight){var s;s="multi"==b.highlight?"!multi":"multi",a.push({name:"selectedPoints",modify:[{type:"clear",test:s},{type:"toggle",signal:"clickedPoint",field:"id"}]}),k.push({name:"clickedPoint",init:0,verbose:!0,streams:[{type:"click",expr:"datum._id"}]},{name:"multi",init:!1,verbose:!0,streams:[{type:"click",expr:"datum._id"}]}),c[0].properties.update.fill=[{test:"indata('selectedPoints', datum._id, 'id')",value:b.selectionColor},c[0].properties.update.fill]}this.spec.width=b.width,this.spec.height=b.height,this.spec.axes=q,this.spec.data=a,this.spec.scales=d,this.spec.padding=b.padding,this.spec.marks=c,this.spec.signals=k;JSON.stringify(this.spec)};bar.prototype.draw=function(a,b){if(-1!=this.config.maxLength){var c=this.spec.data[0].values,d=this.config.maxLength;if(c.length>=this.config.maxLength){for(var e=[],f=c.length-d,g=f;g<c.length;g++)e.push(c[g]);this.spec.data[0].values=e}}this.config.tooltip.type="rect",drawChart(a,this,b)},bar.prototype.insert=function(a){var b=this.metadata.names[this.config.x],c=this.metadata.names[this.config.y],d=(this.metadata.names[this.config.size],this.metadata.names[this.config.color]);if(-1!=this.config.maxLength&&this.config.maxLength<this.view.data(this.config.title).values().length+a.length){var e=this.view.data(this.config.title).values().concat(a),f=[];for(i=0;i<e.length-this.config.maxLength;i++)f.push(this.view.data(this.config.title).values()[i][b]);for(i=0;i<a.length;i++){var g=!1;if(this.view.data(this.config.title).update(function(c){return null==d?c[b]==a[i][b]:c[b]==a[i][b]&&c[d]==a[i][d]},c,function(b){return g=!0,a[i][c]}),g){var h=!1,j=f.indexOf(a[i][b]);j>-1&&(h=!0,f.splice(j,1)),h||f.splice(f.length-1,1)}else this.view.data(this.config.title).insert([a[i]]),this.view.update()}var k,l=function(a){return a[b]==k};for(i=0;i<f.length;i++)k=f[i],this.view.data(this.config.title).remove(l)}else for(i=0;i<a.length;i++){var g=!1;this.view.data(this.config.title).update(function(c){return null==d?c[b]==a[i][b]:c[b]==a[i][b]&&c[d]==a[i][d]},c,function(b){return g=!0,a[i][c]}),g||this.view.data(this.config.title).insert([a[i]])}"group"==this.config.mode?this.view.update():this.view.update({duration:200})},bar.prototype.getSpec=function(){return this.spec},bar.prototype.setSpec=function(a){this.spec=a};var vizg=function(a,b){if(a=buildTable(a),"undefined"!=typeof b.charts&&1==b.charts.length){for(var c in b.charts[0])b.charts[0].hasOwnProperty(c)&&(b[c]=b.charts[0][c]);this.chart=new window[b.type]([a],b)}};vizg.prototype.draw=function(a,b){this.chart.draw(a,b)},vizg.prototype.insert=function(a){this.chart.insert(buildData(a,this.chart.metadata))},vizg.prototype.getSpec=function(){return this.chart.getSpec()};var line=function(a,b){this.metadata=a[0].metadata;var c=[],d=[];this.spec={},b=checkConfig(b,this.metadata),this.config=b,a[0].name=b.title;var e=getXYScales(b,this.metadata);if(-1!=b.color){-1==b.colorDomain&&(b.colorDomain={data:b.title,field:this.metadata.names[b.color]});var f={name:"color",type:"ordinal",domain:b.colorDomain,range:b.colorScale};e.push(f)}var g=getXYAxes(b,"x","x","y","y");if(c.push(getLineMark(b,this.metadata)),b.markSize=20,c.push(getSymbolMark(b,this.metadata)),b.range&&(d=getRangeSignals(b,d),c=getRangeMark(b,c)),-1!=b.color){var h="Legend";"table"!=b.title&&(h=b.title),this.config.legend&&(this.spec.legends=getLegend(this.config))}this.spec.width=b.width,this.spec.height=b.height,this.spec.axes=g,this.spec.data=a,this.spec.scales=e,this.spec.padding=b.padding,this.spec.marks=c,this.spec.signals=d};line.prototype.draw=function(a,b){if(-1!=this.config.maxLength){var c=this.spec.data[0].values,d=this.config.maxLength;if(c.length>=this.config.maxLength){for(var e=[],f=c.length-d,g=f;g<c.length;g++)e.push(c[g]);this.spec.data[0].values=e}}drawChart(a,this,b)},line.prototype.insert=function(a){if(-1!=this.config.maxLength&&this.config.maxLength<this.view.data(this.config.title).values().length+a.length){var b=function(a){return a[this.metadata.names[this.config.x]]==c}.bind(this);for(i=0;i<a.length;i++){var c=this.view.data(this.config.title).values()[i][this.metadata.names[this.config.x]];this.view.data(this.config.title).remove(b)}}this.view.data(this.config.title).insert(a),this.view.update()},line.prototype.getSpec=function(){return this.spec};var map=function(a,b){this.metadata=a[0].metadata;var c,d,e=[],f=[];this.spec={};var g;for(g=loadGeoMapCodes(b.helperUrl),b=checkConfig(b,this.metadata),this.config=b,this.config.geoInfoJson=g,i=0;i<a[0].values.length;i++)for(var h in a[0].values[i])if(h==a[0].metadata.names[b.x]&&a[0].values[i].hasOwnProperty(h)){a[0].values[i].unitName=a[0].values[i][h],a[0].values[i][h]=getMapCode(a[0].values[i][h],b.mapType,g);break}a[0].name=b.title,a[0].transform=[{type:"formula",field:"v",expr:"datum."+this.metadata.names[b.y]}],b.tooltip.enabled&&(c=getMapMark(b,this.metadata),d=getMapSignals(),this.spec.signals=d),a.push(getTopoJson(b,this.metadata)),e.push(getMapPredicates()),b.legend&&f.push(getMapLegends(b,this.metadata));var j={name:"color",type:"linear",domain:{data:"geoData",field:"zipped.v"},domainMin:0,zero:!1,range:b.colorScale},k=[j];this.spec.width=b.width,this.spec.height=b.height,this.spec.data=a,this.spec.scales=k,this.spec.padding=b.padding,this.spec.marks=c,this.spec.predicates=e,this.spec.legends=f};map.prototype.draw=function(a,b){var c=function(c){if(this.view=c({el:a}).renderer(this.config.renderer).update(),null!=b)for(var d=0;d<b.length;d++)this.view.on(b[d].type,b[d].callback)}.bind(this);vg.parse.spec(this.spec,c)},map.prototype.insert=function(a){var b=this.metadata.names[this.config.x],c=this.metadata.names[this.config.y],d=this.metadata.names[this.config.color],e=this.config.mapType,f=this.config.geoInfoJson;for(i=0;i<a.length;i++)for(var g in a[i])if(g==b&&a[i].hasOwnProperty(g)){a[i].unitName=a[i][g],a[i][g]=getMapCode(a[i][g],e,f);break}for(i=0;i<a.length;i++){var h=!1;this.view.data(this.config.title).update(function(c){return c[b]==a[i][b]},c,function(b){return h=!0,a[i][c]}),this.view.data(this.config.title).update(function(c){return c[b]==a[i][b]},d,function(b){return h=!0,a[i][d]}),h||this.view.data(this.config.title).insert([a[i]])}this.view.update()};var number=function(a,b){this.metadata=a[0].metadata,this.data=a[0].values;this.spec={},b=checkConfig(b,this.metadata),this.config=b,a[0].name=b.title};number.prototype.draw=function(a){a=a.replace("#","");var b=a+"Content",c="";null!=this.data&&0!=this.data.length&&(c=this.data[this.data.length-1][this.metadata.names[this.config.x]]);var d="<p style='padding: 0px 0px 0px 20px;'>"+this.config.title+"</p><br/><p align='center' style='font-size:60px;padding: 0px 0px 0px 20px;' id='"+b+"'>"+c+"</p>";document.getElementById(a).innerHTML=d,this.view=b},number.prototype.insert=function(a){document.getElementById(this.view).innerHTML=a[a.length-1][this.metadata.names[this.config.x]]};var scatter=function(a,b){this.metadata=a[0].metadata;var c=[];this.spec={},b=checkConfig(b,this.metadata),this.config=b,a[0].name=b.title;var d={name:"size",type:"linear",range:[0,576],domain:{data:b.title,field:this.metadata.names[b.size]}},e={name:"color",type:this.metadata.types[b.color],range:b.colorScale,domain:{data:b.title,field:this.metadata.names[b.color]}},f=getXYScales(b,this.metadata);f.push(d),f.push(e);var g=getXYAxes(b,"x","x","y","y");c.push(getScatterMark(b,this.metadata)),this.config.legend&&"linear"!=this.metadata.types[b.color]&&(this.spec.legends=getLegend(this.config)),this.spec.width=b.width,this.spec.height=b.height,this.spec.axes=g,this.spec.data=a,this.spec.scales=f,this.spec.padding=b.padding,this.spec.marks=c};scatter.prototype.draw=function(a,b){var c=function(c){if(this.config.tooltip.enabled?(createTooltip(a),this.view=c({el:a}).renderer(this.config.renderer).update(),bindTooltip(a,this.view,this.config,this.metadata)):this.view=c({el:a}).renderer(this.config.renderer).update(),null!=b)for(var d=0;d<b.length;d++)this.view.on(b[d].type,b[d].callback)}.bind(this);if(-1!=this.config.maxLength){var d=this.spec.data[0].values,e=this.config.maxLength;if(d.length>=this.config.maxLength){for(var f=[],g=d.length-e,h=g;h<d.length;h++)f.push(d[h]);this.spec.data[0].values=f}}vg.parse.spec(this.spec,c)},scatter.prototype.insert=function(a){var b=this.metadata.names[this.config.x],c=this.metadata.names[this.config.y],d=this.metadata.names[this.config.size],e=this.metadata.names[this.config.color];if(-1!=this.config.maxLength&&this.config.maxLength<this.view.data(this.config.title).values().length+a.length){var f=this.view.data(this.config.title).values().concat(a),g=[];for(i=0;i<f.length-this.config.maxLength;i++)g.push(this.view.data(this.config.title).values()[i][b]);for(i=0;i<a.length;i++){var h=!1;if(this.view.data(this.config.title).update(function(c){return c[b]==a[i][b]},c,function(b){return h=!0,a[i][c]}),this.view.data(this.config.title).update(function(c){return c[b]==a[i][b]},e,function(b){return h=!0,a[i][e]}),this.view.data(this.config.title).update(function(c){return c[b]==a[i][b]},d,function(b){return h=!0,a[i][d]}),h){var j=!1,k=g.indexOf(a[i][b]);k>-1&&(j=!0,g.splice(k,1)),j||g.splice(g.length-1,1)}else this.view.data(this.config.title).insert([a[i]]),this.view.update()}var l,m=function(a){return a[b]==l};for(i=0;i<g.length;i++)l=g[i],this.view.data(this.config.title).remove(m)}else for(i=0;i<a.length;i++){var h=!1;this.view.data(this.config.title).update(function(c){return c[b]==a[i][b]},c,function(b){return h=!0,a[i][c]}),this.view.data(this.config.title).update(function(c){return c[b]==a[i][b]},e,function(b){return h=!0,a[i][e]}),this.view.data(this.config.title).update(function(c){return c[b]==a[i][b]},d,function(b){return h=!0,a[i][d]}),h||this.view.data(this.config.title).insert([a[i]]);
}this.view.update({duration:200})},scatter.prototype.getSpec=function(){return this.spec};var table=function(a,b){this.metadata=a[0].metadata,this.data=a[0].values;this.spec={},b=checkConfig(b,this.metadata),this.config=b,a[0].name=b.title};table.prototype.draw=function(a){var b=d3.select(a).append("table").attr("class","table table-bordered").attr("id",this.config.title);b.append("thead").attr("align","center").append("tr").selectAll("th").data(this.config.columnTitles).enter().append("th").html(function(a){return a}),b.append("tbody").attr("id","tableChart-"+this.config.title),this.setupData(this.data,this.config),b.selectAll("thead th").html(function(a){return a.charAt(0).toUpperCase()+a.substr(1)})},table.prototype.insert=function(a){this.setupData(a,this.config)},table.prototype.setupData=function(a,b){for(var c=[],d=this.metadata.names,e=0;e<a.length;e++){for(var f={},g=0;g<b.columns.length;g++)f[b.columns[g]]=a[e][b.columns[g]];c.push(f)}var h=d3.select("#tableChart-"+b.title).selectAll("tr").data(c,function(a){return a[b.key]}),i=h.enter().append("tr").selectAll("td").data(function(a){return b.columns.map(function(b){return{column:b,value:a[b]}})}).enter().append("td");-1!=b.color&&d3.select("#tableChart-"+b.title).selectAll("td").attr("bgcolor",function(a){var c,e=a.key||a.column;c="string"==typeof b.colorScale?window.d3.scale[b.colorScale]().range():b.colorScale;for(var f,g=0;g<d.length;g+=1)d[g]===e&&(f=g);if("string"==typeof a.value){var h;h=-1==b.colorDomain?[d3.min(d3.select("#tableChart-"+b.title).selectAll("tr").data(),function(a){return a[e]}),d3.max(d3.select("#tableChart-"+b.title).selectAll("tr").data(),function(a){return a[e]})]:b.colorDomain;var i=d3.scale.ordinal().range(b.colorScale).domain(h);return i(a.value)}if("*"==b.color||e==d[b.color]){var i=d3.scale.linear().range(["#f2f2f2",c[f]]).domain([d3.min(d3.select("#tableChart-"+b.title).selectAll("tr").data(),function(a){return a[e]}),d3.max(d3.select("#tableChart-"+b.title).selectAll("tr").data(),function(a){return a[e]})]);return i(a.value)}}),i.append("span");var j=h.selectAll("td").style({padding:"0px 10px 0px 10px"}).data(function(a){return d3.map(a).entries()}).attr("class",function(a){return a.key});if(j.select("span").html(function(a){return a.value}),-1!=b.maxLength&&d3.select("tbody").selectAll("tr").data().length>b.maxLength){var k=d3.select("tbody").selectAll("tr").data().slice(d3.select("tbody").selectAll("tr").data().length-b.maxLength,b.maxLength);d3.select("tbody").selectAll("tr").data(k,function(a){return a}).remove()}};var extend=function(a,b){var c,d={};for(c in a)Object.prototype.hasOwnProperty.call(a,c)&&(d[c]=a[c]);for(c in b)Object.prototype.hasOwnProperty.call(b,c)&&(d[c]=b[c]);return d},stack=function(a,b){this.barChart=new bar(a,b),this.metadata=this.barChart.metadata;var c=this.barChart.getSpec();c.axes=[c.axes[0]],c.axes[0].grid=!1,c.data.push({name:"selectedPoints",modify:[{type:"clear",test:"!multi"},{type:"toggle",signal:"clickedPoint",field:"id"}]}),c.signals.push({name:"clickedPoint",init:0,verbose:!0,streams:[{type:"click",expr:"datum._id"}]},{name:"multi",init:!1,verbose:!0,streams:[{type:"click",expr:"datum._id"}]});var d=JSON.parse(JSON.stringify(c.marks[0]));d.type="text",d.properties.update.text={field:c.marks[0].properties.update.fill.field},d.properties.update.x.offset=10,d.properties.update.y.offset=-5,d.properties.update.fill={value:b.legendTitleColor},delete d.properties.update.y2,delete d.properties.hover,c.marks.push(d),delete c.marks[0].properties.hover,c.marks[0].properties.update.fill=[{test:"indata('selectedPoints', datum._id, 'id')",value:b.selectionColor},c.marks[0].properties.update.fill],this.barChart.setSpec(c)};stack.prototype.draw=function(a,b){this.barChart.draw(a,b)},stack.prototype.insert=function(a){this.barChart.insert(a)},stack.prototype.getSpec=function(){return this.barChart.getSpec()};