/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.bpmn.analytics.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.ei.bpmn.analytics.core.clients.BPMNAnalyticsCoreRestClient;
import org.wso2.ei.bpmn.analytics.core.models.AggregateField;
import org.wso2.ei.bpmn.analytics.core.models.AggregateQuery;
import org.wso2.ei.bpmn.analytics.core.models.SearchQuery;
import org.wso2.ei.bpmn.analytics.core.utils.BPMNAnalyticsCoreUtils;

public class ProcessLevelMonitor {
    private static final Log log = LogFactory.getLog(ProcessLevelMonitor.class);

    public String getTotalCompletedTasksVsUserIdForProcess(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                long from = filterObj.getLong("startTime");
                long to = filterObj.getLong("endTime");
                String processId = filterObj.getString("processDefKey");
                String order = filterObj.getString("order");
                int userCount = filterObj.getInt("count");
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("completedTotalTasks");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("TASK_USAGE_SUMMARY_DATA");
                query.setGroupByField("assignUser");
                String queryStr = "processDefinitionId:\"'" + processId + "'\"";
                if (from != 0L && to != 0L) {
                    queryStr = queryStr + " AND " + BPMNAnalyticsCoreUtils.getDateRangeQuery("finishedTime", from, to);
                }
                query.setQuery(queryStr);
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Total Completed Tasks Vs User Id for process: " + processId + " | Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Integer> table = new Hashtable<String, Integer>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String assignee = values.getJSONArray("assignUser").getString(0);
                        int totalInvolvedTasks = values.getInt("completedTotalTasks");
                        table.put(assignee, totalInvolvedTasks);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getIntegerValueSortedList(table, "assignUser", "completedTotalTasks", order, userCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Total Completed Tasks Vs UserId UserLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total Completed Tasks Vs User Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getTotalTimeVsUserIdForProcess(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                String processId = filterObj.getString("processId");
                String order = filterObj.getString("order");
                int taskCount = filterObj.getInt("count");
                AggregateField avgField = new AggregateField();
                avgField.setFieldName("duration");
                avgField.setAggregate("SUM");
                avgField.setAlias("totalInvolvedTime");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(avgField);
                String queryStr = "processDefinitionId:\"'" + processId + "'\"";
                AggregateQuery query = new AggregateQuery();
                query.setTableName("TASK_USAGE_SUMMARY_DATA");
                query.setGroupByField("assignUser");
                query.setQuery(queryStr);
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get total execution time Vs User Id for process. | Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Double> table = new Hashtable<String, Double>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String userId = values.getJSONArray("assignUser").getString(0);
                        double totalExecTime = values.getInt("totalInvolvedTime");
                        table.put(userId, totalExecTime);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getDoubleValueSortedList(table, "assignUser", "totalInvolvedTime", order, taskCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - total execution time Vs UserId ProcessLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total Waiting Time Vs User Id for process. Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getAvgExecuteTimeVsProcessId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                long from = filterObj.getLong("startTime");
                long to = filterObj.getLong("endTime");
                String order = filterObj.getString("order");
                int processCount = filterObj.getInt("count");
                AggregateField avgField = new AggregateField();
                avgField.setFieldName("duration");
                avgField.setAggregate("AVG");
                avgField.setAlias("avgExecutionTime");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(avgField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("PROCESS_USAGE_SUMMARY_DATA");
                query.setGroupByField("processDefKey");
                if (from != 0L && to != 0L) {
                    query.setQuery(BPMNAnalyticsCoreUtils.getDateRangeQuery("finishedTime", from, to));
                }
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Avg Execution Time Vs ProcessId Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Double> table = new Hashtable<String, Double>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String processDefKey = values.getJSONArray("processDefKey").getString(0);
                        double avgExecTime = values.getDouble("avgExecutionTime");
                        table.put(processDefKey, avgExecTime);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getDoubleValueSortedList(table, "processDefKey", "avgExecutionTime", order, processCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Avg Execution Time Vs ProcessId ProcessLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Avg Execution Time Vs ProcessId Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getProcessInstanceCountVsProcessId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                long from = filterObj.getLong("startTime");
                long to = filterObj.getLong("endTime");
                String order = filterObj.getString("order");
                int processCount = filterObj.getInt("count");
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("processInstanceCount");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("PROCESS_USAGE_SUMMARY_DATA");
                query.setGroupByField("processDefKey");
                if (from != 0L && to != 0L) {
                    query.setQuery(BPMNAnalyticsCoreUtils.getDateRangeQuery("finishedTime", from, to));
                }
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Process Instance Count Vs ProcessId Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Integer> table = new Hashtable<String, Integer>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String processDefKey = values.getJSONArray("processDefKey").getString(0);
                        int processInstanceCount = values.getInt("processInstanceCount");
                        table.put(processDefKey, processInstanceCount);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getIntegerValueSortedList(table, "processDefKey", "processInstanceCount", order, processCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Process Instance Count Vs ProcessId ProcessLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process Instance Count Vs ProcessId Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getAvgExecuteTimeVsProcessVersion(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                String processKey = filterObj.getString("processKey");
                String order = filterObj.getString("order");
                int processCount = filterObj.getInt("count");
                AggregateField avgField = new AggregateField();
                avgField.setFieldName("duration");
                avgField.setAggregate("AVG");
                avgField.setAlias("avgExecutionTime");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(avgField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("PROCESS_USAGE_SUMMARY_DATA");
                query.setGroupByField("processVer");
                query.setQuery("processKeyName:\"'" + processKey + "'\"");
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Avg Execution Time Vs Process Version Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Double> table = new Hashtable<String, Double>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String processVersion = values.getJSONArray("processVer").getString(0);
                        double avgExecTime = values.getDouble("avgExecutionTime");
                        table.put(processVersion, avgExecTime);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getDoubleValueSortedList(table, "processVer", "avgExecutionTime", order, processCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Avg Execution Time Vs Process Version ProcessLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Avg Execution Time Vs Process Version Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getProcessInstanceCountVsProcessVersion(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                String processKey = filterObj.getString("processKey");
                String order = filterObj.getString("order");
                int processCount = filterObj.getInt("count");
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("processInstanceCount");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("PROCESS_USAGE_SUMMARY_DATA");
                query.setGroupByField("processVer");
                query.setQuery("processKeyName:\"'" + processKey + "'\"");
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Process Instance Count Vs Process Version Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Integer> table = new Hashtable<String, Integer>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String processVersion = values.getJSONArray("processVer").getString(0);
                        int processInstanceCount = values.getInt("processInstanceCount");
                        table.put(processVersion, processInstanceCount);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getIntegerValueSortedList(table, "processVer", "processInstanceCount", order, processCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Process Instance Count Vs Process Version ProcessLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process Instance Count Vs Process Version Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getExecutionTimeVsProcessInstanceId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                long from = filterObj.getLong("startTime");
                long to = filterObj.getLong("endTime");
                String processId = filterObj.getString("processId");
                String order = filterObj.getString("order");
                int limit = filterObj.getInt("limit");
                SearchQuery searchQuery = new SearchQuery();
                searchQuery.setTableName("PROCESS_USAGE_SUMMARY_DATA");
                String queryStr = "processDefinitionId:\"'" + processId + "'\"";
                if (from != 0L && to != 0L) {
                    queryStr = queryStr + " AND " + BPMNAnalyticsCoreUtils.getDateRangeQuery("finishedTime", from, to);
                }
                searchQuery.setQuery(queryStr);
                searchQuery.setStart(0);
                searchQuery.setCount(100000);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Execution Time Vs Process Instance Id Result:" + BPMNAnalyticsCoreUtils.getJSONString(searchQuery)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/search"), BPMNAnalyticsCoreUtils.getJSONString(searchQuery));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Double> table = new Hashtable<String, Double>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String processDefKey = values.getString("processInstanceId");
                        double executionTime = values.getDouble("duration");
                        table.put(processDefKey, executionTime);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getDoubleValueSortedList(table, "processInstanceId", "duration", order, limit);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Execution Time Vs Process InstanceId ProcessLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Execution Time Vs Process Instance Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getDateVsProcessInstanceCount(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                long from = filterObj.getLong("startTime");
                long to = filterObj.getLong("endTime");
                boolean aggregateByMonth = filterObj.getBoolean("aggregateByMonth");
                JSONArray processIdList = filterObj.getJSONArray("processIdList");
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("processInstanceCount");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("PROCESS_USAGE_SUMMARY_DATA");
                if (aggregateByMonth) {
                    query.setGroupByField("month");
                } else {
                    query.setGroupByField("finishTime");
                }
                String queryStr = BPMNAnalyticsCoreUtils.getDateRangeQuery("finishedTime", from, to);
                if (processIdList.length() != 0) {
                    queryStr = queryStr + " AND ";
                    for (int i = 0; i < processIdList.length(); ++i) {
                        queryStr = i == 0 ? queryStr + "(processDefinitionId:\"'" + processIdList.getString(i) + "'\"" : queryStr + " OR processDefinitionId:\"'" + processIdList.getString(i) + "'\"";
                        if (i != processIdList.length() - 1) continue;
                        queryStr = queryStr + ")";
                    }
                }
                query.setQuery(queryStr);
                query.setAggregateFields(aggregateFields);
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<Long, Integer> table = new Hashtable<Long, Integer>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        long completedTime = aggregateByMonth ? Long.parseLong(values.getJSONArray("month").getString(0)) : Long.parseLong(values.getJSONArray("finishTime").getString(0));
                        int processInstanceCount = values.getInt("processInstanceCount");
                        table.put(completedTime, processInstanceCount);
                    }
                    sortedResult = aggregateByMonth ? BPMNAnalyticsCoreUtils.getLongKeySortedList(table, "month", "processInstanceCount") : BPMNAnalyticsCoreUtils.getLongKeySortedList(table, "finishTime", "processInstanceCount");
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Date Vs Process Instance Count ProcessLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Date Vs Process Instance Count Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getProcessIdList() {
        String processIdList = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                AggregateField avgField = new AggregateField();
                avgField.setFieldName("*");
                avgField.setAggregate("COUNT");
                avgField.setAlias("processInstanceCount");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(avgField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("PROCESS_USAGE_SUMMARY_DATA");
                query.setGroupByField("processDefKey");
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get the Process Id List Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray array = new JSONArray(result);
                JSONArray resultArray = new JSONArray();
                if (array.length() != 0) {
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject jsonObj = array.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String processDefKey = values.getJSONArray("processDefKey").getString(0);
                        JSONObject o = new JSONObject();
                        o.put("processDefKey", (Object)processDefKey);
                        resultArray.put((Object)o);
                    }
                    processIdList = resultArray.toString();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Process Id List Result:" + processIdList));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"BPMN Analytics Core - process id list error.", (Throwable)e);
        }
        return processIdList;
    }

    public String getProcessKeyList() {
        String processKeyList = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                AggregateField avgField = new AggregateField();
                avgField.setFieldName("*");
                avgField.setAggregate("COUNT");
                avgField.setAlias("processInstanceCount");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(avgField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("PROCESS_USAGE_SUMMARY_DATA");
                query.setGroupByField("processKey");
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Process Key List Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray array = new JSONArray(result);
                JSONArray resultArray = new JSONArray();
                if (array.length() != 0) {
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject jsonObj = array.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String processKey = values.getJSONArray("processKey").getString(0);
                        JSONObject o = new JSONObject();
                        o.put("processKey", (Object)processKey);
                        resultArray.put((Object)o);
                    }
                    processKeyList = resultArray.toString();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Process Key List Result:" + processKeyList));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"BPMN Analytics Core - process key list error.", (Throwable)e);
        }
        return processKeyList;
    }
}

