/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.bpmn.analytics.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.ei.bpmn.analytics.core.clients.BPMNAnalyticsCoreRestClient;
import org.wso2.ei.bpmn.analytics.core.models.AggregateField;
import org.wso2.ei.bpmn.analytics.core.models.AggregateQuery;
import org.wso2.ei.bpmn.analytics.core.models.SearchQuery;
import org.wso2.ei.bpmn.analytics.core.utils.BPMNAnalyticsCoreUtils;

public class TaskLevelMonitor {
    private static final Log log = LogFactory.getLog(TaskLevelMonitor.class);

    public String getAvgExecuteTimeVsTaskId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                String processId = filterObj.getString("processId");
                String order = filterObj.getString("order");
                int taskCount = filterObj.getInt("count");
                AggregateField avgField = new AggregateField();
                avgField.setFieldName("duration");
                avgField.setAggregate("AVG");
                avgField.setAlias("avgExecutionTime");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(avgField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("USER_INVOLVE_SUMMARY_DATA");
                query.setGroupByField("taskDefId");
                query.setQuery("processDefinitionId:\"'" + processId + "'\"");
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Avg Execution Time Vs Task Id Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Double> table = new Hashtable<String, Double>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String taskDefKey = values.getJSONArray("taskDefId").getString(0);
                        double avgExecTime = values.getDouble("avgExecutionTime");
                        table.put(taskDefKey, avgExecTime);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getDoubleValueSortedList(table, "taskDefId", "avgExecutionTime", order, taskCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Avg Execution Time Vs TaskId TaskLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Avg Execution Time Vs Task Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getTaskInstanceCountVsTaskId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                String processId = filterObj.getString("processId");
                String order = filterObj.getString("order");
                int taskCount = filterObj.getInt("count");
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("taskInstanceCount");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("USER_INVOLVE_SUMMARY_DATA");
                query.setGroupByField("taskDefId");
                query.setQuery("processDefinitionId:\"'" + processId + "'\"");
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Task Instance Count Vs Task Id Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Integer> table = new Hashtable<String, Integer>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String processDefKey = values.getJSONArray("taskDefId").getString(0);
                        int processInstanceCount = values.getInt("taskInstanceCount");
                        table.put(processDefKey, processInstanceCount);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getIntegerValueSortedList(table, "taskDefId", "taskInstanceCount", order, taskCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Task Instance Count Vs TaskId TaskLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Task Instance Count Vs Task Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getTaskInstanceCountVsUserId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                String taskId = filterObj.getString("taskId");
                String processId = filterObj.getString("processId");
                String order = filterObj.getString("order");
                int taskCount = filterObj.getInt("count");
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("taskInstanceCount");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                String queryStr = "taskDefinitionKey:\"'" + taskId + "'\" AND processDefinitionId:\"'" + processId + "'\"";
                AggregateQuery query = new AggregateQuery();
                query.setTableName("TASK_USAGE_SUMMARY_DATA");
                query.setGroupByField("assignUser");
                query.setQuery(queryStr);
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Task Instance Count Vs User Id Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Integer> table = new Hashtable<String, Integer>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String userId = values.getJSONArray("assignUser").getString(0);
                        int taskInstanceCount = values.getInt("taskInstanceCount");
                        table.put(userId, taskInstanceCount);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getIntegerValueSortedList(table, "assignUser", "taskInstanceCount", order, taskCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Task Instance Count Vs UserId TaskLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Task Instance Count Vs User Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getAvgWaitingTimeVsUserId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                String taskId = filterObj.getString("taskId");
                String processId = filterObj.getString("processId");
                String order = filterObj.getString("order");
                int taskCount = filterObj.getInt("count");
                AggregateField avgField = new AggregateField();
                avgField.setFieldName("duration");
                avgField.setAggregate("AVG");
                avgField.setAlias("avgWaitingTime");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(avgField);
                String queryStr = "taskDefinitionKey:\"'" + taskId + "'\" AND processDefinitionId:\"'" + processId + "'\"";
                AggregateQuery query = new AggregateQuery();
                query.setTableName("TASK_USAGE_SUMMARY_DATA");
                query.setGroupByField("assignUser");
                query.setQuery(queryStr);
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Avg Waiting Time Vs User Id Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Double> table = new Hashtable<String, Double>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String userId = values.getJSONArray("assignUser").getString(0);
                        double avgExecTime = values.getInt("avgWaitingTime");
                        table.put(userId, avgExecTime);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getDoubleValueSortedList(table, "assignUser", "avgWaitingTime", order, taskCount);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Avg Waiting Time Vs UserId TaskLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Avg Waiting Time Vs User Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getExecutionTimeVsTaskInstanceId(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                long from = filterObj.getLong("startTime");
                long to = filterObj.getLong("endTime");
                String taskId = filterObj.getString("taskId");
                String processId = filterObj.getString("processId");
                String order = filterObj.getString("order");
                int limit = filterObj.getInt("limit");
                SearchQuery searchQuery = new SearchQuery();
                searchQuery.setTableName("TASK_USAGE_SUMMARY_DATA");
                String queryStr = "taskDefinitionKey:\"'" + taskId + "'\" AND processDefinitionId:\"'" + processId + "'\"";
                if (from != 0L && to != 0L) {
                    queryStr = queryStr + " AND " + BPMNAnalyticsCoreUtils.getDateRangeQuery("finishedTime", from, to);
                }
                searchQuery.setQuery(queryStr);
                searchQuery.setStart(0);
                searchQuery.setCount(100000);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get Execution Time Vs Task Instance Id Result:" + BPMNAnalyticsCoreUtils.getJSONString(searchQuery)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/search"), BPMNAnalyticsCoreUtils.getJSONString(searchQuery));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<String, Double> table = new Hashtable<String, Double>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String processDefKey = values.getString("taskInstanceId");
                        double executionTime = values.getDouble("duration");
                        table.put(processDefKey, executionTime);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getDoubleValueSortedList(table, "taskInstanceId", "duration", order, limit);
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Execution Time Vs Task InstanceId TaskLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Execution Time Vs Task Instance Id Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getDateVsTaskInstanceCount(String filters) {
        String sortedResult = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                long from = filterObj.getLong("startTime");
                long to = filterObj.getLong("endTime");
                String processId = filterObj.getString("processId");
                JSONArray taskIdList = filterObj.getJSONArray("taskIdList");
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("taskInstanceCount");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("TASK_USAGE_SUMMARY_DATA");
                query.setGroupByField("finishTime");
                String queryStr = BPMNAnalyticsCoreUtils.getDateRangeQuery("finishedTime", from, to);
                queryStr = queryStr + "AND processDefinitionId:\"'" + processId + "'\"";
                if (taskIdList.length() != 0) {
                    queryStr = queryStr + " AND ";
                    for (int i = 0; i < taskIdList.length(); ++i) {
                        queryStr = i == 0 ? queryStr + "(taskDefinitionKey:\"'" + taskIdList.getString(i) + "'\"" : queryStr + " OR taskDefinitionKey:\"'" + taskIdList.getString(i) + "'\"";
                        if (i != taskIdList.length() - 1) continue;
                        queryStr = queryStr + ")";
                    }
                }
                query.setQuery(queryStr);
                query.setAggregateFields(aggregateFields);
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray unsortedResultArray = new JSONArray(result);
                Hashtable<Long, Integer> table = new Hashtable<Long, Integer>();
                if (unsortedResultArray.length() != 0) {
                    for (int i = 0; i < unsortedResultArray.length(); ++i) {
                        JSONObject jsonObj = unsortedResultArray.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        long completedTime = Long.parseLong(values.getJSONArray("finishTime").getString(0));
                        int taskInstanceCount = values.getInt("taskInstanceCount");
                        table.put(completedTime, taskInstanceCount);
                    }
                    sortedResult = BPMNAnalyticsCoreUtils.getLongKeySortedList(table, "finishTime", "taskInstanceCount");
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - Date Vs Task Instance Count TaskLevelMonitoring error.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Date Vs Task Instance Count Result:" + sortedResult));
        }
        return sortedResult;
    }

    public String getTaskList() {
        String taskIdList = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("taskInstanceCount");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                AggregateQuery query = new AggregateQuery();
                query.setTableName("USER_INVOLVE_SUMMARY_DATA");
                query.setGroupByField("taskDefId");
                query.setAggregateFields(aggregateFields);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get the Task List Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray array = new JSONArray(result);
                JSONArray resultArray = new JSONArray();
                if (array.length() != 0) {
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject jsonObj = array.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String taskDefKey = values.getJSONArray("taskDefId").getString(0);
                        JSONObject o = new JSONObject();
                        o.put("taskDefId", (Object)taskDefKey);
                        resultArray.put((Object)o);
                    }
                    taskIdList = resultArray.toString();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task List Result:" + taskIdList));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"BPMN Analytics Core - task id list error.", (Throwable)e);
        }
        return taskIdList;
    }

    public String getProcessRelatedTaskList(String filters) {
        String taskIdList = "";
        try {
            if (BPMNAnalyticsCoreUtils.isDASAnalyticsActivated()) {
                JSONObject filterObj = new JSONObject(filters);
                String processId = filterObj.getString("processId");
                AggregateField countField = new AggregateField();
                countField.setFieldName("*");
                countField.setAggregate("COUNT");
                countField.setAlias("taskInstanceCount");
                ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
                aggregateFields.add(countField);
                String queryStr = "processDefinitionId:\"'" + processId + "'\"";
                AggregateQuery query = new AggregateQuery();
                query.setTableName("USER_INVOLVE_SUMMARY_DATA");
                query.setGroupByField("taskDefId");
                query.setAggregateFields(aggregateFields);
                query.setQuery(queryStr);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Query to get the Task List Result:" + BPMNAnalyticsCoreUtils.getJSONString(query)));
                }
                String result = BPMNAnalyticsCoreRestClient.post(BPMNAnalyticsCoreUtils.getURL("analytics/aggregates"), BPMNAnalyticsCoreUtils.getJSONString(query));
                JSONArray array = new JSONArray(result);
                JSONArray resultArray = new JSONArray();
                if (array.length() != 0) {
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject jsonObj = array.getJSONObject(i);
                        JSONObject values = jsonObj.getJSONObject("values");
                        String taskDefKey = values.getJSONArray("taskDefId").getString(0);
                        JSONObject o = new JSONObject();
                        o.put("taskDefId", (Object)taskDefKey);
                        resultArray.put((Object)o);
                    }
                    taskIdList = resultArray.toString();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task List Result:" + taskIdList));
                }
            }
        }
        catch (IOException | XMLStreamException | JSONException e) {
            log.error((Object)"BPMN Analytics Core - task id list error.", e);
        }
        return taskIdList;
    }
}

