/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.bpmn.analytics.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.wso2.ei.bpmn.common.analytics.config.BPSAnalyticsDocument;
import org.wso2.ei.bpmn.common.analytics.config.TAnalyticServer;
import org.wso2.ei.bpmn.common.analytics.config.TBPMN;
import org.wso2.ei.bpmn.common.analytics.config.TBPSAnalytics;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class BPMNAnalyticsCoreConfiguration {
    private static final Log log = LogFactory.getLog(BPMNAnalyticsCoreConfiguration.class);
    private BPSAnalyticsDocument bpsAnalyticsDocument;
    private String analyticsServerURL;
    private String analyticsServerUsername;
    private String analyticsServerPassword;
    private boolean analyticsDashboardEnabled;

    public BPMNAnalyticsCoreConfiguration(File BPSAnalyticsConfig) {
        this.bpsAnalyticsDocument = this.readConfigurationFromFile(BPSAnalyticsConfig);
        if (this.bpsAnalyticsDocument == null) {
            return;
        }
        this.initConfigurationFromFile(BPSAnalyticsConfig);
    }

    public static Log getLog() {
        return log;
    }

    private BPSAnalyticsDocument readConfigurationFromFile(File BPSAnalyticsConfigurationFile) {
        try {
            return BPSAnalyticsDocument.Factory.parse(new FileInputStream(BPSAnalyticsConfigurationFile));
        }
        catch (XmlException e) {
            log.error((Object)"Error parsing BPS analytics configuration.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.info((Object)("Cannot find the BPS analytics configuration in specified location " + BPSAnalyticsConfigurationFile.getPath() + " . Loads the default configuration."));
        }
        catch (IOException e) {
            log.error((Object)("Error reading BPS analytics configuration file" + BPSAnalyticsConfigurationFile.getPath()));
        }
        return null;
    }

    private void initConfigurationFromFile(File BPMNAnalyticsCoreConfigurationFile) {
        SecretResolver secretResolver = null;
        try (FileInputStream in = new FileInputStream(BPMNAnalyticsCoreConfigurationFile);){
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)in);
            secretResolver = SecretResolverFactory.create((OMElement)builder.getDocumentElement(), (boolean)true);
        }
        catch (Exception e) {
            log.warn((Object)"Error occurred while retrieving secured BPS Analytics configuration.", (Throwable)e);
        }
        TBPSAnalytics tBPSAnalytics = this.bpsAnalyticsDocument.getBPSAnalytics();
        if (tBPSAnalytics == null) {
            return;
        }
        if (tBPSAnalytics.getBPMN() != null) {
            this.initBPMNAnalytics(tBPSAnalytics.getBPMN());
        }
        if (tBPSAnalytics.getAnalyticServer() != null) {
            this.initAnalytics(secretResolver, tBPSAnalytics.getAnalyticServer());
        }
    }

    private void initAnalytics(SecretResolver secretResolver, TAnalyticServer tAnalyticServer) {
        if (this.isAnalyticsDashboardEnabled()) {
            this.analyticsServerURL = tAnalyticServer.getDASServerUrl().endsWith("/") ? tAnalyticServer.getDASServerUrl().substring(0, tAnalyticServer.getDASServerUrl().length() - 1) : tAnalyticServer.getDASServerUrl();
            this.analyticsServerUsername = tAnalyticServer.getUsername();
            if (secretResolver != null && secretResolver.isInitialized() && secretResolver.isTokenProtected("PC.Analytics.Password")) {
                this.analyticsServerPassword = secretResolver.resolve("PC.Analytics.Password");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Loaded  analytics  password from secure vault");
                }
            } else if (tAnalyticServer.getPassword() != null) {
                this.analyticsServerPassword = tAnalyticServer.getPassword();
            }
        }
    }

    private void initBPMNAnalytics(TBPMN tbpmn) {
        this.analyticsDashboardEnabled = tbpmn.getDashboardAnalyticsEnabled();
    }

    public String getAnalyticsServerURL() {
        return this.analyticsServerURL;
    }

    public String getAnalyticsServerUsername() {
        return this.analyticsServerUsername;
    }

    public String getAnalyticsServerPassword() {
        return this.analyticsServerPassword;
    }

    public boolean isAnalyticsDashboardEnabled() {
        return this.analyticsDashboardEnabled;
    }
}

