/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.bpmn.analytics.core.utils;

import com.google.gson.Gson;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.ei.bpmn.analytics.core.internal.BPMNAnalyticsCoreServerHolder;

public class BPMNAnalyticsCoreUtils {
    private static final Log log = LogFactory.getLog(BPMNAnalyticsCoreUtils.class);

    private BPMNAnalyticsCoreUtils() {
    }

    public static String getDateRangeQuery(String columnName, long from, long to) {
        return columnName + " : [" + from + " TO " + to + "]";
    }

    public static String getJSONString(Object query) {
        return new Gson().toJson(query);
    }

    private static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static boolean isDASAnalyticsActivated() {
        return BPMNAnalyticsCoreServerHolder.getInstance().getBPMNAnalyticsCoreServer().getBPSAnalyticsConfiguration().isAnalyticsDashboardEnabled();
    }

    public static String getURL(String path) {
        return BPMNAnalyticsCoreServerHolder.getInstance().getBPMNAnalyticsCoreServer().getBPSAnalyticsConfiguration().getAnalyticsServerURL() + "/" + path;
    }

    public static String getAuthorizationHeader() {
        String userName = BPMNAnalyticsCoreServerHolder.getInstance().getBPMNAnalyticsCoreServer().getBPSAnalyticsConfiguration().getAnalyticsServerUsername();
        String password = BPMNAnalyticsCoreServerHolder.getInstance().getBPMNAnalyticsCoreServer().getBPSAnalyticsConfiguration().getAnalyticsServerPassword();
        if (userName != null && password != null) {
            return "Basic " + DatatypeConverter.printBase64Binary((byte[])(userName + ":" + password).getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    public static String getDoubleValueSortedList(Hashtable<String, Double> table, String key1, String key2, String order, int count) throws JSONException {
        JSONArray arrayPortion;
        block5: {
            JSONArray array;
            block4: {
                ArrayList<Map.Entry<String, Double>> l = new ArrayList<Map.Entry<String, Double>>(table.entrySet());
                Collections.sort(l, new Comparator<Map.Entry<String, Double>>(){

                    @Override
                    public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                        return o1.getValue().compareTo(o2.getValue());
                    }
                });
                Collections.reverse(l);
                array = new JSONArray();
                for (int i = 0; i < l.size(); ++i) {
                    JSONObject o = new JSONObject();
                    o.put(key1, (Object)l.get(i).getKey());
                    o.put(key2, BPMNAnalyticsCoreUtils.round(l.get(i).getValue(), 2));
                    array.put((Object)o);
                }
                if (count > array.length()) {
                    count = array.length();
                }
                arrayPortion = new JSONArray();
                if (!order.equalsIgnoreCase("top")) break block4;
                for (int i = array.length() - count; i < array.length(); ++i) {
                    arrayPortion.put(array.get(i));
                }
                break block5;
            }
            if (!order.equalsIgnoreCase("bottom")) break block5;
            for (int i = 0; i < count; ++i) {
                arrayPortion.put(array.get(i));
            }
        }
        return arrayPortion.toString();
    }

    public static String getIntegerValueSortedList(Hashtable<String, Integer> table, String key1, String key2, String order, int count) throws JSONException {
        JSONArray arrayPortion;
        block5: {
            JSONArray array;
            block4: {
                ArrayList<Map.Entry<String, Integer>> l = new ArrayList<Map.Entry<String, Integer>>(table.entrySet());
                Collections.sort(l, new Comparator<Map.Entry<String, Integer>>(){

                    @Override
                    public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                        return o1.getValue().compareTo(o2.getValue());
                    }
                });
                Collections.reverse(l);
                array = new JSONArray();
                for (int i = 0; i < l.size(); ++i) {
                    JSONObject o = new JSONObject();
                    o.put(key1, (Object)l.get(i).getKey());
                    o.put(key2, (Object)l.get(i).getValue());
                    array.put((Object)o);
                }
                if (count > array.length()) {
                    count = array.length();
                }
                arrayPortion = new JSONArray();
                if (!order.equalsIgnoreCase("top")) break block4;
                for (int i = array.length() - count; i < array.length(); ++i) {
                    arrayPortion.put(array.get(i));
                }
                break block5;
            }
            if (!order.equalsIgnoreCase("bottom")) break block5;
            for (int i = 0; i < count; ++i) {
                arrayPortion.put(array.get(i));
            }
        }
        return arrayPortion.toString();
    }

    public static String getLongKeySortedList(Hashtable<Long, Integer> table, String key1, String key2) throws JSONException {
        ArrayList<Map.Entry<Long, Integer>> l = new ArrayList<Map.Entry<Long, Integer>>(table.entrySet());
        Collections.sort(l, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry<Long, Integer> o1, Map.Entry<Long, Integer> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        Collections.reverse(l);
        JSONArray array = new JSONArray();
        for (int i = 0; i < l.size(); ++i) {
            JSONObject o = new JSONObject();
            o.put(key1, (Object)l.get(i).getKey());
            o.put(key2, (Object)l.get(i).getValue());
            array.put((Object)o);
        }
        return array.toString();
    }

    private static String dateFormatter(long time) {
        String date = new Date(time).toString();
        String[] dateArray = date.split(" ");
        try {
            Date dateMonth = new SimpleDateFormat("MMM", Locale.ENGLISH).parse(dateArray[1]);
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateMonth);
            int month = cal.get(2) + 1;
            String dateString = dateArray[5] + "-" + month + "-" + dateArray[2];
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            return df.format(df.parse(dateString));
        }
        catch (ParseException e) {
            String errMsg = "Date format parse exception.";
            log.error((Object)errMsg, (Throwable)e);
            return null;
        }
    }
}

