/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.smb.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.wso2.ei.b7a.smb.client.SMBClientHelper;
import org.wso2.ei.b7a.smb.client.SMBClientListener;
import org.wso2.ei.b7a.smb.util.BallerinaSMBException;
import org.wso2.ei.b7a.smb.util.SMBUtil;
import org.wso2.transport.remotefilesystem.client.connector.contract.FtpAction;
import org.wso2.transport.remotefilesystem.client.connector.contract.VFSClientConnector;
import org.wso2.transport.remotefilesystem.exception.RemoteFileSystemConnectorException;
import org.wso2.transport.remotefilesystem.impl.RemoteFileSystemConnectorFactoryImpl;
import org.wso2.transport.remotefilesystem.listener.RemoteFileSystemListener;
import org.wso2.transport.remotefilesystem.message.RemoteFileSystemMessage;

public class SMBClient {
    private SMBClient() {
    }

    public static void initClientEndpoint(ObjectValue clientEndpoint, MapValue<Object, Object> config) throws BallerinaSMBException {
        String protocol = config.getStringValue("protocol");
        if (SMBUtil.notValidProtocol(protocol)) {
            throw new BallerinaSMBException("Only SMB protocol is supported by SMB client.");
        }
        Map<String, String> authMap = SMBUtil.getAuthMap(config);
        clientEndpoint.addNativeData("username", (Object)authMap.get("username"));
        clientEndpoint.addNativeData("password", (Object)authMap.get("password"));
        clientEndpoint.addNativeData("host", (Object)config.getStringValue("host"));
        clientEndpoint.addNativeData("port", (Object)SMBUtil.extractPortValue(config.getIntValue("port")));
        clientEndpoint.addNativeData("protocol", (Object)protocol);
        HashMap<String, String> smbConfig = new HashMap<String, String>(3);
        smbConfig.put("PASSIVE_MODE", String.valueOf(true));
        smbConfig.put("USER_DIR_IS_ROOT", String.valueOf(false));
        smbConfig.put("AVOID_PERMISSION_CHECK", String.valueOf(true));
        clientEndpoint.addNativeData("map", smbConfig);
    }

    public static ObjectValue get(ObjectValue clientConnector, String filePath) throws BallerinaSMBException {
        VFSClientConnector connector;
        String url = SMBUtil.createUrl(clientConnector, filePath);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        CompletableFuture future = BRuntime.markAsync();
        SMBClientListener connectorListener = new SMBClientListener(future, remoteFileSystemBaseMessage -> SMBClientHelper.executeGetAction(remoteFileSystemBaseMessage, future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaSMBException(e.getMessage());
        }
        connector.send(null, FtpAction.GET);
        return null;
    }

    public static void append(ObjectValue clientConnector, MapValue<Object, Object> inputContent) throws BallerinaSMBException {
        try {
            RemoteFileSystemMessage message;
            String url = SMBUtil.createUrl(clientConnector, inputContent.getStringValue("filePath"));
            HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
            propertyMap.put("uri", url);
            boolean isFile = inputContent.getBooleanValue("isFile");
            if (isFile) {
                ObjectValue fileContent = inputContent.getObjectValue("fileContent");
                Channel byteChannel = (Channel)fileContent.getNativeData("byteChannel");
                message = new RemoteFileSystemMessage(byteChannel.getInputStream());
            } else {
                String textContent = inputContent.getStringValue("textContent");
                ByteArrayInputStream stream = new ByteArrayInputStream(textContent.getBytes());
                message = new RemoteFileSystemMessage((InputStream)stream);
            }
            CompletableFuture future = BRuntime.markAsync();
            SMBClientListener connectorListener = new SMBClientListener(future, remoteFileSystemBaseMessage -> SMBClientHelper.executeGenericAction(future));
            RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
            VFSClientConnector connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
            connector.send(message, FtpAction.APPEND);
            future.complete(null);
        }
        catch (IOException | RemoteFileSystemConnectorException e) {
            throw new BallerinaSMBException(e.getMessage());
        }
    }

    public static void put(ObjectValue clientConnector, MapValue<Object, Object> inputContent) throws BallerinaSMBException {
        try {
            RemoteFileSystemMessage message;
            String url = SMBUtil.createUrl(clientConnector, inputContent.getStringValue("filePath"));
            HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
            propertyMap.put("uri", url);
            boolean isFile = inputContent.getBooleanValue("isFile");
            if (isFile) {
                ObjectValue fileContent = inputContent.getObjectValue("fileContent");
                Channel byteChannel = (Channel)fileContent.getNativeData("byteChannel");
                message = new RemoteFileSystemMessage(byteChannel.getInputStream());
            } else {
                String textContent = inputContent.getStringValue("textContent");
                ByteArrayInputStream stream = new ByteArrayInputStream(textContent.getBytes());
                message = new RemoteFileSystemMessage((InputStream)stream);
            }
            CompletableFuture future = BRuntime.markAsync();
            SMBClientListener connectorListener = new SMBClientListener(future, remoteFileSystemBaseMessage -> SMBClientHelper.executeGenericAction(future));
            RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
            VFSClientConnector connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
            connector.send(message, FtpAction.PUT);
            future.complete(null);
        }
        catch (IOException | RemoteFileSystemConnectorException e) {
            throw new BallerinaSMBException(e.getMessage());
        }
    }

    public static void delete(ObjectValue clientConnector, String filePath) throws BallerinaSMBException {
        VFSClientConnector connector;
        String url = SMBUtil.createUrl(clientConnector, filePath);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        CompletableFuture future = BRuntime.markAsync();
        SMBClientListener connectorListener = new SMBClientListener(future, remoteFileSystemBaseMessage -> SMBClientHelper.executeGenericAction(future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaSMBException(e.getMessage());
        }
        connector.send(null, FtpAction.DELETE);
        future.complete(null);
    }

    public static boolean isDirectory(ObjectValue clientConnector, String filePath) throws BallerinaSMBException {
        VFSClientConnector connector;
        String url = SMBUtil.createUrl(clientConnector, filePath);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        CompletableFuture future = BRuntime.markAsync();
        SMBClientListener connectorListener = new SMBClientListener(future, remoteFileSystemBaseMessage -> SMBClientHelper.executeIsDirectoryAction(remoteFileSystemBaseMessage, future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaSMBException(e.getMessage());
        }
        connector.send(null, FtpAction.ISDIR);
        return false;
    }

    public static ArrayValue list(ObjectValue clientConnector, String filePath) throws BallerinaSMBException {
        VFSClientConnector connector;
        String url = SMBUtil.createUrl(clientConnector, filePath);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        CompletableFuture future = BRuntime.markAsync();
        SMBClientListener connectorListener = new SMBClientListener(future, remoteFileSystemBaseMessage -> SMBClientHelper.executeListAction(remoteFileSystemBaseMessage, future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaSMBException(e.getMessage());
        }
        connector.send(null, FtpAction.LIST);
        return null;
    }

    public static void mkdir(ObjectValue clientConnector, String path) throws BallerinaSMBException {
        VFSClientConnector connector;
        String url = SMBUtil.createUrl(clientConnector, path);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        CompletableFuture future = BRuntime.markAsync();
        SMBClientListener connectorListener = new SMBClientListener(future, remoteFileSystemBaseMessage -> SMBClientHelper.executeGenericAction(future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaSMBException(e.getMessage());
        }
        connector.send(null, FtpAction.MKDIR);
        future.complete(null);
    }

    public static void rename(ObjectValue clientConnector, String origin, String destination) throws BallerinaSMBException {
        VFSClientConnector connector;
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", SMBUtil.createUrl(clientConnector, origin));
        propertyMap.put("destination", SMBUtil.createUrl(clientConnector, destination));
        CompletableFuture future = BRuntime.markAsync();
        SMBClientListener connectorListener = new SMBClientListener(future, remoteFileSystemBaseMessage -> SMBClientHelper.executeGenericAction(future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaSMBException(e.getMessage());
        }
        connector.send(null, FtpAction.RENAME);
        future.complete(null);
    }

    public static void rmdir(ObjectValue clientConnector, String filePath) throws BallerinaSMBException {
        VFSClientConnector connector;
        String url = SMBUtil.createUrl(clientConnector, filePath);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        CompletableFuture future = BRuntime.markAsync();
        SMBClientListener connectorListener = new SMBClientListener(future, remoteFileSystemBaseMessage -> SMBClientHelper.executeGenericAction(future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaSMBException(e.getMessage());
        }
        connector.send(null, FtpAction.RMDIR);
        future.complete(null);
    }

    public static int size(ObjectValue clientConnector, String filePath) throws BallerinaSMBException {
        VFSClientConnector connector;
        String url = SMBUtil.createUrl(clientConnector, filePath);
        HashMap<String, String> propertyMap = new HashMap<String, String>((Map)clientConnector.getNativeData("map"));
        propertyMap.put("uri", url);
        propertyMap.put("PASSIVE_MODE", Boolean.TRUE.toString());
        CompletableFuture future = BRuntime.markAsync();
        SMBClientListener connectorListener = new SMBClientListener(future, remoteFileSystemBaseMessage -> SMBClientHelper.executeSizeAction(remoteFileSystemBaseMessage, future));
        RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
        try {
            connector = fileSystemConnectorFactory.createVFSClientConnector(propertyMap, (RemoteFileSystemListener)connectorListener);
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaSMBException(e.getMessage());
        }
        connector.send(null, FtpAction.SIZE);
        return 0;
    }
}

