/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.smb.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.vfs2.FileSystemException;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ei.b7a.smb.util.SMBUtil;
import org.wso2.transport.remotefilesystem.message.FileInfo;
import org.wso2.transport.remotefilesystem.message.RemoteFileSystemBaseMessage;
import org.wso2.transport.remotefilesystem.message.RemoteFileSystemMessage;

class SMBClientHelper {
    private static final String READABLE_BYTE_CHANNEL = "ReadableByteChannel";
    private static final String PACKAGE_BALLERINA = "ballerina";
    private static final String PACKAGE_IO = "io";
    private static final Logger log = LoggerFactory.getLogger(SMBClientHelper.class);

    private SMBClientHelper() {
    }

    static boolean executeGenericAction(CompletableFuture<Object> future) {
        future.complete(null);
        return true;
    }

    static boolean executeGetAction(RemoteFileSystemBaseMessage remoteFileSystemBaseMessage, CompletableFuture<Object> future) {
        if (remoteFileSystemBaseMessage instanceof RemoteFileSystemMessage) {
            InputStream in = ((RemoteFileSystemMessage)remoteFileSystemBaseMessage).getInputStream();
            SMBByteChannel byteChannel = new SMBByteChannel(in);
            SMBChannel channel = new SMBChannel(byteChannel);
            ObjectValue channelStruct = BallerinaValues.createObjectValue((BPackage)new BPackage(PACKAGE_BALLERINA, PACKAGE_IO), (String)READABLE_BYTE_CHANNEL, (Object[])new Object[0]);
            channelStruct.addNativeData("byteChannel", (Object)channel);
            future.complete(channelStruct);
        }
        return true;
    }

    static boolean executeIsDirectoryAction(RemoteFileSystemBaseMessage remoteFileSystemBaseMessage, CompletableFuture<Object> future) {
        if (remoteFileSystemBaseMessage instanceof RemoteFileSystemMessage) {
            future.complete(((RemoteFileSystemMessage)remoteFileSystemBaseMessage).isDirectory());
        }
        return true;
    }

    static boolean executeListAction(RemoteFileSystemBaseMessage remoteFileSystemBaseMessage, CompletableFuture<Object> future) {
        if (remoteFileSystemBaseMessage instanceof RemoteFileSystemMessage) {
            RemoteFileSystemMessage message = (RemoteFileSystemMessage)remoteFileSystemBaseMessage;
            Map childrenInfo = message.getChildrenInfo();
            ArrayValue arrayValue = new ArrayValue((BType)new BArrayType(SMBUtil.getFileInfoType()));
            int i = 0;
            for (Map.Entry entry : childrenInfo.entrySet()) {
                HashMap<String, Object> fileInfoParams = new HashMap<String, Object>();
                FileInfo fileInfo = (FileInfo)entry.getValue();
                fileInfoParams.put("path", fileInfo.getPath());
                fileInfoParams.put("size", fileInfo.getFileSize());
                fileInfoParams.put("lastModifiedTimestamp", fileInfo.getLastModifiedTime());
                fileInfoParams.put("name", fileInfo.getBaseName());
                fileInfoParams.put("isFolder", fileInfo.isFolder());
                fileInfoParams.put("isFile", fileInfo.isFile());
                fileInfoParams.put("extension", fileInfo.getFileName().getExtension());
                fileInfoParams.put("publicURIString", fileInfo.getPublicURIString());
                fileInfoParams.put("fileType", fileInfo.getFileType().getName());
                fileInfoParams.put("isAttached", fileInfo.isAttached());
                fileInfoParams.put("isContentOpen", fileInfo.isContentOpen());
                fileInfoParams.put("isExecutable", fileInfo.isExecutable());
                fileInfoParams.put("isHidden", fileInfo.isHidden());
                fileInfoParams.put("isReadable", fileInfo.isReadable());
                fileInfoParams.put("isWritable", fileInfo.isWritable());
                fileInfoParams.put("depth", fileInfo.getFileName().getDepth());
                fileInfoParams.put("scheme", fileInfo.getFileName().getScheme());
                fileInfoParams.put("uri", fileInfo.getFileName().getURI());
                fileInfoParams.put("rootURI", fileInfo.getFileName().getRootURI());
                fileInfoParams.put("friendlyURI", fileInfo.getFileName().getFriendlyURI());
                try {
                    fileInfoParams.put("pathDecoded", fileInfo.getFileName().getPathDecoded());
                }
                catch (FileSystemException e) {
                    log.error("Error while evaluating the pathDecoded value.", (Throwable)e);
                }
                MapValue ballerinaFileInfo = BallerinaValues.createRecordValue((BPackage)new BPackage("wso2", "smb", "0.3.0"), (String)"FileInfo", fileInfoParams);
                arrayValue.add((long)i++, (Object)ballerinaFileInfo);
            }
            future.complete(arrayValue);
        }
        return true;
    }

    static boolean executeSizeAction(RemoteFileSystemBaseMessage remoteFileSystemBaseMessage, CompletableFuture<Object> future) {
        if (remoteFileSystemBaseMessage instanceof RemoteFileSystemMessage) {
            RemoteFileSystemMessage message = (RemoteFileSystemMessage)remoteFileSystemBaseMessage;
            future.complete((int)message.getSize());
        }
        return true;
    }

    private static class SMBByteChannel
    implements ByteChannel {
        private InputStream inputStream;
        private ReadableByteChannel inputChannel;

        SMBByteChannel(InputStream inputStream) {
            this.inputStream = inputStream;
            this.inputChannel = Channels.newChannel(inputStream);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.inputChannel.read(dst);
        }

        @Override
        public int write(ByteBuffer src) {
            return 0;
        }

        @Override
        public boolean isOpen() {
            return this.inputChannel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.inputChannel.close();
            this.inputStream.close();
        }
    }

    private static class SMBChannel
    extends Channel {
        SMBChannel(ByteChannel channel) {
            super(channel);
        }

        public void transfer(int i, int i1, WritableByteChannel writableByteChannel) {
            throw new UnsupportedOperationException();
        }

        public Channel getChannel() {
            return this;
        }

        public boolean remaining() {
            return false;
        }
    }
}

