/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.smb.client;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ei.b7a.smb.util.SMBUtil;
import org.wso2.transport.remotefilesystem.listener.RemoteFileSystemListener;
import org.wso2.transport.remotefilesystem.message.RemoteFileSystemBaseMessage;

class SMBClientListener
implements RemoteFileSystemListener {
    private static final Logger log = LoggerFactory.getLogger(SMBClientListener.class);
    private CompletableFuture<Object> future;
    private Function<RemoteFileSystemBaseMessage, Boolean> function;

    SMBClientListener(CompletableFuture<Object> future, Function<RemoteFileSystemBaseMessage, Boolean> function) {
        this.future = future;
        this.function = function;
    }

    public boolean onMessage(RemoteFileSystemBaseMessage remoteFileSystemBaseMessage) {
        return this.function.apply(remoteFileSystemBaseMessage);
    }

    public void onError(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        String detail = null;
        if (throwable.getCause() != null) {
            detail = throwable.getCause().getMessage();
        }
        this.future.complete(SMBUtil.createError(throwable.getMessage(), detail));
    }

    public void done() {
        log.debug("Successfully finished the action.");
    }
}

