/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.smb.server;

import java.util.HashMap;
import java.util.List;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ei.b7a.smb.util.SMBUtil;
import org.wso2.transport.remotefilesystem.listener.RemoteFileSystemListener;
import org.wso2.transport.remotefilesystem.message.FileInfo;
import org.wso2.transport.remotefilesystem.message.RemoteFileSystemBaseMessage;
import org.wso2.transport.remotefilesystem.message.RemoteFileSystemEvent;

public class SMBListener
implements RemoteFileSystemListener {
    private static final Logger log = LoggerFactory.getLogger(SMBListener.class);
    private final BRuntime runtime;
    private final ObjectValue service;

    SMBListener(BRuntime runtime, ObjectValue service) {
        this.runtime = runtime;
        this.service = service;
    }

    public boolean onMessage(RemoteFileSystemBaseMessage remoteFileSystemBaseMessage) {
        if (remoteFileSystemBaseMessage instanceof RemoteFileSystemEvent) {
            RemoteFileSystemEvent event = (RemoteFileSystemEvent)remoteFileSystemBaseMessage;
            MapValue<String, Object> parameters = this.getSignatureParameters(event);
            this.runtime.invokeMethodSync(this.service, this.service.getType().getAttachedFunctions()[0].getName(), new Object[]{parameters, true});
        }
        return true;
    }

    private MapValue<String, Object> getSignatureParameters(RemoteFileSystemEvent fileSystemEvent) {
        MapValue watchEventStruct = BallerinaValues.createRecordValue((BPackage)new BPackage("wso2", "smb", "0.3.0"), (String)"WatchEvent");
        List addedFileList = fileSystemEvent.getAddedFiles();
        List deletedFileList = fileSystemEvent.getDeletedFiles();
        ArrayValue addedFiles = new ArrayValue((BType)new BArrayType(SMBUtil.getFileInfoType()));
        for (int i = 0; i < addedFileList.size(); ++i) {
            FileInfo info = (FileInfo)addedFileList.get(i);
            HashMap<String, Object> fileInfoParams = new HashMap<String, Object>();
            fileInfoParams.put("path", info.getPath());
            fileInfoParams.put("size", info.getFileSize());
            fileInfoParams.put("lastModifiedTimestamp", info.getLastModifiedTime());
            MapValue fileInfo = BallerinaValues.createRecordValue((BPackage)new BPackage("wso2", "smb", "0.3.0"), (String)"FileInfo", fileInfoParams);
            addedFiles.add((long)i, (Object)fileInfo);
        }
        ArrayValue deletedFiles = new ArrayValue(BTypes.typeString);
        for (int i = 0; i < deletedFileList.size(); ++i) {
            String fileName = (String)deletedFileList.get(i);
            deletedFiles.add((long)i, fileName);
        }
        return BallerinaValues.createRecord((MapValue)watchEventStruct, (Object[])new Object[]{addedFiles, deletedFiles});
    }

    public void onError(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
    }

    public void done() {
        log.debug("Successfully finished the action.");
    }
}

