/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.smb.server;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.wso2.ei.b7a.smb.server.SMBListener;
import org.wso2.ei.b7a.smb.util.BallerinaSMBException;
import org.wso2.ei.b7a.smb.util.SMBUtil;
import org.wso2.transport.remotefilesystem.exception.RemoteFileSystemConnectorException;
import org.wso2.transport.remotefilesystem.impl.RemoteFileSystemConnectorFactoryImpl;
import org.wso2.transport.remotefilesystem.listener.RemoteFileSystemListener;
import org.wso2.transport.remotefilesystem.server.connector.contract.RemoteFileSystemServerConnector;

public class SMBListenerHelper {
    private SMBListenerHelper() {
    }

    public static RemoteFileSystemServerConnector register(ObjectValue smbListener, MapValue<Object, Object> serviceEndpointConfig, ObjectValue service, String name) throws BallerinaSMBException {
        try {
            Map<String, String> paramMap = SMBListenerHelper.getServerConnectorParamMap(serviceEndpointConfig);
            RemoteFileSystemConnectorFactoryImpl fileSystemConnectorFactory = new RemoteFileSystemConnectorFactoryImpl();
            SMBListener listener = new SMBListener(BRuntime.getCurrentRuntime(), service);
            if (name == null || name.isEmpty()) {
                name = service.getType().getName();
            }
            RemoteFileSystemServerConnector serverConnector = fileSystemConnectorFactory.createServerConnector(name, paramMap, (RemoteFileSystemListener)listener);
            smbListener.addNativeData("serverConnector", (Object)serverConnector);
            serviceEndpointConfig.addNativeData("serverConnector", (Object)serverConnector);
            return serverConnector;
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaSMBException("Unable to initialize the SMB listener: " + e.getMessage(), e);
        }
    }

    private static Map<String, String> getServerConnectorParamMap(MapValue serviceEndpointConfig) throws BallerinaSMBException {
        String privateKeyPath;
        MapValue privateKey;
        HashMap<String, String> params = new HashMap<String, String>(12);
        MapValue secureSocket = serviceEndpointConfig.getMapValue("secureSocket");
        String url = SMBUtil.createUrl(serviceEndpointConfig);
        params.put("uri", url);
        SMBListenerHelper.addStringProperty(serviceEndpointConfig, params);
        if (secureSocket != null && (privateKey = secureSocket.getMapValue("privateKey")) != null && (privateKeyPath = privateKey.getStringValue("path")) != null && !privateKeyPath.isEmpty()) {
            params.put("IDENTITY", privateKeyPath);
            String privateKeyPassword = privateKey.getStringValue("password");
            if (privateKeyPassword != null && !privateKeyPassword.isEmpty()) {
                params.put("IDENTITY_PASS_PHRASE", privateKeyPassword);
            }
        }
        params.put("USER_DIR_IS_ROOT", String.valueOf(false));
        params.put("AVOID_PERMISSION_CHECK", String.valueOf(true));
        params.put("PASSIVE_MODE", String.valueOf(true));
        return params;
    }

    private static void addStringProperty(MapValue config, Map<String, String> params) {
        String value = config.getStringValue("fileNamePattern");
        if (value != null && !value.isEmpty()) {
            params.put("fileNamePattern", value);
        }
    }

    public static void poll(MapValue<Object, Object> config) throws BallerinaSMBException {
        RemoteFileSystemServerConnector connector = (RemoteFileSystemServerConnector)config.getNativeData("serverConnector");
        try {
            connector.poll();
        }
        catch (RemoteFileSystemConnectorException e) {
            throw new BallerinaSMBException(e.getMessage());
        }
    }
}

