/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.kafka;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.avro.generic.GenericData;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.inbound.endpoint.protocol.generic.GenericPollingConsumer;

public class KafkaMessageConsumer
extends GenericPollingConsumer {
    private static final Log log = LogFactory.getLog(KafkaMessageConsumer.class);
    private KafkaConsumer<byte[], byte[]> consumer;
    private String bootstrapServersName;
    private String keyDeserializer;
    private String valueDeserializer;
    private String groupId;
    private String pollTimeout;
    private String topic;
    private String contentType;
    private Properties kafkaProperties;
    private boolean isRegexPattern = false;
    private boolean isDisableAutoCommit;
    private int failureRetryCount;
    private int retryCounter = 0;
    private long failureRetryInterval = -1L;
    private String kafkaHeaderPrefix = "";

    public KafkaMessageConsumer(Properties properties, String name, SynapseEnvironment synapseEnvironment, long scanInterval, String injectingSeq, String onErrorSeq, boolean coordination, boolean sequential) {
        super(properties, name, synapseEnvironment, scanInterval, injectingSeq, onErrorSeq, coordination, sequential);
        this.validateMandatoryParameters(properties);
        this.createKafkaProperties(properties);
        this.populateOtherProperties(properties);
    }

    private void consumeKafkaRecords() {
        try {
            ConsumerRecords records = this.consumer.poll(Duration.of(Long.parseLong(this.pollTimeout), ChronoUnit.MILLIS));
            this.commitRecords((ConsumerRecords<byte[], byte[]>)records);
        }
        catch (WakeupException ex) {
            log.error((Object)("Error while wakeup the consumer " + this.consumer));
            this.consumer.close();
            this.consumer = null;
        }
        catch (Exception ex) {
            log.error((Object)("Error while consuming the message " + ex));
        }
    }

    private void commitRecords(ConsumerRecords<byte[], byte[]> records) {
        long recordOffset = 0L;
        TopicPartition topicPartition = null;
        ConsumerRecord failedRecord = null;
        Iterator iterator = records.partitions().iterator();
        block2: while (iterator.hasNext()) {
            TopicPartition partition;
            topicPartition = partition = (TopicPartition)iterator.next();
            List partitionRecords = records.records(partition);
            for (ConsumerRecord record : partitionRecords) {
                recordOffset = record.offset();
                org.apache.synapse.MessageContext msgCtx = this.populateMessageContext(record);
                Object value = record.value();
                boolean isConsumed = false;
                boolean poisonPillDetected = false;
                if (value == null) {
                    if (this.isPoisonPill(record)) {
                        poisonPillDetected = true;
                        log.warn((Object)("A poison pill was detected for Topic: " + record.topic() + ", Partition No: " + record.partition() + ", Offset: " + record.offset() + ". The respective error details will be injected to the `onError` sequence: " + this.onErrorSeq + " of Kafka Inbound Endpoint: " + this.name));
                        this.handlePoisonPill(record, msgCtx);
                    } else {
                        log.warn((Object)("A null record was passed and skipped for Topic: " + record.topic() + ", Partition No: " + record.partition() + ", Offset: " + record.offset()));
                    }
                    isConsumed = true;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Injecting the kafka message for inbound mediation. Topic: " + record.topic() + ", Partition No: " + record.partition() + ", Offset: " + record.offset() + ", Kafka_Timestamp: " + record.timestamp()));
                    }
                    if (!(isConsumed = this.injectMessage(value.toString(), this.contentType, msgCtx)) && log.isDebugEnabled()) {
                        log.debug((Object)("Kafka message was not successfully consumed by the inbound mediation. Topic: " + record.topic() + ", Partition No: " + record.partition() + ", Offset: " + record.offset() + ", Kafka_Timestamp: " + record.timestamp()));
                    }
                }
                if (!this.isDisableAutoCommit) continue;
                if (poisonPillDetected) {
                    log.info((Object)("The poison pill at offset " + record.offset() + " is skipped by setting the offset to the next record."));
                    this.consumer.seek(topicPartition, recordOffset + 1L);
                    continue;
                }
                if (isConsumed) {
                    this.consumer.commitSync(Collections.singletonMap(topicPartition, new OffsetAndMetadata(recordOffset + 1L)));
                    continue;
                }
                failedRecord = record;
                if (this.failureRetryInterval > 0L && (this.retryCounter < this.failureRetryCount || this.failureRetryCount < 0)) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Failed Kafka message will be retried for inbound mediation after max(poll_interval, failure_retry_interval): " + Long.max(this.failureRetryInterval, this.scanInterval) + "ms."));
                        }
                        Thread.sleep(this.failureRetryInterval);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"The interval for retrying failures was interrupted while waiting.");
                    }
                }
                if (this.failureRetryCount > 0) {
                    ++this.retryCounter;
                }
                if (this.retryCounter >= this.failureRetryCount && this.failureRetryCount >= 0) continue block2;
                this.consumer.seek(topicPartition, recordOffset);
                continue block2;
            }
        }
        if (this.retryCounter == this.failureRetryCount && this.isDisableAutoCommit) {
            log.warn((Object)"The offset set to the next record since failure retry count exceeded.");
            this.consumer.seek(topicPartition, recordOffset + 1L);
            this.retryCounter = 0;
            if (failedRecord != null) {
                org.apache.synapse.MessageContext msgCtx = this.populateMessageContext(failedRecord);
                this.injectErrorMessage("Failed to successfully mediate the message to/in the sequence: " + this.injectingSeq + " of Kafka Inbound Endpoint: " + this.name + ", even after " + this.failureRetryCount + " retires.", "700511", msgCtx);
            }
        }
    }

    private boolean isPoisonPill(ConsumerRecord record) {
        return record.headers().lastHeader("KafkaInboundKeyDeserializerException") != null || record.headers().lastHeader("KafkaInboundValueDeserializerException") != null;
    }

    private void handlePoisonPill(ConsumerRecord record, org.apache.synapse.MessageContext msgCtx) {
        Header keyDeserializationExceptionHeader = record.headers().lastHeader("KafkaInboundKeyDeserializerException");
        Header valueDeserializationExceptionHeader = record.headers().lastHeader("KafkaInboundValueDeserializerException");
        byte[] value = keyDeserializationExceptionHeader != null ? keyDeserializationExceptionHeader.value() : valueDeserializationExceptionHeader.value();
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(value));){
            KafkaException error = (KafkaException)objectInputStream.readObject();
            this.injectErrorMessage(error.getMessage(), "700510", msgCtx);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Could not deserialize the poison pill message into a 'KafkaException'. Hence, failed to inject the poison pill error details to 'onError' sequence: " + this.onErrorSeq + " of Kafka Inbound Endpoint: " + this.name), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Could not deserialize the KafkaException while handling the poison pill. Hence, failed to inject the poison pill error details to 'onError' sequence: " + this.onErrorSeq + " of Kafka Inbound Endpoint: " + this.name), (Throwable)e);
        }
    }

    private void populateOtherProperties(Properties properties) {
        this.checkDisableAutoCommit(properties);
        if (properties.getProperty("kafka.header.prefix") != null) {
            this.kafkaHeaderPrefix = properties.getProperty("kafka.header.prefix").trim();
        }
    }

    private void checkDisableAutoCommit(Properties properties) {
        if ("false".equals(this.kafkaProperties.getProperty("enable.auto.commit"))) {
            this.isDisableAutoCommit = true;
            if (properties.getProperty("failure.retry.count") != null) {
                try {
                    this.failureRetryCount = Integer.parseInt(properties.getProperty("failure.retry.count"));
                }
                catch (NumberFormatException e) {
                    log.error((Object)"Invalid input for 'failure.retry.count'. The value should be a valid Integer");
                }
            } else {
                this.failureRetryCount = Integer.parseInt("-1");
            }
            if (properties.getProperty("failure.retry.interval") != null) {
                try {
                    this.failureRetryInterval = Integer.parseInt(properties.getProperty("failure.retry.interval"));
                }
                catch (NumberFormatException e) {
                    log.error((Object)"Invalid input for 'failure.retry.interval'. The value should be a positive Integer");
                }
            }
        }
    }

    private org.apache.synapse.MessageContext populateMessageContext(ConsumerRecord record) {
        org.apache.synapse.MessageContext msgCtx = this.createMessageContext();
        msgCtx.setProperty("partitionNo", (Object)record.partition());
        msgCtx.setProperty("messageValue", record.value());
        msgCtx.setProperty("offset", (Object)record.offset());
        msgCtx.setProperty("timestamp", (Object)record.timestamp());
        msgCtx.setProperty("timestampType", (Object)record.timestampType());
        msgCtx.setProperty("topic", (Object)record.topic());
        msgCtx.setProperty("key", record.key());
        if (record.value() instanceof GenericData.Record) {
            GenericData.Record val = (GenericData.Record)record.value();
            msgCtx.setProperty("schemaName", (Object)val.getSchema().getFullName());
        }
        msgCtx.setProperty("inbound.endpoint.name", (Object)this.name);
        msgCtx.setProperty("isInbound", (Object)true);
        this.setDynamicParameters(msgCtx, record.headers());
        return msgCtx;
    }

    private void setDynamicParameters(org.apache.synapse.MessageContext messageContext, Headers headers) {
        for (Header header : headers) {
            try {
                String headerVal = new String(header.value(), "UTF-8");
                messageContext.setProperty(this.kafkaHeaderPrefix + header.key(), (Object)headerVal);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Error while getting the kafka header value", (Throwable)e);
            }
        }
    }

    private boolean injectMessage(String strMessage, String contentType, org.apache.synapse.MessageContext msgCtx) {
        AutoCloseInputStream in = new AutoCloseInputStream((InputStream)new ByteArrayInputStream(strMessage.getBytes()));
        return this.injectMessage((InputStream)in, contentType, msgCtx);
    }

    private boolean injectMessage(InputStream in, String contentType, org.apache.synapse.MessageContext msgCtx) {
        boolean isConsumed = true;
        try {
            SequenceMediator seq;
            int index;
            String type;
            Builder builder;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processed Custom inbound EP Message of Content-type : " + contentType + " for " + this.name));
            }
            MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
            if (StringUtils.isEmpty((String)contentType)) {
                log.warn((Object)("Unable to determine content type for message, setting to application/json for " + this.name));
            }
            if ((builder = BuilderUtil.getBuilderFromSelector((String)(type = (index = contentType.indexOf(59)) > 0 ? contentType.substring(0, index) : contentType), (MessageContext)axis2MsgCtx)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP. for" + this.name));
                }
                builder = new SOAPBuilder();
            }
            OMElement documentElement1 = builder.processDocument(in, contentType, axis2MsgCtx);
            msgCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement1));
            if (this.injectingSeq == null || "".equals(this.injectingSeq)) {
                log.error((Object)("Sequence name not specified. Sequence : " + this.injectingSeq + " for " + this.name));
                isConsumed = false;
            }
            if ((seq = (SequenceMediator)this.synapseEnvironment.getSynapseConfiguration().getSequence(this.injectingSeq)) == null) {
                throw new SynapseException("Sequence with name : " + this.injectingSeq + " is not found to mediate the message.");
            }
            seq.setErrorHandler(this.onErrorSeq);
            if (log.isDebugEnabled()) {
                log.debug((Object)("injecting message to sequence : " + this.injectingSeq + " of " + this.name));
            }
            if (!this.synapseEnvironment.injectInbound(msgCtx, seq, this.sequential)) {
                isConsumed = false;
            }
            if (this.isRollback(msgCtx)) {
                isConsumed = false;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while processing the Kafka inbound endpoint Message and the message should be in the format of " + contentType), (Throwable)e);
            isConsumed = false;
        }
        return isConsumed;
    }

    private boolean injectErrorMessage(String message, String errorCode, org.apache.synapse.MessageContext msgCtx) {
        if (StringUtils.isEmpty((String)this.onErrorSeq)) {
            log.error((Object)("Could not mediate the error message as the 'onError' sequence name not specified for Kafka Inbound Endpoint: " + this.name + ". Hence, no retry attempted on failure."));
            return false;
        }
        SequenceMediator errorSeq = (SequenceMediator)this.synapseEnvironment.getSynapseConfiguration().getSequence(this.onErrorSeq);
        if (errorSeq == null) {
            log.error((Object)("Could not mediate the error message as the 'onError' Sequence with name: " + this.onErrorSeq + " not found. Hence, no retry attempted on failure."));
            return false;
        }
        msgCtx.setProperty("ERROR_CODE", (Object)errorCode);
        msgCtx.setProperty("ERROR_MESSAGE", (Object)message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("injecting message to 'onError' sequence: " + this.onErrorSeq + " of Kafka Inbound Endpoint: " + this.name));
        }
        if (!this.synapseEnvironment.injectInbound(msgCtx, errorSeq, this.sequential)) {
            log.warn((Object)("Could not inject the error details to 'onError' sequence: " + this.onErrorSeq + " of Kafka Inbound Endpoint: " + this.name));
            return false;
        }
        return true;
    }

    private boolean isRollback(org.apache.synapse.MessageContext msgCtx) {
        Object rollbackProp = msgCtx.getProperty("SET_ROLLBACK_ONLY");
        if (rollbackProp != null) {
            return rollbackProp instanceof Boolean && (Boolean)rollbackProp != false || rollbackProp instanceof String && Boolean.valueOf((String)rollbackProp) != false;
        }
        return false;
    }

    private void validateMandatoryParameters(Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting to load the Kafka Mandatory parameters");
        }
        this.bootstrapServersName = properties.getProperty("bootstrap.servers");
        this.keyDeserializer = properties.getProperty("key.deserializer");
        if ("org.wso2.carbon.inbound.kafka.deserializer.ErrorHandlingDeserializer".equals(this.keyDeserializer) && StringUtils.isEmpty((String)properties.getProperty("key.delegate.deserializer"))) {
            throw new SynapseException("The 'key.delegate.deserializer' property must not be empty when 'key.deserializer' is configured with the default error handling deserializer.");
        }
        this.valueDeserializer = properties.getProperty("value.deserializer");
        if ("org.wso2.carbon.inbound.kafka.deserializer.ErrorHandlingDeserializer".equals(this.valueDeserializer) && StringUtils.isEmpty((String)properties.getProperty("value.delegate.deserializer"))) {
            throw new SynapseException("The 'value.delegate.deserializer' property must not be empty when 'value.deserializer' is configured with the default error handling deserializer.");
        }
        this.groupId = properties.getProperty("group.id");
        this.pollTimeout = properties.getProperty("poll.timeout");
        if (properties.getProperty("topic.name") != null) {
            this.isRegexPattern = false;
            this.topic = properties.getProperty("topic.name");
        } else if (properties.getProperty("topic.pattern") != null) {
            this.isRegexPattern = true;
            this.topic = properties.getProperty("topic.pattern");
        }
        this.contentType = properties.getProperty("contentType");
        if (StringUtils.isEmpty((String)this.bootstrapServersName) || StringUtils.isEmpty((String)this.keyDeserializer) || StringUtils.isEmpty((String)this.valueDeserializer) || StringUtils.isEmpty((String)this.groupId) || StringUtils.isEmpty((String)this.pollTimeout) || StringUtils.isEmpty((String)this.topic) || StringUtils.isEmpty((String)this.contentType)) {
            throw new SynapseException("Mandatory Parameters cannot be Empty, The mandatory parameters are bootstrap.servers, key.deserializer, value.deserializer, group.id, poll.timeout, (topic.name or topic.pattern) and contentType");
        }
    }

    private org.apache.synapse.MessageContext createMessageContext() {
        org.apache.synapse.MessageContext msgCtx = this.synapseEnvironment.createMessageContext();
        MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        axis2MsgCtx.setServerSide(true);
        axis2MsgCtx.setMessageID(String.valueOf(UUID.randomUUID()));
        return msgCtx;
    }

    public Object poll() {
        if (this.consumer == null) {
            try {
                this.consumer = new KafkaConsumer(this.kafkaProperties);
                if (!this.isRegexPattern) {
                    if (this.properties.getProperty("topic.partitions") != null) {
                        String[] partitionsArray = this.properties.getProperty("topic.partitions").split(",");
                        ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
                        for (String partition : partitionsArray) {
                            topicPartitions.add(new TopicPartition(this.topic, Integer.parseInt(partition)));
                        }
                        this.consumer.assign(topicPartitions);
                    } else {
                        this.consumer.subscribe(Collections.singletonList(this.topic));
                    }
                } else {
                    Pattern r = Pattern.compile(this.topic);
                    this.consumer.subscribe(r);
                }
            }
            catch (Exception e) {
                throw new SynapseException("Failed to construct kafka consumer", (Throwable)e);
            }
        }
        this.consumeKafkaRecords();
        return null;
    }

    public void destroy() {
        try {
            if (this.consumer != null) {
                this.consumer.wakeup();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The Kafka consumer has been close ! for " + this.name));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while shutdown the Kafka consumer " + this.name + " " + e.getMessage()), (Throwable)e);
        }
    }

    private void createKafkaProperties(Properties properties) {
        this.kafkaProperties = new Properties();
        this.kafkaProperties.put("bootstrap.servers", this.bootstrapServersName);
        this.kafkaProperties.put("key.deserializer", this.keyDeserializer);
        this.kafkaProperties.put("value.deserializer", this.valueDeserializer);
        this.kafkaProperties.put("group.id", this.groupId);
        this.kafkaProperties.put("poll.timeout", this.pollTimeout);
        this.kafkaProperties.put("enable.auto.commit", properties.getProperty("enable.auto.commit", "true"));
        this.kafkaProperties.put("auto.commit.interval.ms", properties.getProperty("auto.commit.interval.ms", "5000"));
        this.kafkaProperties.put("session.timeout.ms", properties.getProperty("session.timeout.ms", "10000"));
        this.kafkaProperties.put("fetch.min.bytes", properties.getProperty("fetch.min.bytes", "1"));
        this.kafkaProperties.put("heartbeat.interval.ms", properties.getProperty("heartbeat.interval.ms", "3000"));
        this.kafkaProperties.put("max.partition.fetch.bytes", properties.getProperty("max.partition.fetch.bytes", "1048576"));
        if (properties.getProperty("key.delegate.deserializer") != null) {
            this.kafkaProperties.put("key.delegate.deserializer", properties.getProperty("key.delegate.deserializer"));
        }
        if (properties.getProperty("value.delegate.deserializer") != null) {
            this.kafkaProperties.put("value.delegate.deserializer", properties.getProperty("value.delegate.deserializer"));
        }
        if (properties.getProperty("value.deserializer").equalsIgnoreCase("io.confluent.kafka.serializers.KafkaAvroDeserializer") || "io.confluent.kafka.serializers.KafkaAvroDeserializer".equalsIgnoreCase(properties.getProperty("value.delegate.deserializer"))) {
            this.kafkaProperties.put("schema.registry.url", properties.getProperty("schema.registry.url", "http://localhost:8081"));
            if (properties.getProperty("basic.auth.credentials.source") != null) {
                this.kafkaProperties.put("basic.auth.credentials.source", properties.getProperty("basic.auth.credentials.source"));
            }
            if (properties.getProperty("basic.auth.user.info") != null) {
                this.kafkaProperties.put("basic.auth.user.info", properties.getProperty("basic.auth.user.info"));
            }
        }
        if (properties.getProperty("ssl.key.password") != null) {
            this.kafkaProperties.put("ssl.key.password", properties.getProperty("ssl.key.password"));
        }
        if (properties.getProperty("ssl.keystore.location") != null) {
            this.kafkaProperties.put("ssl.keystore.location", properties.getProperty("ssl.keystore.location"));
        }
        if (properties.getProperty("ssl.keystore.password") != null) {
            this.kafkaProperties.put("ssl.keystore.password", properties.getProperty("ssl.keystore.password"));
        }
        if (properties.getProperty("ssl.truststore.location") != null) {
            this.kafkaProperties.put("ssl.truststore.location", properties.getProperty("ssl.truststore.location"));
        }
        if (properties.getProperty("ssl.truststore.password") != null) {
            this.kafkaProperties.put("ssl.truststore.password", properties.getProperty("ssl.truststore.password"));
        }
        this.kafkaProperties.put("auto.offset.reset", properties.getProperty("auto.offset.reset", "latest"));
        this.kafkaProperties.put("connections.max.idle.ms", properties.getProperty("connections.max.idle.ms", "540000"));
        this.kafkaProperties.put("exclude.internal.topics", properties.getProperty("exclude.internal.topics", "true"));
        this.kafkaProperties.put("fetch.max.bytes", properties.getProperty("fetch.max.bytes", "52428800"));
        this.kafkaProperties.put("max.poll.interval.ms", properties.getProperty("max.poll.interval.ms", "300000"));
        this.kafkaProperties.put("max.poll.records", properties.getProperty("max.poll.records", "500"));
        this.kafkaProperties.put("partition.assignment.strategy", properties.getProperty("partition.assignment.strategy", "org.apache.kafka.clients.consumer.RangeAssignor"));
        this.kafkaProperties.put("receive.buffer.bytes", properties.getProperty("receive.buffer.bytes", "65536"));
        this.kafkaProperties.put("request.timeout.ms", properties.getProperty("request.timeout.ms", "305000"));
        if (properties.getProperty("sasl.jaas.config") != null) {
            this.kafkaProperties.put("sasl.jaas.config", properties.getProperty("sasl.jaas.config"));
        }
        if (properties.getProperty("sasl.client.callback.handler.class") != null) {
            this.kafkaProperties.put("sasl.client.callback.handler.class", properties.getProperty("sasl.client.callback.handler.class"));
        }
        if (properties.getProperty("sasl.login.class") != null) {
            this.kafkaProperties.put("sasl.login.class", properties.getProperty("sasl.login.class"));
        }
        if (properties.getProperty("sasl.kerberos.service.name") != null) {
            this.kafkaProperties.put("sasl.kerberos.service.name", properties.getProperty("sasl.kerberos.service.name"));
        }
        if (properties.getProperty("sasl.mechanism") != null) {
            this.kafkaProperties.put("sasl.mechanism", properties.getProperty("sasl.mechanism"));
        }
        if (properties.getProperty("security.protocol") != null) {
            this.kafkaProperties.put("security.protocol", properties.getProperty("security.protocol"));
        }
        this.kafkaProperties.put("send.buffer.bytes", properties.getProperty("send.buffer.bytes", "131072"));
        if (properties.getProperty("ssl.enabled.protocols") != null) {
            String[] sslEnabledProtocolsArray = properties.getProperty("ssl.enabled.protocols").split(",");
            this.kafkaProperties.put("ssl.enabled.protocols", Arrays.asList(sslEnabledProtocolsArray));
        }
        if (properties.getProperty("ssl.keystore.type") != null) {
            this.kafkaProperties.put("ssl.keystore.type", properties.getProperty("ssl.keystore.type"));
        }
        if (properties.getProperty("ssl.protocol") != null) {
            this.kafkaProperties.put("ssl.protocol", properties.getProperty("ssl.protocol"));
        }
        if (properties.getProperty("ssl.provider") != null) {
            this.kafkaProperties.put("ssl.provider", properties.getProperty("ssl.provider"));
        }
        if (properties.getProperty("ssl.truststore.type") != null) {
            this.kafkaProperties.put("ssl.truststore.type", properties.getProperty("ssl.truststore.type"));
        }
        this.kafkaProperties.put("check.crcs", properties.getProperty("check.crcs", "true"));
        this.kafkaProperties.put("client.id", properties.getProperty("client.id", ""));
        this.kafkaProperties.put("fetch.max.wait.ms", properties.getProperty("fetch.max.wait.ms", "500"));
        this.kafkaProperties.put("interceptor.classes", properties.getProperty("interceptor.classes", ""));
        this.kafkaProperties.put("metadata.max.age.ms", properties.getProperty("metadata.max.age.ms", "300000"));
        this.kafkaProperties.put("metric.reporters", properties.getProperty("metric.reporters", ""));
        this.kafkaProperties.put("metrics.num.samples", properties.getProperty("metrics.num.samples", "2"));
        this.kafkaProperties.put("metrics.recording.level", properties.getProperty("metrics.recording.level", "INFO"));
        this.kafkaProperties.put("metrics.sample.window.ms", properties.getProperty("metrics.sample.window.ms", "30000"));
        this.kafkaProperties.put("reconnect.backoff.ms", properties.getProperty("reconnect.backoff.ms", "50"));
        this.kafkaProperties.put("retry.backoff.ms", properties.getProperty("retry.backoff.ms", "100"));
        this.kafkaProperties.put("avro.use.logical.type.converters", properties.getProperty("avro.use.logical.type.converters", "false"));
        if (properties.getProperty("sasl.kerberos.kinit.cmd") != null) {
            this.kafkaProperties.put("sasl.kerberos.kinit.cmd", properties.getProperty("sasl.kerberos.kinit.cmd"));
        }
        if (properties.getProperty("sasl.kerberos.min.time.before.relogin") != null) {
            this.kafkaProperties.put("sasl.kerberos.min.time.before.relogin", properties.getProperty("sasl.kerberos.min.time.before.relogin"));
        }
        if (properties.getProperty("sasl.kerberos.ticket.renew.jitter") != null) {
            properties.setProperty("sasl.kerberos.ticket.renew.jitter", properties.getProperty("sasl.kerberos.ticket.renew.jitter"));
        }
        if (properties.getProperty("sasl.kerberos.ticket.renew.window.factor") != null) {
            this.kafkaProperties.put("sasl.kerberos.ticket.renew.window.factor", properties.getProperty("sasl.kerberos.ticket.renew.window.factor"));
        }
        if (properties.getProperty("ssl.cipher.suites") != null) {
            properties.setProperty("ssl.cipher.suites", properties.getProperty("ssl.cipher.suites"));
        }
        if (properties.getProperty("ssl.endpoint.identification.algorithm") != null) {
            this.kafkaProperties.put("ssl.endpoint.identification.algorithm", properties.getProperty("ssl.endpoint.identification.algorithm"));
        }
        if (properties.getProperty("ssl.cipher.suites") != null) {
            this.kafkaProperties.put("ssl.cipher.suites", properties.getProperty("ssl.cipher.suites"));
        }
        if (properties.getProperty("ssl.keymanager.algorithm") != null) {
            this.kafkaProperties.put("ssl.keymanager.algorithm", properties.getProperty("ssl.keymanager.algorithm"));
        }
        if (properties.getProperty("ssl.secure.random.implementation") != null) {
            this.kafkaProperties.put("ssl.secure.random.implementation", properties.getProperty("ssl.secure.random.implementation"));
        }
        if (properties.getProperty("ssl.trustmanager.algorithm") != null) {
            this.kafkaProperties.put("ssl.trustmanager.algorithm", properties.getProperty("ssl.trustmanager.algorithm"));
        }
        if (properties.getProperty("sasl.oauthbearer.token.endpoint.url") != null) {
            this.kafkaProperties.put("sasl.oauthbearer.token.endpoint.url", properties.getProperty("sasl.oauthbearer.token.endpoint.url"));
        }
        if (properties.getProperty("sasl.oauthbearer.scope.claim.name") != null) {
            this.kafkaProperties.put("sasl.oauthbearer.scope.claim.name", properties.getProperty("sasl.oauthbearer.scope.claim.name"));
        }
        if (properties.getProperty("sasl.login.callback.handler.class") != null) {
            this.kafkaProperties.put("sasl.login.callback.handler.class", properties.getProperty("sasl.login.callback.handler.class"));
        }
        if (properties.getProperty("sasl.login.connect.timeout.ms") != null) {
            this.kafkaProperties.put("sasl.login.connect.timeout.ms", properties.getProperty("sasl.login.connect.timeout.ms"));
        }
        if (properties.getProperty("sasl.login.read.timeout.ms") != null) {
            this.kafkaProperties.put("sasl.login.read.timeout.ms", properties.getProperty("sasl.login.read.timeout.ms"));
        }
        if (properties.getProperty("sasl.login.retry.backoff.ms") != null) {
            this.kafkaProperties.put("sasl.login.retry.backoff.ms", properties.getProperty("sasl.login.retry.backoff.ms"));
        }
        if (properties.getProperty("sasl.login.retry.backoff.max.ms") != null) {
            this.kafkaProperties.put("sasl.login.retry.backoff.max.ms", properties.getProperty("sasl.login.retry.backoff.max.ms"));
        }
    }
}

