/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.kafka.deserializer;

import java.util.Arrays;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.header.Headers;

public class DeserializationException
extends KafkaException {
    private final String topic;
    private transient Headers headers;
    private final byte[] data;
    private final boolean isKey;

    public DeserializationException(String message, String topic, byte[] data, boolean isKey, Throwable cause) {
        super(message, cause);
        this.topic = topic;
        this.data = data;
        this.isKey = isKey;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public String getMessage() {
        return "Error details{message=" + super.getMessage() + ", topic=" + this.topic + ", data=" + Arrays.toString(this.data) + ", cause=" + this.getCause().getMessage() + "}";
    }
}

