/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.kafka.deserializer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.synapse.SynapseException;
import org.wso2.carbon.inbound.kafka.deserializer.DeserializationException;

public class ErrorHandlingDeserializer<T>
implements Deserializer<T> {
    private static final Log LOGGER = LogFactory.getLog(ErrorHandlingDeserializer.class);
    private Deserializer<T> delegate;
    private boolean isForKey;

    public ErrorHandlingDeserializer() {
    }

    public ErrorHandlingDeserializer(Deserializer<T> delegate) {
        this.delegate = this.setupDelegate(delegate);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (this.delegate == null) {
            this.setupDelegate(configs, isKey ? "key.delegate.deserializer" : "value.delegate.deserializer");
        }
        if (this.delegate == null) {
            LOGGER.error((Object)"No delegate deserializer configured");
        }
        this.delegate.configure(configs, isKey);
        this.isForKey = isKey;
    }

    public T deserialize(String topic, byte[] data) {
        try {
            return (T)this.delegate.deserialize(topic, data);
        }
        catch (Exception e) {
            Iterable recordHeaders = null;
            RecordHeaders headers = new RecordHeaders(recordHeaders);
            ErrorHandlingDeserializer.addDeserializationExceptionToHeaders(topic, (Headers)headers, data, e, this.isForKey);
            return null;
        }
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        try {
            if (this.isForKey) {
                headers.remove("KafkaInboundKeyDeserializerException");
            } else {
                headers.remove("KafkaInboundValueDeserializerException");
            }
            return (T)this.delegate.deserialize(topic, headers, data);
        }
        catch (Exception e) {
            ErrorHandlingDeserializer.addDeserializationExceptionToHeaders(topic, headers, data, e, this.isForKey);
            return null;
        }
    }

    public void close() {
        super.close();
    }

    private void setupDelegate(Map<String, ?> configs, String configKey) {
        if (configs.containsKey(configKey)) {
            try {
                Object value = configs.get(configKey);
                ClassLoader classLoader = ErrorHandlingDeserializer.getDefaultClassLoader();
                if (classLoader == null) {
                    throw new SynapseException("Could not setup the delegate as the ClassLoader was not accessible.");
                }
                Class<?> clazz = classLoader.loadClass(value.toString());
                this.delegate = this.setupDelegate(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new SynapseException("Could not setup the delegate.", (Throwable)e);
            }
        }
    }

    private Deserializer<T> setupDelegate(Object delegate) {
        if (!(delegate instanceof Deserializer)) {
            throw new SynapseException("'delegate' must be a 'Deserializer'");
        }
        return (Deserializer)delegate;
    }

    private static void addDeserializationExceptionToHeaders(String topic, Headers headers, byte[] data, Exception ex, boolean isForKeyArg) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DeserializationException exception = new DeserializationException("Failed to deserialize the " + ErrorHandlingDeserializer.getType(isForKeyArg), topic, data, isForKeyArg, ex);
        try (ObjectOutputStream oos = new ObjectOutputStream(stream);){
            oos.writeObject((Object)exception);
        }
        catch (IOException e) {
            stream = new ByteArrayOutputStream();
            try (ObjectOutputStream oos2 = new ObjectOutputStream(stream);){
                exception = new DeserializationException("Failed to deserialize the " + ErrorHandlingDeserializer.getType(isForKeyArg), topic, data, isForKeyArg, new RuntimeException("Could not serialize type " + ex.getClass().getName() + " with message " + e.getMessage() + ". Original exception message: " + ex.getMessage()));
                oos2.writeObject((Object)exception);
            }
            catch (IOException ex2) {
                LOGGER.error((Object)("Poison pill is detected for Topic: " + topic + ". However, unable to inject the error details to 'onError' sequence since there was an error while serializing a DeserializationException. " + ex2.getMessage()));
                return;
            }
        }
        headers.add((Header)new RecordHeader(isForKeyArg ? "KafkaInboundKeyDeserializerException" : "KafkaInboundValueDeserializerException", stream.toByteArray()));
    }

    private static String getType(boolean isForKey) {
        if (isForKey) {
            return "Key";
        }
        return "Value";
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ErrorHandlingDeserializer.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }
}

