/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.consent.mgt.core.util.ConsentConfigParser;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.is.migration.internal.ISMigrationServiceDataHolder;
import org.wso2.carbon.is.migration.util.Schema;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class DataSourceManager {
    private DataSource dataSource;
    private DataSource umDataSource;
    private DataSource consentDataSource;
    private static final Log log = LogFactory.getLog(DataSourceManager.class);
    private static DataSourceManager dataSourceManager = null;

    private DataSourceManager() {
        try {
            this.initIdentityDataSource();
            this.initUMDataSource();
            this.initConsentDataSource();
        }
        catch (MigrationClientException e) {
            log.error((Object)"Error while initializing datasource manager.");
        }
        this.initOracleDataSource();
    }

    public static DataSourceManager getInstance() {
        if (dataSourceManager == null) {
            dataSourceManager = new DataSourceManager();
        }
        return dataSourceManager;
    }

    public DataSource getDataSource(Schema schema) throws MigrationClientException {
        if (schema.getName().equals(Schema.IDENTITY.getName())) {
            return this.dataSource;
        }
        if (schema.getName().equals(Schema.UM.getName())) {
            return this.umDataSource;
        }
        if (schema.getName().equals(Schema.CONSENT.getName())) {
            return this.consentDataSource;
        }
        throw new MigrationClientException("DataSource is not available for " + (Object)((Object)schema));
    }

    public DataSource getDataSource(String schema) throws MigrationClientException {
        if (schema.equals(Schema.IDENTITY.getName())) {
            return this.dataSource;
        }
        if (schema.equals(Schema.UM.getName())) {
            return this.umDataSource;
        }
        if (schema.equals(Schema.CONSENT.getName())) {
            return this.consentDataSource;
        }
        throw new MigrationClientException("DataSource is not available for " + schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOracleDataSource() {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            if ("oracle".equals(DatabaseCreator.getDatabaseType((Connection)conn)) && ISMigrationServiceDataHolder.getIdentityOracleUser() == null) {
                ISMigrationServiceDataHolder.setIdentityOracleUser(this.dataSource.getConnection().getMetaData().getUserName());
                log.info((Object)" WSO2 Product Migration Service Task : Initialized identity database in Oracle.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while initializing identity database for Oracle.", (Throwable)e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing the identity database connection", (Throwable)e);
            }
        }
        try {
            conn = this.umDataSource.getConnection();
            if ("oracle".equals(DatabaseCreator.getDatabaseType((Connection)conn)) && ISMigrationServiceDataHolder.getUmOracleUser() == null) {
                ISMigrationServiceDataHolder.setUmOracleUser(this.umDataSource.getConnection().getMetaData().getUserName());
                log.info((Object)" WSO2 Product Migration Service Task : Initialized user management database in Oracle.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while initializing user management database for Oracle.", (Throwable)e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing the user manager database connection", (Throwable)e);
            }
        }
        try {
            conn = this.consentDataSource.getConnection();
            if ("oracle".equals(DatabaseCreator.getDatabaseType((Connection)conn)) && ISMigrationServiceDataHolder.getIdentityOracleUser() == null) {
                ISMigrationServiceDataHolder.setIdentityOracleUser(this.consentDataSource.getConnection().getMetaData().getUserName());
                log.info((Object)" WSO2 Product Migration Service Task : Initialized user management database in Oracle.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while initializing user management database for Oracle.", (Throwable)e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Error while closing the user manager database connection", (Throwable)e);
            }
        }
    }

    private void initIdentityDataSource() throws MigrationClientException {
        try {
            OMElement persistenceManagerConfigElem = IdentityConfigParser.getInstance().getConfigElement("JDBCPersistenceManager");
            if (persistenceManagerConfigElem == null) {
                String errorMsg = "Identity Persistence Manager configuration is not available in identity.xml file. Terminating the JDBC Persistence Manager initialization. This may affect certain functionality.";
                log.error((Object)errorMsg);
                throw new MigrationClientException(errorMsg);
            }
            OMElement dataSourceElem = persistenceManagerConfigElem.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "DataSource"));
            if (dataSourceElem == null) {
                String errorMsg = "DataSource Element is not available for JDBC Persistence Manager in identity.xml file. Terminating the JDBC Persistence Manager initialization. This might affect certain features.";
                log.error((Object)errorMsg);
                throw new MigrationClientException(errorMsg);
            }
            OMElement dataSourceNameElem = dataSourceElem.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Name"));
            if (dataSourceNameElem != null) {
                String dataSourceName = dataSourceNameElem.getText();
                InitialContext ctx = new InitialContext();
                this.dataSource = (DataSource)ctx.lookup(dataSourceName);
                if (this.dataSource != null) {
                    log.info((Object)" WSO2 Product Migration Service Task : Initialized the identity database successfully.");
                }
            }
        }
        catch (NamingException e) {
            String errorMsg = "Error when looking up the Identity Data Source.";
            throw new MigrationClientException(errorMsg, (Throwable)e);
        }
    }

    private void initUMDataSource() throws MigrationClientException {
        this.umDataSource = DatabaseUtil.getRealmDataSource((RealmConfiguration)ISMigrationServiceDataHolder.getRealmService().getBootstrapRealmConfiguration());
        if (this.umDataSource == null) {
            String errorMsg = "UM Datasource initialization error.";
            throw new MigrationClientException(errorMsg);
        }
    }

    private void initConsentDataSource() throws MigrationClientException {
        ConsentConfigParser configParser = new ConsentConfigParser();
        String dataSourceName = configParser.getConsentDataSource();
        if (dataSourceName == null) {
            String errorMsg = "DataSource Element is not available for Consent management";
            log.error((Object)errorMsg);
            throw new MigrationClientException(errorMsg);
        }
        try {
            InitialContext ctx = new InitialContext();
            this.consentDataSource = (DataSource)ctx.lookup(dataSourceName);
        }
        catch (NamingException e) {
            String errorMsg = "Error when looking up the Consent Data Source.";
            throw new MigrationClientException(errorMsg, (Throwable)e);
        }
    }
}

