/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.is.migration.config.Config;
import org.wso2.carbon.is.migration.config.MigratorConfig;
import org.wso2.carbon.is.migration.config.Version;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.service.SchemaMigrator;

public abstract class VersionMigration {
    private static final Log log = LogFactory.getLog(VersionMigration.class);

    public void migrate() throws MigrationClientException {
        List<Migrator> migrators = this.getMigrators();
        for (Migrator migrator : migrators) {
            log.info((Object)(" WSO2 Product Migration Service Task : Version : " + this.getCurrentVersion() + ", Migration Step : " + migrator.getClass().getSimpleName() + " starting........................... "));
            migrator.migrate();
        }
    }

    public List<Migrator> getMigrators() throws MigrationClientException {
        ArrayList<Migrator> migrators = new ArrayList<Migrator>();
        Version version = this.getMigrationConfig();
        List<MigratorConfig> migratorConfigs = version.getMigratorConfigs();
        for (MigratorConfig migratorConfig : migratorConfigs) {
            String migratorName = migratorConfig.getName();
            Migrator migrator = null;
            migrator = migratorName.equals("SchemaMigrator") ? new SchemaMigrator() : this.getMigrator(migratorName);
            migrator.setMigratorConfig(migratorConfig);
            migrator.setVersionConfig(version);
            migrators.add(migrator);
        }
        return migrators;
    }

    public abstract String getPreviousVersion();

    public abstract String getCurrentVersion();

    public Migrator getMigrator(String migratorName) {
        Package aPackage = this.getClass().getPackage();
        String basePackage = aPackage.getName() + ".migrator";
        try {
            Class<?> migratorClass = Class.forName(basePackage + "." + migratorName);
            Migrator migrator = (Migrator)migratorClass.newInstance();
            return migrator;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Error while creating migration instance");
        }
        catch (InstantiationException e) {
            log.error((Object)"Error while creating migration instance");
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Error while creating migration instance");
        }
        return null;
    }

    public Version getMigrationConfig() throws MigrationClientException {
        Config config = Config.getInstance();
        Version version = config.getMigrateVersion(this.getCurrentVersion());
        return version;
    }
}

