/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.is.migration.config.Version;
import org.wso2.carbon.is.migration.util.Utility;

public class Config {
    private static final Log log = LogFactory.getLog(Config.class);
    private boolean migrationEnable;
    private String currentVersion;
    private String migrateVersion;
    private boolean continueOnError;
    private boolean batchUpdate;
    private boolean ignoreForInactiveTenants;
    private boolean migrateTenantRange;
    private int migrationStartingTenantID;
    private int migrationEndingTenantID;
    private List<Version> versions = new ArrayList<Version>();
    private static Config config = null;

    private Config() {
    }

    public static Config getInstance() {
        if (config == null) {
            String migrationConfigFileName = Utility.getMigrationResourceDirectoryPath() + File.separator + "migration-config.yaml";
            log.info((Object)(" WSO2 Product Migration Service Task : Loading Migration Configs, PATH:" + migrationConfigFileName));
            try {
                config = Utility.loadMigrationConfig(migrationConfigFileName);
            }
            catch (MigrationClientException e) {
                log.error((Object)"Error while loading migration configs.", (Throwable)e);
            }
            log.info((Object)" WSO2 Product Migration Service Task : Successfully loaded the config file.");
        }
        return config;
    }

    public boolean isMigrationEnable() {
        return this.migrationEnable;
    }

    public void setMigrationEnable(boolean migrationEnable) {
        this.migrationEnable = migrationEnable;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public void setVersions(List<Version> versions) {
        this.versions = versions;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getMigrateVersion() {
        return this.migrateVersion;
    }

    public void setMigrateVersion(String migrateVersion) {
        this.migrateVersion = migrateVersion;
    }

    public static Config getConfig() {
        return config;
    }

    public static void setConfig(Config config) {
        Config.config = config;
    }

    public Version getMigrateVersion(String version) {
        for (Version migrateVersion : this.versions) {
            if (!migrateVersion.getVersion().equals(version)) continue;
            return migrateVersion;
        }
        return null;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public boolean isBatchUpdate() {
        return this.batchUpdate;
    }

    public void setBatchUpdate(boolean batchUpdate) {
        this.batchUpdate = batchUpdate;
    }

    public boolean isIgnoreForInactiveTenants() {
        return this.ignoreForInactiveTenants;
    }

    public void setIgnoreForInactiveTenants(boolean ignoreForInactiveTenants) {
        this.ignoreForInactiveTenants = ignoreForInactiveTenants;
    }

    public boolean isMigrateTenantRange() {
        return this.migrateTenantRange;
    }

    public void setMigrateTenantRange(boolean migrateTenantRange) {
        this.migrateTenantRange = migrateTenantRange;
    }

    public int getMigrationStartingTenantID() {
        return this.migrationStartingTenantID;
    }

    public void setMigrationStartingTenantID(int migrationStartingTenantID) {
        this.migrationStartingTenantID = migrationStartingTenantID;
    }

    public int getMigrationEndingTenantID() {
        return this.migrationEndingTenantID;
    }

    public void setMigrationEndingTenantID(int migrationEndingTenantID) {
        this.migrationEndingTenantID = migrationEndingTenantID;
    }
}

