/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.identity.core.migrate.MigrationClient;
import org.wso2.carbon.is.migration.MigrationClientImpl;
import org.wso2.carbon.is.migration.internal.ISMigrationServiceDataHolder;
import org.wso2.carbon.user.core.service.RealmService;

public class ISMigrationServiceComponent {
    private static final Log log = LogFactory.getLog(ISMigrationServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            ISMigrationServiceDataHolder.setIdentityOracleUser(System.getProperty("identityOracleUser"));
            ISMigrationServiceDataHolder.setUmOracleUser(System.getProperty("umOracleUser"));
            context.getBundleContext().registerService(MigrationClient.class, (Object)new MigrationClientImpl(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"WSO2 IS migration bundle is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while initiating Config component", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"WSO2 IS migration bundle is deactivated");
        }
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting RealmService to WSO2 IS Config component");
        }
        ISMigrationServiceDataHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting RealmService from WSO2 IS Config component");
        }
        ISMigrationServiceDataHolder.setRealmService(null);
    }
}

