/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service;

import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.is.migration.DataSourceManager;
import org.wso2.carbon.is.migration.config.Config;
import org.wso2.carbon.is.migration.config.MigratorConfig;
import org.wso2.carbon.is.migration.config.Version;

public abstract class Migrator {
    public static final String SCHEMA = "schema";
    public static final String CONTINUE_ON_ERROR = "continueOnError";
    public static final String BATCH_UPDATE = "batchUpdate";
    public static final String IGNORE_FOR_INACTIVE_TENANTS = "ignoreForInactiveTenants";
    private MigratorConfig migratorConfig;
    private Version versionConfig;

    public void setMigratorConfig(MigratorConfig migratorConfig) {
        this.migratorConfig = migratorConfig;
    }

    public MigratorConfig getMigratorConfig() {
        return this.migratorConfig;
    }

    public DataSource getDataSource(String schema) throws MigrationClientException {
        DataSource dataSource = DataSourceManager.getInstance().getDataSource(schema);
        return dataSource;
    }

    public DataSource getDataSource() throws MigrationClientException {
        DataSource dataSource = DataSourceManager.getInstance().getDataSource(this.getSchema());
        return dataSource;
    }

    public boolean isContinueOnError() {
        String continueOnError = this.getMigratorConfig().getParameterValue(CONTINUE_ON_ERROR);
        if (StringUtils.isBlank((String)continueOnError)) {
            return Config.getInstance().isContinueOnError();
        }
        return Boolean.parseBoolean(continueOnError);
    }

    public boolean isBatchUpdate() {
        String batchUpdate = this.getMigratorConfig().getParameterValue(BATCH_UPDATE);
        if (StringUtils.isBlank((String)batchUpdate)) {
            return Config.getInstance().isBatchUpdate();
        }
        return Boolean.parseBoolean(batchUpdate);
    }

    public boolean isIgnoreForInactiveTenants() {
        String ignoreForInactiveTenants = this.getMigratorConfig().getParameterValue(IGNORE_FOR_INACTIVE_TENANTS);
        if (StringUtils.isBlank((String)ignoreForInactiveTenants)) {
            return Config.getInstance().isIgnoreForInactiveTenants();
        }
        return Boolean.parseBoolean(ignoreForInactiveTenants);
    }

    public String getSchema() {
        return this.getMigratorConfig().getParameterValue(SCHEMA);
    }

    public Version getVersionConfig() {
        return this.versionConfig;
    }

    public void setVersionConfig(Version versionConfig) {
        this.versionConfig = versionConfig;
    }

    public abstract void migrate() throws MigrationClientException;
}

