/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.is.migration.internal.ISMigrationServiceDataHolder;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.util.Utility;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class SchemaMigrator
extends Migrator {
    private static final Log log = LogFactory.getLog(SchemaMigrator.class);
    public static final String LOCATION = "location";
    private String location;
    private Connection conn = null;
    private Statement statement;
    private String delimiter = ";";

    @Override
    public void migrate() throws MigrationClientException {
        this.location = this.getMigratorConfig().getParameterValue(LOCATION);
        log.info((Object)" WSO2 Product Migration Service Task : Executing Identity Migration Scripts.");
        try {
            this.conn = this.getDataSource().getConnection();
            this.conn.setAutoCommit(false);
            String databaseType = DatabaseCreator.getDatabaseType((Connection)this.conn);
            if ("mysql".equals(databaseType)) {
                Utility.setMySQLDBName(this.conn);
                if (this.conn.getMetaData().getDatabaseProductVersion().startsWith("5.7")) {
                    databaseType = "mysql5.7";
                }
            }
            this.statement = this.conn.createStatement();
            String dbscriptName = Utility.getSchemaPath(this.getSchema(), databaseType, this.location, this.getVersionConfig().getVersion());
            this.executeSQLScript(dbscriptName);
            this.conn.commit();
            log.info((Object)" WSO2 Product Migration Service Task : Identity DB Migration script executed successfully.");
        }
        catch (Exception e) {
            log.error((Object)e);
            if (!this.isContinueOnError()) {
                throw new MigrationClientException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Failed to close database statement.", (Throwable)e);
            }
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Failed to close database connection.", (Throwable)e);
            }
        }
    }

    private void executeSQLScript(String dbscriptName) throws Exception {
        String databaseType = DatabaseCreator.getDatabaseType((Connection)this.conn);
        boolean keepFormat = false;
        if ("oracle".equals(databaseType)) {
            this.delimiter = "/";
        } else if ("db2".equals(databaseType)) {
            this.delimiter = "/";
        } else if ("openedge".equals(databaseType)) {
            this.delimiter = "/";
            keepFormat = true;
        }
        StringBuffer sql = new StringBuffer();
        try (BufferedReader reader = null;){
            String line;
            FileInputStream is = new FileInputStream(dbscriptName);
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                String token;
                StringTokenizer st;
                line = line.trim();
                if (!keepFormat && (line.startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken()))) continue;
                if ("oracle".equals(databaseType) && line.contains("databasename :=")) {
                    if (dbscriptName.contains("identity")) {
                        line = "databasename := '" + ISMigrationServiceDataHolder.getIdentityOracleUser() + "';";
                    } else if (dbscriptName.contains("um")) {
                        line = "databasename := '" + ISMigrationServiceDataHolder.getUmOracleUser() + "';";
                    }
                }
                sql.append(keepFormat ? "\n" : " ").append(line);
                if (!keepFormat && line.indexOf("--") >= 0) {
                    sql.append("\n");
                }
                if (!DatabaseCreator.checkStringBufferEndsWith((StringBuffer)sql, (String)this.delimiter)) continue;
                this.executeSQL(sql.substring(0, sql.length() - this.delimiter.length()));
                sql.replace(0, sql.length(), "");
            }
            if (sql.length() > 0) {
                this.executeSQL(sql.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQL(String sql) throws Exception {
        block20: {
            if ("".equals(sql.trim())) {
                return;
            }
            ResultSet resultSet = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SQL : " + sql));
                }
                int updateCount = 0;
                int updateCountTotal = 0;
                boolean ret = this.statement.execute(sql);
                updateCount = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
                do {
                    if (!ret && updateCount != -1) {
                        updateCountTotal += updateCount;
                    }
                    if (!(ret = this.statement.getMoreResults())) continue;
                    updateCount = this.statement.getUpdateCount();
                    resultSet = this.statement.getResultSet();
                } while (ret);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(sql + " : " + updateCountTotal + " rows affected"));
                }
                for (SQLWarning warning = this.conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    log.debug((Object)(warning + " sql warning"));
                }
                this.conn.clearWarnings();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("X0Y32") || e.getSQLState().equals("42710")) {
                    if (log.isDebugEnabled()) {
                        log.info((Object)"Table Already Exists. Hence, skipping table creation");
                    }
                    break block20;
                }
                throw new Exception("Error occurred while executing : " + sql, e);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Error occurred while closing result set.", (Throwable)e);
                    }
                }
            }
        }
    }
}

