/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v510.migrator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class IdentityDataCleaner
extends Migrator {
    private static final Log log = LogFactory.getLog(IdentityDataCleaner.class);

    @Override
    public void migrate() throws MigrationClientException {
        this.cleanIdentityData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanIdentityData() throws MigrationClientException {
        log.info((Object)"MIGRATION-LOGS >> Going to start : cleanIdentityData.");
        Connection identityConnection = null;
        PreparedStatement selectFromAccessTokenPS = null;
        PreparedStatement selectDuplicateUserNamePS = null;
        PreparedStatement deleteDuplicateUserNamePS = null;
        PreparedStatement deleteDeleteRow = null;
        ResultSet accessTokenRS = null;
        ResultSet duplicateUserNameRS = null;
        try {
            block18: {
                block17: {
                    identityConnection = this.getDataSource().getConnection();
                    identityConnection.setAutoCommit(false);
                    try {
                        deleteDeleteRow = identityConnection.prepareStatement("delete from IDN_OAUTH2_ACCESS_TOKEN where AUTHZ_USER like '% @%' AND TOKEN_STATE='ACTIVE'");
                        int rowCount = deleteDeleteRow.executeUpdate();
                        log.info((Object)("MIGRATION-LOGS >> Deleting " + rowCount + " rows  having spaces in user name in IDN_OAUTH2_ACCESS_TOKEN"));
                        log.info((Object)("MIGRATION-LOGS >> Executed query : " + deleteDeleteRow.toString()));
                    }
                    catch (Exception e) {
                        log.error((Object)"MIGRATION-ERROR-LOGS-009 >> Error while executing the migration.", (Throwable)e);
                        if (this.isContinueOnError()) break block17;
                        throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                    }
                }
                try {
                    selectFromAccessTokenPS = identityConnection.prepareStatement("select CONSUMER_KEY,AUTHZ_USER,USER_TYPE,TOKEN_SCOPE, ACCESS_TOKEN from IDN_OAUTH2_ACCESS_TOKEN where AUTHZ_USER not like '%@%' AND TOKEN_STATE='ACTIVE'");
                    accessTokenRS = selectFromAccessTokenPS.executeQuery();
                    log.info((Object)("MIGRATION-LOGS >> Executed query : " + selectFromAccessTokenPS.toString()));
                    selectDuplicateUserNamePS = identityConnection.prepareStatement("select ACCESS_TOKEN from IDN_OAUTH2_ACCESS_TOKEN where CONSUMER_KEY=? AND AUTHZ_USER=? AND USER_TYPE=? AND TOKEN_SCOPE=? AND TOKEN_STATE='ACTIVE'");
                    deleteDuplicateUserNamePS = identityConnection.prepareStatement("DELETE FROM IDN_OAUTH2_ACCESS_TOKEN WHERE ACCESS_TOKEN=?");
                    while (accessTokenRS.next()) {
                        selectDuplicateUserNamePS.setString(1, accessTokenRS.getString("CONSUMER_KEY"));
                        selectDuplicateUserNamePS.setString(2, UserCoreUtil.addTenantDomainToEntry((String)accessTokenRS.getString("AUTHZ_USER"), (String)"carbon.super"));
                        selectDuplicateUserNamePS.setString(3, accessTokenRS.getString("USER_TYPE"));
                        selectDuplicateUserNamePS.setString(4, accessTokenRS.getString("TOKEN_SCOPE"));
                        duplicateUserNameRS = selectDuplicateUserNamePS.executeQuery();
                        if (!duplicateUserNameRS.next()) continue;
                        log.info((Object)("MIGRATION-LOGS >> deleting corrupted row : ACCESS_TOKEN-" + accessTokenRS.getString("ACCESS_TOKEN")));
                        deleteDuplicateUserNamePS.setString(1, accessTokenRS.getString("ACCESS_TOKEN"));
                        log.info((Object)deleteDuplicateUserNamePS.toString());
                        log.info((Object)deleteDuplicateUserNamePS);
                        int i = deleteDuplicateUserNamePS.executeUpdate();
                        log.info((Object)("MIGRATION-LOGS >> Deleting " + i));
                        log.info((Object)("MIGRATION-LOGS >> Executed query : " + deleteDuplicateUserNamePS.toString()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"MIGRATION-ERROR-LOGS-010 >> Error while executing the migration.", (Throwable)e);
                    if (this.isContinueOnError()) break block18;
                    throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                }
            }
            identityConnection.commit();
            try {
                IdentityDatabaseUtil.closeResultSet((ResultSet)accessTokenRS);
                IdentityDatabaseUtil.closeResultSet(duplicateUserNameRS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)selectFromAccessTokenPS);
                IdentityDatabaseUtil.closeStatement(selectDuplicateUserNamePS);
                IdentityDatabaseUtil.closeStatement(deleteDuplicateUserNamePS);
                IdentityDatabaseUtil.closeConnection((Connection)identityConnection);
            }
            catch (Exception e) {}
        }
        catch (SQLException e) {
            log.warn((Object)"MIGRATION-LOGS >> Error while cleaning identity data ", (Throwable)e);
            if (!this.isContinueOnError()) {
                throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
            }
        }
        finally {
            try {
                IdentityDatabaseUtil.closeResultSet(accessTokenRS);
                IdentityDatabaseUtil.closeResultSet(duplicateUserNameRS);
                IdentityDatabaseUtil.closeStatement(selectFromAccessTokenPS);
                IdentityDatabaseUtil.closeStatement(selectDuplicateUserNamePS);
                IdentityDatabaseUtil.closeStatement(deleteDuplicateUserNamePS);
                IdentityDatabaseUtil.closeConnection((Connection)identityConnection);
            }
            catch (Exception exception) {}
        }
        log.info((Object)"MIGRATION-LOGS >> Done : cleanIdentityData.");
    }
}

