/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v510.migrator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.is.migration.internal.ISMigrationServiceDataHolder;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class IdentityDataMigrator
extends Migrator {
    private static final Log log = LogFactory.getLog(IdentityDataMigrator.class);

    @Override
    public void migrate() throws MigrationClientException {
        this.migrateIdentityData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void migrateIdentityData() throws MigrationClientException {
        block84: {
            ResultSet selectConsumerAppsRS;
            ResultSet selectIdnAssociatedIdRS;
            ResultSet authzCodeRS;
            ResultSet accessTokenRS;
            PreparedStatement updateConsumerAppsPS;
            PreparedStatement selectConsumerAppsPS;
            PreparedStatement updateIdnAssociatedIdPS;
            PreparedStatement selectIdnAssociatedIdPS;
            PreparedStatement updateUserNameAuthorizationCodePS;
            PreparedStatement selectFromAuthorizationCodePS;
            PreparedStatement updateUserNamePS;
            PreparedStatement insertTokenIdPS;
            PreparedStatement insertTokenScopeHashPS;
            PreparedStatement insertScopeAssociationPS;
            PreparedStatement selectFromAccessTokenPS;
            Connection identityConnection;
            block81: {
                block80: {
                    int tenantId;
                    String userDomain;
                    String username;
                    block75: {
                        block71: {
                            log.info((Object)"MIGRATION-LOGS >> Going to start : migrateIdentityData.");
                            identityConnection = null;
                            selectFromAccessTokenPS = null;
                            insertScopeAssociationPS = null;
                            insertTokenScopeHashPS = null;
                            insertTokenIdPS = null;
                            updateUserNamePS = null;
                            selectFromAuthorizationCodePS = null;
                            updateUserNameAuthorizationCodePS = null;
                            selectIdnAssociatedIdPS = null;
                            updateIdnAssociatedIdPS = null;
                            selectConsumerAppsPS = null;
                            updateConsumerAppsPS = null;
                            accessTokenRS = null;
                            authzCodeRS = null;
                            selectIdnAssociatedIdRS = null;
                            selectConsumerAppsRS = null;
                            identityConnection = this.getDataSource().getConnection();
                            identityConnection.setAutoCommit(false);
                            try {
                                selectConsumerAppsPS = identityConnection.prepareStatement("SELECT ID, USERNAME, USER_DOMAIN FROM IDN_OAUTH_CONSUMER_APPS");
                                updateConsumerAppsPS = identityConnection.prepareStatement("UPDATE IDN_OAUTH_CONSUMER_APPS SET USERNAME=?, USER_DOMAIN=? WHERE ID=?");
                                selectConsumerAppsRS = selectConsumerAppsPS.executeQuery();
                                log.info((Object)("MIGRATION-LOGS >> Executed query : " + selectConsumerAppsPS.toString()));
                                boolean isConsumerAppsAvail = false;
                                while (selectConsumerAppsRS.next()) {
                                    int id = selectConsumerAppsRS.getInt("ID");
                                    String username2 = selectConsumerAppsRS.getString("USERNAME");
                                    String userDomainFromDB = selectConsumerAppsRS.getString("USER_DOMAIN");
                                    try {
                                        if (userDomainFromDB != null) continue;
                                        String userDomain2 = UserCoreUtil.extractDomainFromName((String)username2);
                                        username2 = UserCoreUtil.removeDomainFromName((String)username2);
                                        updateConsumerAppsPS.setString(1, username2);
                                        updateConsumerAppsPS.setString(2, userDomain2);
                                        updateConsumerAppsPS.setInt(3, id);
                                        if (this.isBatchUpdate()) {
                                            isConsumerAppsAvail = true;
                                            updateConsumerAppsPS.addBatch();
                                        } else {
                                            updateConsumerAppsPS.executeUpdate();
                                            log.info((Object)("MIGRATION-LOGS >> Executed query : " + updateConsumerAppsPS.toString()));
                                        }
                                        if (!log.isDebugEnabled()) continue;
                                        log.debug((Object)("MIGRATION-LOGS >> migrating consumer app :" + id));
                                    }
                                    catch (Exception e) {
                                        log.error((Object)"MIGRATION-ERROR-LOGS-011 >> Error while executing the migration.", (Throwable)e);
                                        if (this.isContinueOnError()) continue;
                                        throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                                    }
                                }
                                if (isConsumerAppsAvail && this.isBatchUpdate()) {
                                    int[] ints = updateConsumerAppsPS.executeBatch();
                                    log.info((Object)("MIGRATION-LOGS >> Executed query : " + updateConsumerAppsPS.toString()));
                                }
                            }
                            catch (Exception e) {
                                log.error((Object)"MIGRATION-ERROR-LOGS-012 >> Error while executing the migration.", (Throwable)e);
                                if (this.isContinueOnError()) break block71;
                                throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                            }
                        }
                        String selectFromAccessToken = "SELECT ACCESS_TOKEN, TOKEN_SCOPE, AUTHZ_USER, TOKEN_ID FROM IDN_OAUTH2_ACCESS_TOKEN";
                        selectFromAccessTokenPS = identityConnection.prepareStatement(selectFromAccessToken);
                        String insertScopeAssociation = "INSERT INTO IDN_OAUTH2_ACCESS_TOKEN_SCOPE (TOKEN_ID, TOKEN_SCOPE) VALUES (?, ?)";
                        insertScopeAssociationPS = identityConnection.prepareStatement(insertScopeAssociation);
                        String insertTokenScopeHash = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_SCOPE_HASH=? WHERE ACCESS_TOKEN=?";
                        insertTokenScopeHashPS = identityConnection.prepareStatement(insertTokenScopeHash);
                        String insertTokenId = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET TOKEN_ID=? WHERE ACCESS_TOKEN=?";
                        insertTokenIdPS = identityConnection.prepareStatement(insertTokenId);
                        String updateUserName = "UPDATE IDN_OAUTH2_ACCESS_TOKEN SET AUTHZ_USER=?, TENANT_ID=?, USER_DOMAIN=?, SUBJECT_IDENTIFIER=? WHERE ACCESS_TOKEN=?";
                        updateUserNamePS = identityConnection.prepareStatement(updateUserName);
                        try {
                            block78: {
                                block77: {
                                    block76: {
                                        accessTokenRS = selectFromAccessTokenPS.executeQuery();
                                        log.info((Object)("MIGRATION-LOGS >> Executed query : " + selectFromAccessTokenPS.toString()));
                                        while (accessTokenRS.next()) {
                                            String accessToken = null;
                                            try {
                                                String[] scopes;
                                                String tokenId;
                                                String scopeString;
                                                block74: {
                                                    block73: {
                                                        String authzUser;
                                                        block72: {
                                                            accessToken = accessTokenRS.getString("ACCESS_TOKEN");
                                                            scopeString = accessTokenRS.getString("TOKEN_SCOPE");
                                                            authzUser = accessTokenRS.getString("AUTHZ_USER");
                                                            String tokenIdFromDB = accessTokenRS.getString("TOKEN_ID");
                                                            if (tokenIdFromDB != null) continue;
                                                            tokenId = UUID.randomUUID().toString();
                                                            username = UserCoreUtil.removeDomainFromName((String)MultitenantUtils.getTenantAwareUsername((String)authzUser));
                                                            userDomain = UserCoreUtil.extractDomainFromName((String)authzUser);
                                                            tenantId = ISMigrationServiceDataHolder.getRealmService().getTenantManager().getTenantId(MultitenantUtils.getTenantDomain((String)authzUser));
                                                            try {
                                                                insertTokenIdPS.setString(1, tokenId);
                                                                insertTokenIdPS.setString(2, accessToken);
                                                                if (this.isBatchUpdate()) {
                                                                    insertTokenIdPS.addBatch();
                                                                } else {
                                                                    insertTokenIdPS.executeUpdate();
                                                                    log.info((Object)("MIGRATION-LOGS >> Executed query : " + insertTokenIdPS.toString()));
                                                                }
                                                            }
                                                            catch (Exception e) {
                                                                log.error((Object)"MIGRATION-ERROR-LOGS-013 >> Error while executing the migration.", (Throwable)e);
                                                                if (this.isContinueOnError()) break block72;
                                                                throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                                                            }
                                                        }
                                                        try {
                                                            updateUserNamePS.setString(1, username);
                                                            updateUserNamePS.setInt(2, tenantId);
                                                            updateUserNamePS.setString(3, userDomain);
                                                            updateUserNamePS.setString(4, authzUser);
                                                            updateUserNamePS.setString(5, accessToken);
                                                            if (this.isBatchUpdate()) {
                                                                updateUserNamePS.addBatch();
                                                            } else {
                                                                updateConsumerAppsPS.executeUpdate();
                                                                log.info((Object)("MIGRATION-LOGS >> Executed query : " + updateConsumerAppsPS.toString()));
                                                            }
                                                        }
                                                        catch (Exception e) {
                                                            log.error((Object)"MIGRATION-ERROR-LOGS-014 >> Error while executing the migration.", (Throwable)e);
                                                            if (this.isContinueOnError()) break block73;
                                                            throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                                                        }
                                                    }
                                                    try {
                                                        insertTokenScopeHashPS.setString(1, DigestUtils.md5Hex((String)scopeString));
                                                        insertTokenScopeHashPS.setString(2, accessToken);
                                                        if (this.isBatchUpdate()) {
                                                            insertTokenScopeHashPS.addBatch();
                                                        } else {
                                                            insertTokenScopeHashPS.executeUpdate();
                                                            log.info((Object)("MIGRATION-LOGS >> Executed query : " + insertTokenScopeHashPS.toString()));
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        log.error((Object)"MIGRATION-ERROR-LOGS-015 >> Error while executing the migration.", (Throwable)e);
                                                        if (this.isContinueOnError()) break block74;
                                                        throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                                                    }
                                                }
                                                if (log.isDebugEnabled()) {
                                                    log.debug((Object)("MIGRATION-LOGS >> migrating access token : " + accessToken));
                                                }
                                                if (scopeString == null) continue;
                                                for (String scope : scopes = scopeString.split(" ")) {
                                                    try {
                                                        insertScopeAssociationPS.setString(1, tokenId);
                                                        insertScopeAssociationPS.setString(2, scope);
                                                        if (this.isBatchUpdate()) {
                                                            insertScopeAssociationPS.addBatch();
                                                            continue;
                                                        }
                                                        insertScopeAssociationPS.executeUpdate();
                                                        log.info((Object)("MIGRATION-LOGS >> Executed query : " + insertScopeAssociationPS.toString()));
                                                    }
                                                    catch (Exception e) {
                                                        log.error((Object)"MIGRATION-ERROR-LOGS-016 >> Error while executing the migration.", (Throwable)e);
                                                        if (this.isContinueOnError()) continue;
                                                        throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                                                    }
                                                }
                                            }
                                            catch (UserStoreException e) {
                                                log.error((Object)"MIGRATION-ERROR-LOGS-017 >> Error while executing the migration.", (Throwable)e);
                                                if (this.isContinueOnError()) continue;
                                                throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                                            }
                                        }
                                        if (!this.isBatchUpdate()) break block75;
                                        try {
                                            insertTokenIdPS.executeBatch();
                                            log.info((Object)("MIGRATION-LOGS >> Executed query : " + insertTokenIdPS.toString()));
                                        }
                                        catch (SQLException e) {
                                            log.error((Object)"MIGRATION-ERROR-LOGS-018 >> Error while executing the migration.", (Throwable)e);
                                            if (this.isContinueOnError()) break block76;
                                            throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                                        }
                                    }
                                    try {
                                        log.info((Object)("MIGRATION-LOGS >> Started : " + insertScopeAssociationPS.toString()));
                                        insertScopeAssociationPS.executeBatch();
                                        log.info((Object)("MIGRATION-LOGS >> Executed query : " + insertScopeAssociationPS.toString()));
                                    }
                                    catch (SQLException e) {
                                        log.error((Object)"MIGRATION-ERROR-LOGS-019 >> Error while executing the migration.", (Throwable)e);
                                        if (this.isContinueOnError()) break block77;
                                        throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                                    }
                                }
                                try {
                                    updateUserNamePS.executeBatch();
                                    log.info((Object)("MIGRATION-LOGS >> Executed query : " + updateUserNamePS.toString()));
                                }
                                catch (SQLException e) {
                                    log.error((Object)"MIGRATION-ERROR-LOGS-020 >> Error while executing the migration.", (Throwable)e);
                                    if (this.isContinueOnError()) break block78;
                                    throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                                }
                            }
                            try {
                                insertTokenScopeHashPS.executeBatch();
                                log.info((Object)("MIGRATION-LOGS >> Executed query : " + insertTokenScopeHashPS.toString()));
                            }
                            catch (SQLException e) {
                                log.error((Object)"MIGRATION-ERROR-LOGS-021 >> Error while executing the migration.", (Throwable)e);
                                if (!this.isContinueOnError()) {
                                    throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"MIGRATION-ERROR-LOGS-022 >> Error while executing the migration.", (Throwable)e);
                            if (this.isContinueOnError()) break block75;
                            throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                        }
                    }
                    String selectFromAuthorizationCode = "SELECT AUTHORIZATION_CODE, AUTHZ_USER, USER_DOMAIN FROM IDN_OAUTH2_AUTHORIZATION_CODE";
                    selectFromAuthorizationCodePS = identityConnection.prepareStatement(selectFromAuthorizationCode);
                    String updateUserNameAuthorizationCode = "UPDATE IDN_OAUTH2_AUTHORIZATION_CODE SET AUTHZ_USER=?, TENANT_ID=?, USER_DOMAIN=?, CODE_ID=?, SUBJECT_IDENTIFIER=? WHERE AUTHORIZATION_CODE=?";
                    updateUserNameAuthorizationCodePS = identityConnection.prepareStatement(updateUserNameAuthorizationCode);
                    try {
                        authzCodeRS = selectFromAuthorizationCodePS.executeQuery();
                        log.info((Object)("MIGRATION-LOGS >> Executed query : " + authzCodeRS.toString()));
                        while (authzCodeRS.next()) {
                            String authorizationCode = null;
                            try {
                                block79: {
                                    authorizationCode = authzCodeRS.getString("AUTHORIZATION_CODE");
                                    String authzUser = authzCodeRS.getString("AUTHZ_USER");
                                    String userDomainFromDB = authzCodeRS.getString("USER_DOMAIN");
                                    if (userDomainFromDB != null) continue;
                                    username = UserCoreUtil.removeDomainFromName((String)MultitenantUtils.getTenantAwareUsername((String)authzUser));
                                    userDomain = UserCoreUtil.extractDomainFromName((String)authzUser);
                                    tenantId = ISMigrationServiceDataHolder.getRealmService().getTenantManager().getTenantId(MultitenantUtils.getTenantDomain((String)authzUser));
                                    try {
                                        updateUserNameAuthorizationCodePS.setString(1, username);
                                        updateUserNameAuthorizationCodePS.setInt(2, tenantId);
                                        updateUserNameAuthorizationCodePS.setString(3, userDomain);
                                        updateUserNameAuthorizationCodePS.setString(4, UUID.randomUUID().toString());
                                        updateUserNameAuthorizationCodePS.setString(5, authzUser);
                                        updateUserNameAuthorizationCodePS.setString(6, authorizationCode);
                                        if (this.isBatchUpdate()) {
                                            updateUserNameAuthorizationCodePS.addBatch();
                                        } else {
                                            updateUserNameAuthorizationCodePS.executeUpdate();
                                            log.info((Object)("MIGRATION-LOGS >> Executed query : " + updateUserNameAuthorizationCodePS.toString()));
                                        }
                                    }
                                    catch (Exception e) {
                                        log.error((Object)"MIGRATION-ERROR-LOGS-023 >> Error while executing the migration.", (Throwable)e);
                                        if (this.isContinueOnError()) break block79;
                                        throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                                    }
                                }
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("MIGRATION-LOGS >> migrating authorization code : " + authorizationCode));
                            }
                            catch (UserStoreException e) {
                                log.warn((Object)("MIGRATION-LOGS >> Error while migrating authorization code : " + authorizationCode));
                                if (this.isContinueOnError()) continue;
                                throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                            }
                        }
                        if (this.isBatchUpdate()) {
                            updateUserNameAuthorizationCodePS.executeBatch();
                            log.info((Object)("MIGRATION-LOGS >> Executed query : " + updateUserNameAuthorizationCodePS.toString()));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"MIGRATION-ERROR-LOGS-024 >> Error while executing the migration.", (Throwable)e);
                        if (this.isContinueOnError()) break block80;
                        throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                    }
                }
                String selectIdnAssociatedId = "SELECT ID, USER_NAME, DOMAIN_NAME FROM IDN_ASSOCIATED_ID";
                selectIdnAssociatedIdPS = identityConnection.prepareStatement(selectIdnAssociatedId);
                try {
                    selectIdnAssociatedIdRS = selectIdnAssociatedIdPS.executeQuery();
                    updateIdnAssociatedIdPS = identityConnection.prepareStatement("UPDATE IDN_ASSOCIATED_ID SET DOMAIN_NAME=?, USER_NAME=? WHERE ID=?");
                    while (selectIdnAssociatedIdRS.next()) {
                        int id = selectIdnAssociatedIdRS.getInt("ID");
                        String username = selectIdnAssociatedIdRS.getString("USER_NAME");
                        String userDomainFromDB = selectIdnAssociatedIdRS.getString("DOMAIN_NAME");
                        if (userDomainFromDB != null) continue;
                        try {
                            updateIdnAssociatedIdPS.setString(1, UserCoreUtil.extractDomainFromName((String)username));
                            updateIdnAssociatedIdPS.setString(2, UserCoreUtil.removeDomainFromName((String)username));
                            updateIdnAssociatedIdPS.setInt(3, id);
                            if (this.isBatchUpdate()) {
                                updateIdnAssociatedIdPS.addBatch();
                            } else {
                                updateIdnAssociatedIdPS.executeUpdate();
                                log.info((Object)("MIGRATION-LOGS >> Executed query : " + updateIdnAssociatedIdPS.toString()));
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("MIGRATION-LOGS >> migrating IdnAssociatedId : " + id));
                        }
                        catch (Exception e) {
                            log.error((Object)"MIGRATION-ERROR-LOGS-024 >> Error while executing the migration.", (Throwable)e);
                            if (this.isContinueOnError()) continue;
                            throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                        }
                    }
                    if (this.isBatchUpdate()) {
                        updateIdnAssociatedIdPS.executeBatch();
                        log.info((Object)("MIGRATION-LOGS >> Executed query : " + updateIdnAssociatedIdPS.toString()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"MIGRATION-ERROR-LOGS-025 >> Error while executing the migration.", (Throwable)e);
                    if (this.isContinueOnError()) break block81;
                    throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                }
            }
            identityConnection.commit();
            try {
                IdentityDatabaseUtil.closeResultSet((ResultSet)accessTokenRS);
                IdentityDatabaseUtil.closeResultSet((ResultSet)authzCodeRS);
                IdentityDatabaseUtil.closeResultSet((ResultSet)selectIdnAssociatedIdRS);
                IdentityDatabaseUtil.closeResultSet((ResultSet)selectConsumerAppsRS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)selectFromAccessTokenPS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)insertScopeAssociationPS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)insertTokenIdPS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)updateUserNamePS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)insertTokenScopeHashPS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)updateUserNameAuthorizationCodePS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)selectFromAuthorizationCodePS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)selectIdnAssociatedIdPS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)updateIdnAssociatedIdPS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)selectConsumerAppsPS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)updateConsumerAppsPS);
                IdentityDatabaseUtil.closeConnection((Connection)identityConnection);
            }
            catch (Exception e) {
                log.error((Object)"MIGRATION-ERROR-LOGS-028 >> Error while executing the migration.", (Throwable)e);
            }
            break block84;
            catch (SQLException e) {
                block82: {
                    IdentityDatabaseUtil.rollBack((Connection)identityConnection);
                    log.error((Object)"MIGRATION-ERROR-LOGS--026 >> Error while executing the migration.", (Throwable)e);
                    if (this.isContinueOnError()) break block82;
                    throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                }
                try {
                    IdentityDatabaseUtil.closeResultSet(accessTokenRS);
                    IdentityDatabaseUtil.closeResultSet(authzCodeRS);
                    IdentityDatabaseUtil.closeResultSet(selectIdnAssociatedIdRS);
                    IdentityDatabaseUtil.closeResultSet((ResultSet)selectConsumerAppsRS);
                    IdentityDatabaseUtil.closeStatement((PreparedStatement)selectFromAccessTokenPS);
                    IdentityDatabaseUtil.closeStatement(insertScopeAssociationPS);
                    IdentityDatabaseUtil.closeStatement(insertTokenIdPS);
                    IdentityDatabaseUtil.closeStatement(updateUserNamePS);
                    IdentityDatabaseUtil.closeStatement(insertTokenScopeHashPS);
                    IdentityDatabaseUtil.closeStatement(updateUserNameAuthorizationCodePS);
                    IdentityDatabaseUtil.closeStatement(selectFromAuthorizationCodePS);
                    IdentityDatabaseUtil.closeStatement(selectIdnAssociatedIdPS);
                    IdentityDatabaseUtil.closeStatement(updateIdnAssociatedIdPS);
                    IdentityDatabaseUtil.closeStatement((PreparedStatement)selectConsumerAppsPS);
                    IdentityDatabaseUtil.closeStatement((PreparedStatement)updateConsumerAppsPS);
                    IdentityDatabaseUtil.closeConnection((Connection)identityConnection);
                }
                catch (Exception e2) {
                    log.error((Object)"MIGRATION-ERROR-LOGS-028 >> Error while executing the migration.", (Throwable)e2);
                }
            }
            catch (Exception e2) {
                block83: {
                    log.error((Object)"MIGRATION-ERROR-LOGS-027 >> Error while executing the migration.", (Throwable)e2);
                    if (this.isContinueOnError()) break block83;
                    throw new MigrationClientException("Error while executing the migration.", (Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            try {
                                IdentityDatabaseUtil.closeResultSet(accessTokenRS);
                                IdentityDatabaseUtil.closeResultSet(authzCodeRS);
                                IdentityDatabaseUtil.closeResultSet(selectIdnAssociatedIdRS);
                                IdentityDatabaseUtil.closeResultSet(selectConsumerAppsRS);
                                IdentityDatabaseUtil.closeStatement(selectFromAccessTokenPS);
                                IdentityDatabaseUtil.closeStatement(insertScopeAssociationPS);
                                IdentityDatabaseUtil.closeStatement(insertTokenIdPS);
                                IdentityDatabaseUtil.closeStatement(updateUserNamePS);
                                IdentityDatabaseUtil.closeStatement(insertTokenScopeHashPS);
                                IdentityDatabaseUtil.closeStatement(updateUserNameAuthorizationCodePS);
                                IdentityDatabaseUtil.closeStatement(selectFromAuthorizationCodePS);
                                IdentityDatabaseUtil.closeStatement(selectIdnAssociatedIdPS);
                                IdentityDatabaseUtil.closeStatement(updateIdnAssociatedIdPS);
                                IdentityDatabaseUtil.closeStatement((PreparedStatement)selectConsumerAppsPS);
                                IdentityDatabaseUtil.closeStatement((PreparedStatement)updateConsumerAppsPS);
                                IdentityDatabaseUtil.closeConnection((Connection)identityConnection);
                            }
                            catch (Exception e3) {
                                log.error((Object)"MIGRATION-ERROR-LOGS-028 >> Error while executing the migration.", (Throwable)e3);
                            }
                            throw throwable;
                        }
                    }
                }
                try {
                    IdentityDatabaseUtil.closeResultSet(accessTokenRS);
                    IdentityDatabaseUtil.closeResultSet(authzCodeRS);
                    IdentityDatabaseUtil.closeResultSet(selectIdnAssociatedIdRS);
                    IdentityDatabaseUtil.closeResultSet((ResultSet)selectConsumerAppsRS);
                    IdentityDatabaseUtil.closeStatement(selectFromAccessTokenPS);
                    IdentityDatabaseUtil.closeStatement(insertScopeAssociationPS);
                    IdentityDatabaseUtil.closeStatement(insertTokenIdPS);
                    IdentityDatabaseUtil.closeStatement(updateUserNamePS);
                    IdentityDatabaseUtil.closeStatement(insertTokenScopeHashPS);
                    IdentityDatabaseUtil.closeStatement(updateUserNameAuthorizationCodePS);
                    IdentityDatabaseUtil.closeStatement(selectFromAuthorizationCodePS);
                    IdentityDatabaseUtil.closeStatement(selectIdnAssociatedIdPS);
                    IdentityDatabaseUtil.closeStatement(updateIdnAssociatedIdPS);
                    IdentityDatabaseUtil.closeStatement((PreparedStatement)selectConsumerAppsPS);
                    IdentityDatabaseUtil.closeStatement((PreparedStatement)updateConsumerAppsPS);
                    IdentityDatabaseUtil.closeConnection((Connection)identityConnection);
                }
                catch (Exception e4) {
                    log.error((Object)"MIGRATION-ERROR-LOGS-028 >> Error while executing the migration.", (Throwable)e4);
                }
            }
        }
        log.info((Object)"MIGRATION-LOGS >> Done : migrateIdentityData.");
    }
}

