/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v510.migrator;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.is.migration.internal.ISMigrationServiceDataHolder;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.Tenant;

public class RegistryDataMigrator
extends Migrator {
    private static final String SAMLSSO_ASSERTION_CONSUMER_URL = "SAMLSSOAssertionConsumerURL";
    private static final String LOGOUT_URL = "logoutURL";
    private static final String DEFAULT_CONST = "[default]";
    private static final Log log = LogFactory.getLog(RegistryDataMigrator.class);

    @Override
    public void migrate() throws MigrationClientException {
        this.migrateRegistryData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateRegistryData() throws MigrationClientException {
        block17: {
            block16: {
                log.info((Object)"MIGRATION-LOGS >> Going to start : migrateRegistryData.");
                try {
                    this.migrateSAMLConfiguration();
                    log.info((Object)"MIGRATION-LOGS >> SAML Service Provider details are migrated successfully for tenant : carbon.super");
                }
                catch (Exception e) {
                    log.error((Object)"MIGRATION-ERROR-LOGS-039 >> Error while migrating registry data for tenant : carbon.super", (Throwable)e);
                    if (this.isContinueOnError()) break block16;
                    throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                }
            }
            try {
                Tenant[] tenants;
                for (Tenant tenant : tenants = ISMigrationServiceDataHolder.getRealmService().getTenantManager().getAllTenants()) {
                    try {
                        PrivilegedCarbonContext.startTenantFlow();
                        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                        carbonContext.setTenantId(tenant.getId());
                        carbonContext.setTenantDomain(tenant.getDomain());
                        IdentityTenantUtil.getTenantRegistryLoader().loadTenantRegistry(tenant.getId());
                        this.migrateSAMLConfiguration();
                        log.info((Object)("MIGRATION-LOGS >> SAML Service Provider details are migrated successfully for tenant : " + tenant.getDomain()));
                    }
                    catch (Exception e) {
                        log.error((Object)"MIGRATION-ERROR-LOGS-040 >> Error while executing the migration.", (Throwable)e);
                        if (this.isContinueOnError()) continue;
                        throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                    }
                    finally {
                        try {
                            PrivilegedCarbonContext.endTenantFlow();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"MIGRATION-ERROR-LOGS-041 >> Error while migrating registry data ", (Throwable)e);
                if (this.isContinueOnError()) break block17;
                throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
            }
        }
        log.info((Object)"MIGRATION-LOGS >> Done : migrateRegistryData.");
    }

    private void migrateSAMLConfiguration() throws MigrationClientException {
        block13: {
            log.info((Object)"MIGRATION-LOGS >> Going to start : migrateSAMLConfiguration.");
            UserRegistry registry = (UserRegistry)PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
            try {
                String[] providers;
                if (registry.resourceExists("/repository/identity/SAMLSSO/") && (providers = (String[])registry.get("/repository/identity/SAMLSSO/").getContent()) != null) {
                    for (String provider : providers) {
                        Resource resource = registry.get(provider);
                        if (resource.getProperty("SAMLSSOAssertionConsumerURLs") != null) {
                            List acsUrls = resource.getPropertyValues("SAMLSSOAssertionConsumerURLs");
                            if (acsUrls.size() > 1) {
                                String defaultAcsUrl = null;
                                for (int i = 0; i < acsUrls.size(); ++i) {
                                    if (!((String)acsUrls.get(i)).startsWith(DEFAULT_CONST)) continue;
                                    defaultAcsUrl = ((String)acsUrls.get(i)).substring(((String)acsUrls.get(i)).indexOf("]") + 1);
                                    acsUrls.set(i, defaultAcsUrl);
                                    break;
                                }
                                if (defaultAcsUrl != null) {
                                    resource.setProperty("SAMLSSOAssertionConsumerURLs", acsUrls);
                                    resource.setProperty("DefaultSAMLSSOAssertionConsumerURL", defaultAcsUrl);
                                }
                            } else if (acsUrls.size() == 1) {
                                resource.setProperty("DefaultSAMLSSOAssertionConsumerURL", (String)acsUrls.get(0));
                            }
                        } else if (resource.getProperty(SAMLSSO_ASSERTION_CONSUMER_URL) != null) {
                            String samlssoAssertionConsumerURL = resource.getProperty(SAMLSSO_ASSERTION_CONSUMER_URL);
                            resource.setProperty("SAMLSSOAssertionConsumerURLs", samlssoAssertionConsumerURL);
                            resource.setProperty("DefaultSAMLSSOAssertionConsumerURL", samlssoAssertionConsumerURL);
                            resource.removeProperty(SAMLSSO_ASSERTION_CONSUMER_URL);
                        }
                        String logoutURL = resource.getProperty(LOGOUT_URL);
                        if (logoutURL != null) {
                            resource.setProperty("sloResponseURL", logoutURL);
                            resource.removeProperty(LOGOUT_URL);
                        }
                        registry.put(resource.getPath(), resource);
                    }
                }
            }
            catch (RegistryException e) {
                log.error((Object)"MIGRATION-ERROR-LOGS-042 >> Error while executing the migration.", (Throwable)e);
                if (this.isContinueOnError()) break block13;
                throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
            }
        }
        log.info((Object)"MIGRATION-LOGS >> Done : migrateSAMLConfiguration.");
    }
}

