/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v510.migrator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.is.migration.service.Migrator;
import org.wso2.carbon.is.migration.util.Schema;
import org.wso2.carbon.user.core.UserCoreConstants;

public class UMDataMigrator
extends Migrator {
    private static final Log log = LogFactory.getLog(UMDataMigrator.class);

    @Override
    public void migrate() throws MigrationClientException {
        this.migrateUMData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void migrateUMData() throws MigrationClientException {
        log.info((Object)"MIGRATION-LOGS >> Going to start : migrateUMData.");
        Connection identityConnection = null;
        Connection umConnection = null;
        PreparedStatement selectServiceProviders = null;
        PreparedStatement updateRole = null;
        ResultSet selectServiceProvidersRS = null;
        try {
            identityConnection = this.getDataSource(Schema.IDENTITY.getName()).getConnection();
            umConnection = this.getDataSource().getConnection();
            identityConnection.setAutoCommit(false);
            umConnection.setAutoCommit(false);
            selectServiceProviders = identityConnection.prepareStatement("SELECT APP_NAME, TENANT_ID FROM SP_APP");
            selectServiceProvidersRS = selectServiceProviders.executeQuery();
            updateRole = umConnection.prepareStatement("UPDATE UM_HYBRID_ROLE SET UM_ROLE_NAME=? WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?");
            while (selectServiceProvidersRS.next()) {
                try {
                    String appName = selectServiceProvidersRS.getString("APP_NAME");
                    int tenantId = selectServiceProvidersRS.getInt("TENANT_ID");
                    updateRole.setString(1, "Application" + UserCoreConstants.DOMAIN_SEPARATOR + appName);
                    updateRole.setString(2, appName);
                    updateRole.setInt(3, tenantId);
                    if (this.isBatchUpdate()) {
                        updateRole.addBatch();
                        continue;
                    }
                    updateRole.executeUpdate();
                    log.info((Object)("MIGRATION-LOGS >> Executed query : " + updateRole.toString()));
                }
                catch (Exception e) {
                    log.error((Object)"MIGRATION-ERROR-LOGS-037 >> Error while executing the migration.", (Throwable)e);
                    if (this.isContinueOnError()) continue;
                    throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
                }
            }
            if (this.isBatchUpdate()) {
                updateRole.executeBatch();
                log.info((Object)("MIGRATION-LOGS >> Executed query : " + updateRole.toString()));
            }
            identityConnection.commit();
            umConnection.commit();
            try {
                IdentityDatabaseUtil.closeResultSet((ResultSet)selectServiceProvidersRS);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)selectServiceProviders);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)updateRole);
                IdentityDatabaseUtil.closeConnection((Connection)identityConnection);
                IdentityDatabaseUtil.closeConnection((Connection)umConnection);
            }
            catch (Exception e) {}
        }
        catch (SQLException e) {
            log.error((Object)"MIGRATION-ERROR-LOGS-038 >> Error while executing the migration.", (Throwable)e);
            if (!this.isContinueOnError()) {
                throw new MigrationClientException("Error while executing the migration.", (Throwable)e);
            }
        }
        finally {
            try {
                IdentityDatabaseUtil.closeResultSet(selectServiceProvidersRS);
                IdentityDatabaseUtil.closeStatement(selectServiceProviders);
                IdentityDatabaseUtil.closeStatement(updateRole);
                IdentityDatabaseUtil.closeConnection((Connection)identityConnection);
                IdentityDatabaseUtil.closeConnection((Connection)umConnection);
            }
            catch (Exception exception) {}
        }
        log.info((Object)"MIGRATION-LOGS >> Done : migrateUMData.");
    }
}

