/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v530;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ClaimDialectDAO;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.is.migration.service.v530.bean.Claim;
import org.wso2.carbon.is.migration.service.v530.bean.MappedAttribute;
import org.wso2.carbon.is.migration.service.v530.dao.ClaimDAO;

public class ClaimManager {
    private static Log log = LogFactory.getLog(ClaimDialectDAO.class);
    private ClaimDAO claimDAO = ClaimDAO.getInstance();
    private static ClaimManager claimManager = new ClaimManager();

    private ClaimManager() {
    }

    public static ClaimManager getInstance() {
        return claimManager;
    }

    public void addClaimDialects(List<Claim> claimList, StringBuilder report) throws MigrationClientException {
        log.info((Object)"started adding claim dialects");
        for (Claim claim : claimList) {
            int id = this.claimDAO.getClaimDialect(claim.getDialectURI(), claim.getTenantId());
            if (id != 0) continue;
            this.claimDAO.addClaimDialect(claim.getDialectURI(), claim.getTenantId());
            report.append("\n\n Added claim Dialect : " + claim.getDialectURI() + " in tenant domain :" + IdentityTenantUtil.getTenantDomain((int)claim.getTenantId()));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("\n\n Added claim Dialect : " + claim.getDialectURI() + " in tenant domain :" + IdentityTenantUtil.getTenantDomain((int)claim.getTenantId())));
        }
        report.append("\n\n");
        log.info((Object)"end adding claim dialects");
    }

    public void addLocalClaims(List<Claim> claimCList, StringBuilder report) throws MigrationClientException {
        log.info((Object)"started adding local claims");
        for (Claim claim : claimCList) {
            if (!"http://wso2.org/claims".equalsIgnoreCase(claim.getDialectURI())) continue;
            this.claimDAO.addLocalClaim(claim);
            report.append("\n Added Local Claim: " + claim.getDialectURI() + " in tenant domain :" + IdentityTenantUtil.getTenantDomain((int)claim.getTenantId()) + ", Mapped Attributes :");
            for (MappedAttribute mappedAttribute : claim.getAttributes()) {
                if (mappedAttribute.getDomain() == null) {
                    report.append(" " + IdentityUtil.getPrimaryDomainName() + "/" + mappedAttribute.getAttribute() + " ,");
                    continue;
                }
                report.append(" " + mappedAttribute.getDomain() + "/" + mappedAttribute.getAttribute() + " ,");
            }
            report.append("\n");
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("\n Added Local Claim " + claim.getDialectURI() + " in tenant domain :" + IdentityTenantUtil.getTenantDomain((int)claim.getTenantId()) + "Mapped Attributes :"));
            for (MappedAttribute mappedAttribute : claim.getAttributes()) {
                if (mappedAttribute.getDomain() == null) {
                    log.debug((Object)(" " + IdentityUtil.getPrimaryDomainName() + "/" + mappedAttribute.getAttribute() + " ,"));
                    continue;
                }
                log.debug((Object)(" " + mappedAttribute.getDomain() + "/" + mappedAttribute.getAttribute() + " ,"));
            }
        }
        report.append("\n\n");
    }

    public void addExternalClaim(List<Claim> claims, StringBuilder report) throws MigrationClientException {
        log.info((Object)"started adding external claims");
        for (Claim claim : claims) {
            if ("http://wso2.org/claims".equalsIgnoreCase(claim.getDialectURI())) continue;
            this.claimDAO.addExternalClaim(claim, report);
        }
        log.info((Object)"end adding external claims");
    }
}

