/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v530;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityIOStreamUtils;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.recovery.model.ChallengeQuestion;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.is.migration.internal.ISMigrationServiceDataHolder;
import org.wso2.carbon.registry.api.Collection;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.user.api.Tenant;

public class RegistryDataManager {
    private static RegistryDataManager instance = new RegistryDataManager();
    private static final Log log = LogFactory.getLog(RegistryDataManager.class);
    private static final String SCOPE_RESOURCE_PATH = "/oidc";
    private static final String EMAIL_TEMPLATE_OLD_REG_LOCATION = "/identity/config/emailTemplate";
    private static final String EMAIL_TEMPLATE_NEW_REG_LOCATION_ROOT = "/identity/email/";
    private static final Set<String> TEMPLATE_NAMES = new HashSet<String>(){
        {
            this.add("accountConfirmation");
            this.add("accountDisable");
            this.add("accountEnable");
            this.add("accountIdRecovery");
            this.add("accountUnLock");
            this.add("askPassword");
            this.add("otp");
            this.add("passwordReset");
            this.add("temporaryPassword");
        }
    };
    private static final Map<String, String> PLACEHOLDERS_MAP = new HashMap<String, String>(){
        {
            this.put("\\{first-name\\}", "{{user.claim.givenname}}");
            this.put("\\{user-name\\}", "{{user-name}}");
            this.put("\\{confirmation-code\\}", "{{confirmation-code}}");
            this.put("\\{userstore-domain\\}", "{{userstore-domain}}");
            this.put("\\{url:user-name\\}", "{{url:user-name}}");
            this.put("\\{tenant-domain\\}", "{{tenant-domain}}");
            this.put("\\{temporary-password\\}", "{{temporary-password}}");
        }
    };
    private static final String OLD_CHALLENGE_QUESTIONS_PATH = "/repository/components/org.wso2.carbon.identity.mgt/questionCollection";
    private static final String NEW_CHALLENGE_QUESTIONS_PATH = "/identity/questionCollection";
    private static final String OLD_QUESTION_SET_PROPERTY = "questionSetId";
    private static final String OLD_QUESTION_PROPERTY = "question";
    private static final String DEFAULT_LOCALE = "en_US";
    private static final String TEMPLATE_NAME = "migratedQuestion%d";

    private RegistryDataManager() {
    }

    public static RegistryDataManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateEmailTemplates(boolean migrateActiveTenantsOnly) throws Exception {
        Tenant[] tenants;
        try {
            this.migrateTenantEmailTemplates();
            log.info((Object)"Email templates migrated for tenant : carbon.super");
        }
        catch (Exception e) {
            log.error((Object)"Error while migrating email templates for tenant : carbon.super", (Throwable)e);
        }
        for (Tenant tenant : tenants = ISMigrationServiceDataHolder.getRealmService().getTenantManager().getAllTenants()) {
            if (migrateActiveTenantsOnly && !tenant.isActive()) {
                log.info((Object)("Tenant " + tenant.getDomain() + " is inactive. Skipping Email Templates migration!!!!"));
                continue;
            }
            try {
                this.startTenantFlow(tenant);
                IdentityTenantUtil.getTenantRegistryLoader().loadTenantRegistry(tenant.getId());
                this.migrateTenantEmailTemplates();
                log.info((Object)("Email templates migrated for tenant : " + tenant.getDomain()));
            }
            catch (Exception e) {
                log.error((Object)("Error while migrating email templates for tenant : " + tenant.getDomain()), (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    private void migrateTenantEmailTemplates() throws IdentityException {
        Registry registry = PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
        try {
            if (registry.resourceExists(EMAIL_TEMPLATE_OLD_REG_LOCATION)) {
                Properties properties = registry.get(EMAIL_TEMPLATE_OLD_REG_LOCATION).getProperties();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    Resource resource;
                    if (!TEMPLATE_NAMES.contains(entry.getKey())) {
                        log.info((Object)("Skipping probable invalid template :" + entry.getKey()));
                        continue;
                    }
                    String[] templateParts = ((String)((List)entry.getValue()).get(0)).split("\\|");
                    if (templateParts.length != 3) {
                        log.warn((Object)("Skipping invalid template data. Expected 3 sections, but contains " + templateParts.length));
                    }
                    String newResourcePath = EMAIL_TEMPLATE_NEW_REG_LOCATION_ROOT + entry.getKey().toString().toLowerCase() + "/en_us";
                    String newContent = String.format("[\"%s\",\"%s\",\"%s\"]", this.updateContent(templateParts[0]), this.updateContent(templateParts[1]), this.updateContent(templateParts[2]));
                    if (registry.resourceExists(newResourcePath)) {
                        resource = registry.get(newResourcePath);
                    } else {
                        resource = registry.newResource();
                        resource.addProperty("display", (String)entry.getKey());
                        resource.addProperty("type", (String)entry.getKey());
                        resource.addProperty("emailContentType", "text/plain");
                        resource.addProperty("locale", DEFAULT_LOCALE);
                    }
                    resource.setContent((Object)newContent);
                    resource.setMediaType("tag");
                    registry.put(newResourcePath, resource);
                }
            }
        }
        catch (RegistryException e) {
            throw IdentityException.error((String)"Error while migration registry data", (Throwable)e);
        }
    }

    private String updateContent(String s) {
        for (Map.Entry<String, String> entry : PLACEHOLDERS_MAP.entrySet()) {
            s = s.replaceAll(entry.getKey(), entry.getValue());
        }
        s = s.replaceAll("\n", "\\\\n");
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateChallengeQuestions(boolean migrateActiveTenantsOnly) throws Exception {
        Tenant[] tenants;
        try {
            this.migrateChallengeQuestionsForTenant();
            log.info((Object)"Challenge Questions migrated for tenant : carbon.super");
        }
        catch (Exception e) {
            log.error((Object)"Error while migrating challenge questions for tenant : carbon.super", (Throwable)e);
        }
        for (Tenant tenant : tenants = ISMigrationServiceDataHolder.getRealmService().getTenantManager().getAllTenants()) {
            if (migrateActiveTenantsOnly && !tenant.isActive()) {
                log.info((Object)("Tenant " + tenant.getDomain() + " is inactive. Skipping challenge question migration!!!!"));
                continue;
            }
            try {
                this.startTenantFlow(tenant);
                IdentityTenantUtil.getTenantRegistryLoader().loadTenantRegistry(tenant.getId());
                this.migrateChallengeQuestionsForTenant();
                log.info((Object)("Challenge Questions migrated for tenant : " + tenant.getDomain()));
            }
            catch (Exception e) {
                log.error((Object)("Error while migrating challenge questions for tenant : " + tenant.getDomain()), (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    private void migrateChallengeQuestionsForTenant() throws Exception {
        Registry registry = PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
        try {
            if (registry.resourceExists(OLD_CHALLENGE_QUESTIONS_PATH)) {
                Collection questionCollection = (Collection)registry.get(OLD_CHALLENGE_QUESTIONS_PATH);
                HashMap<String, Integer> countMap = new HashMap<String, Integer>();
                for (String challengeQuestionPath : questionCollection.getChildren()) {
                    Resource oldQuestion = registry.get(challengeQuestionPath);
                    String questionSetId = oldQuestion.getProperty(OLD_QUESTION_SET_PROPERTY);
                    String question = oldQuestion.getProperty(OLD_QUESTION_PROPERTY);
                    int questionCount = countMap.containsKey(questionSetId) ? (Integer)countMap.get(questionSetId) : 1;
                    countMap.put(questionSetId, questionCount + 1);
                    String questionId = String.format(TEMPLATE_NAME, questionCount);
                    ChallengeQuestion challengeQuestion = new ChallengeQuestion(questionSetId, questionId, question, DEFAULT_LOCALE);
                    Resource resource = this.createRegistryResource(challengeQuestion);
                    registry.put(this.getQuestionPath(challengeQuestion), resource);
                }
            }
        }
        catch (RegistryException e) {
            throw IdentityException.error((String)"Error while migration challenge question registry data", (Throwable)e);
        }
    }

    private Resource createRegistryResource(ChallengeQuestion question) throws RegistryException, UnsupportedEncodingException {
        ResourceImpl resource = new ResourceImpl();
        resource.setContent((Object)question.getQuestion().getBytes("UTF-8"));
        resource.addProperty(OLD_QUESTION_SET_PROPERTY, question.getQuestionSetId());
        resource.addProperty("questionId", question.getQuestionId());
        resource.addProperty("locale", question.getLocale());
        resource.setMediaType("tag");
        return resource;
    }

    private String getQuestionPath(ChallengeQuestion challengeQuestion) {
        String questionSetIdUri = challengeQuestion.getQuestionSetId();
        String questionId = challengeQuestion.getQuestionId();
        String questionSetId = Utils.getChallengeSetDirFromUri((String)questionSetIdUri);
        String locale = challengeQuestion.getLocale().toLowerCase();
        return "/identity/questionCollection/" + questionSetId + "/" + questionId + "/" + locale;
    }

    private void startTenantFlow(Tenant tenant) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantId(tenant.getId());
        carbonContext.setTenantDomain(tenant.getDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyOIDCScopeData(boolean migrateActiveTenantsOnly) throws Exception {
        Tenant[] tenants;
        for (Tenant tenant : tenants = ISMigrationServiceDataHolder.getRealmService().getTenantManager().getAllTenants()) {
            if (migrateActiveTenantsOnly && !tenant.isActive()) {
                log.info((Object)("Tenant " + tenant.getDomain() + " is inactive. Skipping copying OIDC Scopes Data !!!!"));
                continue;
            }
            try {
                this.startTenantFlow(tenant);
                IdentityTenantUtil.getTenantRegistryLoader().loadTenantRegistry(tenant.getId());
                this.initiateOIDCScopes();
                log.info((Object)("OIDC Scope data migrated for tenant : " + tenant.getDomain()));
            }
            catch (FileNotFoundException | RegistryException e) {
                log.error((Object)("Error while migrating OIDC Scope data for tenant:  " + tenant.getDomain()), e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    private void initiateOIDCScopes() throws RegistryException, FileNotFoundException, IdentityException {
        Map<String, String> scopes = RegistryDataManager.loadScopeConfigFile();
        Registry registry = PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
        if (!registry.resourceExists(SCOPE_RESOURCE_PATH)) {
            Resource resource = registry.newResource();
            for (Map.Entry<String, String> entry : scopes.entrySet()) {
                resource.setProperty(entry.getKey(), entry.getValue());
            }
            registry.put(SCOPE_RESOURCE_PATH, resource);
        }
    }

    private static Map<String, String> loadScopeConfigFile() throws FileNotFoundException, IdentityException {
        HashMap<String, String> scopes = new HashMap<String, String>();
        String carbonHome = System.getProperty("carbon.home");
        String confXml = Paths.get(carbonHome, "repository", "conf", "identity", "oidc-scope-config.xml").toString();
        File configfile = new File(confXml);
        if (!configfile.exists()) {
            String errMsg = "OIDC scope-claim Configuration File is not present at: " + confXml;
            throw new FileNotFoundException(errMsg);
        }
        XMLStreamReader parser = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configfile);
            parser = XMLInputFactory.newInstance().createXMLStreamReader(stream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement documentElement = builder.getDocumentElement();
            Iterator iterator = documentElement.getChildElements();
            while (iterator.hasNext()) {
                OMElement omElement = (OMElement)iterator.next();
                String configType = omElement.getAttributeValue(new QName("id"));
                scopes.put(configType, RegistryDataManager.loadClaimConfig(omElement));
            }
        }
        catch (XMLStreamException ex) {
            throw IdentityException.error((String)"Error while loading scope config.", (Throwable)ex);
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
                if (stream != null) {
                    IdentityIOStreamUtils.closeInputStream((InputStream)stream);
                }
            }
            catch (XMLStreamException ex) {
                log.error((Object)"Error while closing XML stream", (Throwable)ex);
            }
        }
        return scopes;
    }

    private static String loadClaimConfig(OMElement configElement) {
        StringBuilder claimConfig = new StringBuilder();
        Iterator it = configElement.getChildElements();
        while (it.hasNext()) {
            String commaSeparatedClaimNames;
            OMElement element = (OMElement)it.next();
            if (!"Claim".equals(element.getLocalName()) || !StringUtils.isNotBlank((String)(commaSeparatedClaimNames = element.getText()))) continue;
            claimConfig.append(commaSeparatedClaimNames.trim());
        }
        return claimConfig.toString();
    }
}

