/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v530;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.is.migration.internal.ISMigrationServiceDataHolder;
import org.wso2.carbon.is.migration.service.v530.dao.IdpMetaDataDAO;
import org.wso2.carbon.user.api.Tenant;

public class ResidentIdpMetadataManager {
    private Log log = LogFactory.getLog(ResidentIdpMetadataManager.class);
    private static final Map<String, String> DEFAULT_PROPERTIES = new HashMap<String, String>(){
        {
            this.put("RememberMeTimeout", String.valueOf(20160));
            this.put("SessionIdleTimeout", String.valueOf(15));
            this.put("suspension.notification.account.disable.delay", String.valueOf(90));
            this.put("suspension.notification.delays", "30,45,60,75");
            this.put("suspension.notification.enable", String.valueOf(false));
            this.put("suspension.notification.AlreadyWritten", String.valueOf(true));
            this.put("sso.login.recaptcha.enable", String.valueOf(false));
            this.put("sso.login.recaptcha.on.max.failed.attempts", String.valueOf(3));
            this.put("sso.login.recaptcha.AlreadyWritten", String.valueOf(true));
            this.put("account.lock.handler.On.Failure.Max.Attempts", String.valueOf(2));
            this.put("account.lock.handler.login.fail.timeout.ratio", String.valueOf(2));
            this.put("account.lock.handler.Time", String.valueOf(5));
            this.put("account.lock.handler.enable", String.valueOf(false));
            this.put("account.lock.handler.AlreadyWritten", String.valueOf(true));
            this.put("passwordHistory.count", String.valueOf(5));
            this.put("passwordHistory.enable", String.valueOf(false));
            this.put("passwordHistory.AlreadyWritten", String.valueOf(true));
            this.put("passwordPolicy.pattern", "^((?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#$%&*])).{0,100}$");
            this.put("passwordPolicy.errorMsg", "Password pattern policy violated. Password should contain a digit[0-9], a lower case letter[a-z], an upper case letter[A-Z], one of !@#$%&* characters");
            this.put("passwordPolicy.enable", String.valueOf(false));
            this.put("passwordPolicy.min.length", String.valueOf(6));
            this.put("passwordPolicy.max.length", String.valueOf(12));
            this.put("passwordPolicy.AlreadyWritten", String.valueOf(true));
            this.put("Recovery.Notification.InternallyManage", String.valueOf(true));
            this.put("Recovery.Notification.Username.Enable", String.valueOf(false));
            this.put("Recovery.Notification.Password.Enable", String.valueOf(false));
            this.put("Recovery.ExpiryTime", String.valueOf(1440));
            this.put("Recovery.Question.Password.Enable", String.valueOf(false));
            this.put("Recovery.Question.Password.ReCaptcha.Enable", String.valueOf(true));
            this.put("Recovery.Question.Password.ReCaptcha.MaxFailedAttempts", String.valueOf(3));
            this.put("Recovery.Question.Password.MinAnswers", String.valueOf(2));
            this.put("Recovery.Question.Password.NotifyStart", String.valueOf(true));
            this.put("Recovery.NotifySuccess", String.valueOf(true));
            this.put("account-recovery.AlreadyWritten", String.valueOf(true));
            this.put("SelfRegistration.LockOnCreation", String.valueOf(true));
            this.put("SelfRegistration.ReCaptcha", String.valueOf(true));
            this.put("SelfRegistration.Enable", String.valueOf(false));
            this.put("SelfRegistration.Notification.InternallyManage", String.valueOf(true));
            this.put("self-sign-up.AlreadyWritten", String.valueOf(true));
            this.put("EmailVerification.LockOnCreation", String.valueOf(false));
            this.put("EmailVerification.Enable", String.valueOf(false));
            this.put("EmailVerification.Notification.InternallyManage", String.valueOf(true));
            this.put("user-email-verification.AlreadyWritten", String.valueOf(true));
            this.put("Recovery.AdminPasswordReset.RecoveryLink", String.valueOf(false));
            this.put("Recovery.AdminPasswordReset.Offline", String.valueOf(false));
            this.put("Recovery.AdminPasswordReset.OTP", String.valueOf(false));
            this.put("admin-forced-password-reset.AlreadyWritten", String.valueOf(true));
        }
    };

    public void migrateResidentIdpMetaData(boolean migrateActiveTenantsOnly) throws Exception {
        Tenant[] tenants;
        IdpMetaDataDAO idpMetaDataDAO = IdpMetaDataDAO.getInstance();
        for (Tenant tenant : tenants = ISMigrationServiceDataHolder.getRealmService().getTenantManager().getAllTenants()) {
            try {
                if (migrateActiveTenantsOnly && !tenant.isActive()) {
                    this.log.info((Object)("Tenant " + tenant.getDomain() + " is inactive. Skipping Resident IDP metadata migration!!!!"));
                    continue;
                }
                int idpId = idpMetaDataDAO.getResidentIdpId(tenant.getId());
                if (idpId == -9999) {
                    this.log.error((Object)("Couldn't find resident idp id of tenant : " + tenant.getDomain()));
                    continue;
                }
                List<String> availablePropertyNames = idpMetaDataDAO.getAvailableConfigNames(tenant.getId(), idpId);
                ArrayList<IdpMetaDataDAO.IdpMetaData> idpMetaDataToAdd = new ArrayList<IdpMetaDataDAO.IdpMetaData>();
                for (Map.Entry<String, String> entry : DEFAULT_PROPERTIES.entrySet()) {
                    if (availablePropertyNames.contains(entry.getKey())) continue;
                    String msg = "Setting '%s' default connector property value to '%s' in tenant : %s";
                    this.log.info((Object)String.format(msg, entry.getKey(), entry.getValue(), tenant.getDomain()));
                    idpMetaDataToAdd.add(new IdpMetaDataDAO.IdpMetaData(idpId, entry.getKey(), entry.getValue(), null, tenant.getId()));
                }
                idpMetaDataDAO.addIdpMetaData(idpMetaDataToAdd);
            }
            catch (Exception ex) {
                this.log.error((Object)("Error while migrating IDP metadata of tenant : " + tenant.getDomain()), (Throwable)ex);
            }
        }
    }
}

