/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.is.migration.service.v530.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ClaimDialectDAO;
import org.wso2.carbon.identity.core.migrate.MigrationClientException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.is.migration.service.v530.bean.Claim;
import org.wso2.carbon.is.migration.service.v530.bean.MappedAttribute;
import org.wso2.carbon.utils.DBUtils;

public class ClaimDAO {
    private static Log log = LogFactory.getLog(ClaimDialectDAO.class);
    private static ClaimDAO claimDAO = new ClaimDAO();

    private ClaimDAO() {
    }

    public static ClaimDAO getInstance() {
        return claimDAO;
    }

    public void addClaimDialect(String claimDialectURI, int tenantId) throws MigrationClientException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        String query = "INSERT INTO IDN_CLAIM_DIALECT (DIALECT_URI, TENANT_ID) VALUES (?, ?)";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, claimDialectURI);
            prepStmt.setInt(2, tenantId);
            prepStmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            throw new MigrationClientException("Error while adding claim dialect " + claimDialectURI, (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public int getClaimDialect(String claimDialectURI, int tenantId) throws MigrationClientException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        String getQuery = "SELECT ID FROM IDN_CLAIM_DIALECT WHERE DIALECT_URI= ? AND TENANT_ID = ? ";
        int id = 0;
        try {
            prepStmt = connection.prepareStatement(getQuery);
            prepStmt.setString(1, claimDialectURI);
            prepStmt.setInt(2, tenantId);
            ResultSet rs = prepStmt.executeQuery();
            if (rs.next()) {
                id = rs.getInt("ID");
            }
        }
        catch (SQLException e) {
            throw new MigrationClientException("Error while adding claim dialect " + claimDialectURI, (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
        return id;
    }

    public void addLocalClaim(Claim claim) throws MigrationClientException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        String localClaimURI = claim.getClaimURI();
        int localClaimId = 0;
        try {
            connection.setAutoCommit(false);
            localClaimId = this.getClaimId(connection, "http://wso2.org/claims", localClaimURI, claim.getTenantId());
            if (localClaimId == 0) {
                localClaimId = this.addClaim(connection, claim.getDialectURI(), localClaimURI, claim.getTenantId());
                if (localClaimId == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"JDBC Driver did not return the claimId, executing Select operation");
                    }
                    localClaimId = this.getClaimId(connection, "http://wso2.org/claims", localClaimURI, claim.getTenantId());
                }
                HashMap<String, String> claimProperties = new HashMap<String, String>();
                if (StringUtils.isNotBlank((String)claim.getDescription())) {
                    claimProperties.put("Description", claim.getDescription());
                }
                if (StringUtils.isNotBlank((String)claim.getDisplayTag())) {
                    claimProperties.put("DisplayName", claim.getDisplayTag());
                }
                if (StringUtils.isNotBlank((String)claim.getRegEx())) {
                    claimProperties.put("RegEx", claim.getRegEx());
                }
                if (StringUtils.isNotBlank((String)String.valueOf(claim.getDisplayOrder()))) {
                    claimProperties.put("DisplayOrder", String.valueOf(claim.getDisplayOrder()));
                }
                if (StringUtils.isNotBlank((String)String.valueOf(claim.isReadOnly()))) {
                    claimProperties.put("ReadOnly", String.valueOf(claim.isReadOnly()));
                }
                if (StringUtils.isNotBlank((String)String.valueOf(claim.isRequired()))) {
                    claimProperties.put("Required", String.valueOf(claim.isRequired()));
                }
                if (StringUtils.isNotBlank((String)String.valueOf(claim.isSupportedByDefault()))) {
                    claimProperties.put("SupportedByDefault", String.valueOf(claim.isSupportedByDefault()));
                }
                this.addClaimProperties(connection, localClaimId, claimProperties, claim.getTenantId());
                for (MappedAttribute mappedAttribute : claim.getAttributes()) {
                    this.addClaimAttributeMappings(connection, localClaimId, mappedAttribute.getAttribute(), mappedAttribute.getDomain(), claim.getTenantId());
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollBack((Connection)connection);
            throw new MigrationClientException("Error while adding local claim " + localClaimURI, (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public int addClaim(Connection connection, String claimDialectURI, String claimURI, int tenantId) throws MigrationClientException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int claimId = 0;
        String query = "INSERT INTO IDN_CLAIM (DIALECT_ID, CLAIM_URI, TENANT_ID) VALUES ((SELECT ID FROM IDN_CLAIM_DIALECT WHERE DIALECT_URI=? AND TENANT_ID=?), ?, ?)";
        try {
            String dbProductName = connection.getMetaData().getDatabaseProductName();
            prepStmt = connection.prepareStatement(query, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"ID")});
            prepStmt.setString(1, claimDialectURI);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, claimURI);
            prepStmt.setInt(4, tenantId);
            prepStmt.executeUpdate();
            rs = prepStmt.getGeneratedKeys();
            if (rs.next()) {
                claimId = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new MigrationClientException("Error while adding claim " + claimURI + " to dialect " + claimDialectURI, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(rs);
                IdentityDatabaseUtil.closeStatement(prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)rs);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        return claimId;
    }

    private void addClaimAttributeMappings(Connection connection, int localClaimId, String mappedAttribute, String mappedAttributeDomain, int tenantId) throws MigrationClientException {
        PreparedStatement prepStmt = null;
        if (localClaimId > 0 && mappedAttribute != null) {
            try {
                if (mappedAttributeDomain == null) {
                    mappedAttributeDomain = IdentityUtil.getPrimaryDomainName();
                }
                String query = "INSERT INTO IDN_CLAIM_MAPPED_ATTRIBUTE (LOCAL_CLAIM_ID, USER_STORE_DOMAIN_NAME, ATTRIBUTE_NAME, TENANT_ID) VALUES (?, ?, ?, ?)";
                prepStmt = connection.prepareStatement(query);
                prepStmt.setInt(1, localClaimId);
                prepStmt.setString(2, mappedAttributeDomain);
                prepStmt.setString(3, mappedAttribute);
                prepStmt.setInt(4, tenantId);
                prepStmt.execute();
            }
            catch (SQLException e) {
                try {
                    throw new MigrationClientException("Error while adding attribute mappings", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeStatement(prepStmt);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    private void addClaimProperties(Connection connection, int localClaimId, Map<String, String> claimProperties, int tenantId) throws MigrationClientException {
        PreparedStatement prepStmt = null;
        if (localClaimId > 0 && claimProperties != null) {
            try {
                String query = "INSERT INTO IDN_CLAIM_PROPERTY (LOCAL_CLAIM_ID, PROPERTY_NAME, PROPERTY_VALUE, TENANT_ID) VALUES (?, ?, ?, ?)";
                prepStmt = connection.prepareStatement(query);
                for (Map.Entry<String, String> property : claimProperties.entrySet()) {
                    prepStmt.setInt(1, localClaimId);
                    prepStmt.setString(2, property.getKey());
                    prepStmt.setString(3, property.getValue() != null ? property.getValue() : "");
                    prepStmt.setInt(4, tenantId);
                    prepStmt.addBatch();
                }
                prepStmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new MigrationClientException("Error while adding claim properties", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeStatement(prepStmt);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    public int getClaimId(Connection connection, String claimDialectURI, String claimURI, int tenantId) throws MigrationClientException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int claimId = 0;
        String query = "SELECT ID FROM IDN_CLAIM WHERE DIALECT_ID=(SELECT ID FROM IDN_CLAIM_DIALECT WHERE DIALECT_URI=? AND TENANT_ID=?) AND CLAIM_URI=? AND TENANT_ID=?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, claimDialectURI);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, claimURI);
            prepStmt.setInt(4, tenantId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                claimId = rs.getInt("ID");
            }
        }
        catch (SQLException e) {
            try {
                throw new MigrationClientException("Error while retrieving ID for claim " + claimURI + " in dialect " + claimDialectURI, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(rs);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)rs);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        return claimId;
    }

    public String getClaimURI(Connection connection, String claimDialectURI, int claimId, int tenantId) throws MigrationClientException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String claimURI = null;
        String query = "SELECT CLAIM_URI FROM IDN_CLAIM WHERE DIALECT_ID=(SELECT ID FROM IDN_CLAIM_DIALECT WHERE DIALECT_URI=? AND TENANT_ID=?) AND ID=? AND TENANT_ID=?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, claimDialectURI);
            prepStmt.setInt(2, tenantId);
            prepStmt.setInt(3, claimId);
            prepStmt.setInt(4, tenantId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                claimURI = rs.getString("CLAIM_URI");
            }
        }
        catch (SQLException e) {
            try {
                throw new MigrationClientException("Error while retrieving URI for claim " + claimURI + " in dialect " + claimDialectURI, (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(rs);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)rs);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        return claimURI;
    }

    public List<Integer> getClaimIdFromMappedAttributes(Connection connection, String mappedAttribute, String mappedAttributeDomain, int tenantId) throws MigrationClientException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<Integer> localIds = new ArrayList<Integer>();
        String query = "SELECT LOCAL_CLAIM_ID FROM IDN_CLAIM_MAPPED_ATTRIBUTE WHERE USER_STORE_DOMAIN_NAME = ? AND ATTRIBUTE_NAME =? AND TENANT_ID=?";
        try {
            if (mappedAttributeDomain == null) {
                mappedAttributeDomain = IdentityUtil.getPrimaryDomainName();
            }
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, mappedAttributeDomain);
            prepStmt.setString(2, mappedAttribute);
            prepStmt.setInt(3, tenantId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                localIds.add(rs.getInt("LOCAL_CLAIM_ID"));
            }
        }
        catch (SQLException e) {
            try {
                throw new MigrationClientException("Error while retrieving LOCAL_CLAIM_ID for claim " + mappedAttribute + " in tenant : " + IdentityTenantUtil.getTenantDomain((int)tenantId), (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(rs);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)rs);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        return localIds;
    }

    public void addExternalClaim(Claim claim, StringBuilder report) throws MigrationClientException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        String externalClaimURI = claim.getClaimURI();
        String externalClaimDialectURI = claim.getDialectURI();
        int externalClaimId = 0;
        try {
            connection.setAutoCommit(false);
            externalClaimId = this.getClaimId(connection, externalClaimDialectURI, externalClaimURI, claim.getTenantId());
            if (externalClaimId == 0) {
                externalClaimId = this.addClaim(connection, externalClaimDialectURI, externalClaimURI, claim.getTenantId());
                if (externalClaimId == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"JDBC Driver did not return the claimId, executing Select operation");
                    }
                    externalClaimId = this.getClaimId(connection, externalClaimDialectURI, externalClaimURI, claim.getTenantId());
                }
                List<Integer> commonLocalClaimIds = null;
                for (MappedAttribute mappedAttribute : claim.getAttributes()) {
                    List<Integer> localClaimIds = this.getClaimIdFromMappedAttributes(connection, mappedAttribute.getAttribute(), mappedAttribute.getDomain(), claim.getTenantId());
                    if (commonLocalClaimIds == null) {
                        commonLocalClaimIds = localClaimIds;
                        continue;
                    }
                    commonLocalClaimIds = this.intersection(commonLocalClaimIds, localClaimIds);
                }
                if (commonLocalClaimIds.size() > 0) {
                    this.addClaimMapping(connection, externalClaimId, (Integer)commonLocalClaimIds.get(0), claim.getTenantId());
                    String localClaimURI = this.getClaimURI(connection, "http://wso2.org/claims", commonLocalClaimIds.get(0), claim.getTenantId());
                    report.append("\n\n Added Remote Claim  :" + claim.getDialectURI() + " in Dialect : " + claim.getDialectURI() + " in  tenant domain :" + IdentityTenantUtil.getTenantDomain((int)claim.getTenantId()) + " , Mapped Local claim :" + localClaimURI);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\n Added Remote Claim  :" + claim.getDialectURI() + " in Dialect : " + claim.getDialectURI() + " in  tenant domain :" + IdentityTenantUtil.getTenantDomain((int)claim.getTenantId()) + " , Mapped Local claim :" + localClaimURI));
                    }
                } else {
                    int newClaimId;
                    Random random = new Random();
                    int random_number = random.nextInt(100000);
                    if (StringUtils.isNotBlank((String)claim.getDisplayTag())) {
                        newClaimId = this.addClaim(connection, "http://wso2.org/claims", "http://wso2.org/claims/migration__" + claim.getDisplayTag().toLowerCase() + "__" + random_number, claim.getTenantId());
                        this.logReport(report, "\n\n No matching local claim found for external claim :" + claim.getClaimURI() + " in claim dialect :" + claim.getDialectURI() + " in tenant domain :" + IdentityTenantUtil.getTenantDomain((int)claim.getTenantId()) + ". So create a new local claim named : " + "http://wso2.org/claims" + "/migration__" + claim.getDisplayTag().toLowerCase() + "__" + random_number);
                    } else {
                        newClaimId = this.addClaim(connection, "http://wso2.org/claims", "http://wso2.org/claims/migration__" + random_number, claim.getTenantId());
                        this.logReport(report, "\n\n No matching local claim found for external claim :" + claim.getClaimURI() + " in claim dialect :" + claim.getDialectURI() + " in tenant domain :" + IdentityTenantUtil.getTenantDomain((int)claim.getTenantId()) + ". So create a new local claim named : " + "http://wso2.org/claims" + "/migration__" + random_number);
                    }
                    HashMap<String, String> claimProperties = new HashMap<String, String>();
                    claimProperties.put("Description", claim.getDescription());
                    claimProperties.put("DisplayName", "Migration__" + claim.getDisplayTag());
                    this.addClaimProperties(connection, newClaimId, claimProperties, claim.getTenantId());
                    for (MappedAttribute mappedAttribute : claim.getAttributes()) {
                        this.addClaimAttributeMappings(connection, newClaimId, mappedAttribute.getAttribute(), mappedAttribute.getDomain(), claim.getTenantId());
                    }
                    this.addClaimMapping(connection, externalClaimId, newClaimId, claim.getTenantId());
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollBack((Connection)connection);
            throw new MigrationClientException("Error while adding external claim " + externalClaimURI + " to dialect " + externalClaimDialectURI, (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    private void logReport(StringBuilder report, String str) {
        report.append(str);
        if (log.isDebugEnabled()) {
            log.debug((Object)str);
        }
    }

    private void addClaimMapping(Connection connection, int externalClaimId, int localClaimId, int tenantId) throws MigrationClientException {
        PreparedStatement prepStmt = null;
        String query = "INSERT INTO IDN_CLAIM_MAPPING (MAPPED_LOCAL_CLAIM_ID, EXT_CLAIM_ID, TENANT_ID) VALUES (?, ?, ?)";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setInt(1, localClaimId);
            prepStmt.setInt(2, externalClaimId);
            prepStmt.setInt(3, tenantId);
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new MigrationClientException("Error while adding claim mapping", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    private <T> List<T> intersection(List<T> list1, List<T> list2) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            list.add(t);
        }
        return list;
    }
}

